<?php 
/*
Fungsi : Controller untuk accounting stock adjustment (MI07)
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Acc_adj_stock extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_acc_adj_stock  = 161;
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	


/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('accounting/acc_report_model', '', TRUE);
		$this->load->model('branch/branch_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->acc_adj_stock_post();
		
	}
	
	//Cek valid amount
	public function valid_storage()
	{
		if($this->input->post('txt_cab_stor') != $this->input->post('txt_sap_sloc'))
		{
			$this->form_validation->set_message('valid_storage', 'Error, storage not match!');
			return FALSE;
		}
		else
		{
			
			return TRUE;
		}
		
	}
	
	function acc_adj_stock_post()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_acc_adj_stock);
		
		$data['menu_path'] = 'ACCOUNTING > ACCOUNTING ADJUSTMENT > POST INV. DIFFERENCES';
		$data['form_action']= site_url('accounting/acc_adj_stock/acc_adj_stock_post_prev');
		$data['prev'] = '';
		$data['cab'] =   $this->acc_report_model->get_cabang()->result();
		$this->load->view('accounting/acc_adj_stock_form', $data);	
		
	}
	
	function acc_adj_stock_post_prev()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_acc_adj_stock);
		/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_invdoc',
                     'label'   => 'Inventory Document',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'txt_year',
                     'label'   => 'Document Year',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
			if ($this->form_validation->run() == TRUE)
			{
				$data['menu_path'] = 'ACCOUNTING > ACCOUNTING ADJUSTMENT > POST INV. DIFFERENCES > PREVIEW';
				$data['form_action']= site_url('accounting/acc_adj_stock/acc_adj_stock_post_proc');
				$data['prev'] = 1;
				
				$cab = $this->acc_report_model->get_cabang_byidcab($this->input->post('cb_idcab'))->result();
				foreach ($cab  as $cabs);
				$data['txt_cab_desc'] = $cabs->cabname;
				$data['txt_cab_stor'] = $cabs->lgort;
				
				$data['txt_idcab'] = $this->input->post('cb_idcab');
				$data['txt_invdoc'] = $this->input->post('txt_invdoc');
				$data['txt_year'] = $this->input->post('txt_year');
				$data['txt_postdate'] = $this->input->post('txt_postdate');
				
				$this->load->view('accounting/acc_adj_stock_form', $data);	
			}
			else
			{
				$this->acc_adj_stock_post();
				
			}
	}
	
	function acc_adj_stock_post_proc()
	{
		/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_cab_stor',
                     'label'   => 'Storage',
                     'rules'   => 'callback_valid_storage'
                  )
            );
		$this->form_validation->set_rules($config); 
		
			if ($this->form_validation->run() == TRUE)
			{
				$this->fungsi_sap->fm_post_inv_dif($this->input->post('txt_invdoc'),$this->input->post('txt_year'),$this->input->post('txt_postdate2'));
				
				if($this->session->userdata('sap_invdoc_no')!= '')
				{
					
					//Insert Stock
					$stock = array(	'ref' => $this->session->userdata('sap_invdoc_no'),
						'idcab'	=> $this->input->post('txt_idcab'),
						'qty' => $this->fungsi->hapus_koma($this->input->post('txt_qty')),
						'year' => date("Y", strtotime($this->input->post('txt_postdate2'))),
						'addby'	=> $this->session->userdata('uid'),
						'postdate' => date("Y-m-d", strtotime($this->input->post('txt_postdate2'))),
						'adddate' => date( 'Y-m-d H:i:s'),
						);
					$this->branch_model->add_stock($stock);	
					
					$this->session->set_flashdata('message_ok', 'Success, SAP Number :'.$this->session->userdata('sap_invdoc_no'));
					redirect('accounting/acc_adj_stock');
				}
			}
			else
			{
				$this->acc_adj_stock_post_prev();
				
			}
		
	}
}