<?php 
/*
Fungsi : Controller untuk MIRO
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Miro extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_create_miro  = 84;
	var $menu_reverse_miro  = 89;

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	
/* Check CPV exist */
	public function cpv_check($miro)
	{	
		//Check apakah document MIRO sudah dibuat CPV ?
		$query_po_detail = $this->branch_model->get_po_bymiroyear($miro, $this->input->post('txt_year'));
		//print_r($query_po_detail );
		foreach ($query_po_detail->result() as $row_po);
		
		if( $row_po->nocpvform != '' )
		{
			$this->form_validation->set_message('cpv_check', 'CPV No : '.$row_po->nocpvform.' has been created, please cancel it first');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}

/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('accounting/acc_model', '', TRUE);
		$this->load->model('branch/branch_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->acc_miro_pending();
		
	}
	
	//Reverse MIRO
	function reverse()
	{
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_reverse_miro);
		
		$data['menu_path'] = 'ACCOUNTING > REVERSE MIRO';
		$data['form_action']= site_url('accounting/miro/post_miroreverse_proc');
		$this->load->view('accounting/acc_miroreverse_form', $data);
		
		
	}
	
	
	//Reverse MIRO Proc
	function post_miroreverse_proc()
	{
		
		//Config utk validasi
	$config = array(
               array(
                     'field'   => 'txt_miro',
                     'label'   => 'MIRO',
                     'rules'   => 'required|callback_cpv_check'
                  ),
               array(
                     'field'   => 'txt_year',
                     'label'   => 'Fiscal Year',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_postdate',
                     'label'   => 'Posting Date',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_cancel',
                     'label'   => 'Cancel reason',
                     'rules'   => 'required'
                  )
            );
	
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
		
			$this->fungsi_sap->fm_reverse_miro($this->input->post('txt_miro'), $this->input->post('txt_year'), $this->input->post('cb_reason') ,$this->input->post('txt_postdate'));
			
			if($this->session->userdata('sap_mirorev_num') != '')
			{
					$query_po_detail = $this->branch_model->get_po_bymiroyear( $this->input->post('txt_miro'), $this->input->post('txt_year'));
					foreach ($query_po_detail->result() as $row_po);
					
				//Insert to table MIRO history cancel
				$hmirocan = array('ebeln' => $row_po->ebeln,
							'year'	=>  $row_po->year,
							'miro' => $this->input->post('txt_miro'),
							'miro_cancel' => $this->session->userdata('sap_mirorev_num'),
							'reason' => $this->input->post('txt_cancel'),
							'canby' => $this->session->userdata('uid'),
							'candate' => date( 'Y-m-d H:i:s'),
							);	
				$this->acc_model->add_hmirocan($hmirocan);
				
				//Update table PO
				$po = array('miro' => '',
							'miraddby'	=> '',
							'miradddate' => '',
							);
				$this->branch_model->update_po($row_po->ebeln, $row_po->year,$po);
				
				$this->session->set_flashdata('message_ok', 'MIRO Reverse, No : '.$this->session->userdata('sap_mirorev_num'));
				redirect('accounting/miro/reverse');
			}
			
			}
		else
		{
			$this->reverse();
		}
			
		
	}
	
	function acc_miro_pending()
	{
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//print_r($this->fin_model->get_list_cpv_pend_paging($this->config->item('paging_limit'), $offset)->result());
		 
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_miro);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$po = $this->acc_model->get_list_po($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->acc_model->get_list_po_count();
		
		$config['base_url'] = site_url('accounting/miro/acc_miro_pending/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. PO', 'Vendor', 'Branch', 'Price/Liter', 'Total Liter', 'R. Disc', 'Total Before PPN', 'PPN', 'Total After PPN','Add by','Add date','Options');
					
					foreach ($po  as $pos)
					{	
						$this->table->add_row($pos->ebeln, $pos->vendor, $pos->cabname, $this->fungsi->format_idr($pos->net_price), number_format($pos->quantity),$this->fungsi->format_idr($pos->disc), $this->fungsi->format_idr(($pos->net_price*$pos->quantity) - $pos->disc), $this->fungsi->format_idr($pos->tax), $this->fungsi->format_idr((($pos->net_price*$pos->quantity) - $pos->disc) + $pos->tax),$pos->addby, $pos->adddate, anchor('accounting/miro/post_miro/'.$pos->ebeln.'/'.$pos->year,'Posting',array('class' => 'update')));	
					}
					
					$data['table'] = $this->table->generate();
				}
				
				else
				{
					$data['message'] = 'No data';
				}
					
		$data['menu_path'] = 'ACCOUNTING > LIST MIRO PENDING';
		$this->load->view('accounting/acc_po_list', $data);
		
		
	}
	
function post_miro()
{
	$query_po_detail = $this->acc_model->get_po_detail($this->uri->segment(4),$this->uri->segment(5));
	foreach ($query_po_detail->result() as $row_po)
		{
			$data['ebeln'] = $row_po->ebeln;
			$data['preq_no'] = $row_po->preq_no;
			$data['cabname'] = $row_po->cabname;
			$data['migo'] = $row_po->mblnr;
			$data['quantity'] = $row_po->quantity;
			$data['net_price'] = $row_po->net_price;
			$data['disc'] = $row_po->disc;
			$data['ppn'] = $row_po->tax;
			$data['vendor'] = $row_po->vendor;
			$data['add_by'] = $row_po->addby;
			$data['add_date'] = $row_po->adddate;
			
			$data['total'] = ($row_po->net_price * $row_po->quantity) - $row_po->disc;
			$data['totalall'] = (($row_po->net_price * $row_po->quantity) - $row_po->disc) + $row_po->tax;
		}
	//Get data inf
	$query_op_inf = $this->acc_model->get_pr_byponum($row_po->ebeln,$row_po->year);
	foreach ($query_op_inf->result() as $row_op);
	$data['inf'] = $row_op->inf;
	
	$data['menu_path'] = 'ACCOUNTING > CREATE MIRO > PO NO : '.$this->uri->segment(4);
	$data['form_action']= site_url('accounting/miro/post_miro_proc'.'/'.$this->uri->segment(4).'/'.$this->uri->segment(5));
	$this->load->view('accounting/acc_postmiro_form', $data);
}

function post_miro_proc()
{

	$this->fungsi_sap->fm_create_miro($this->input->post('txt_bldat'), $this->input->post('txt_budat'), $this->input->post('txt_total'), $this->input->post('txt_po'), $this->input->post('txt_migo'),  $this->input->post('txt_total2'),$this->input->post('txt_qty'), 'Z01', $this->input->post('txt_ppn'), $this->input->post('txt_inf'));
	
	/*Update data PO*/
					$po = array( 		'miro'		 => $this->session->userdata('sap_miro_num'),
										'miraddby'	 => $this->session->userdata('uid'),
										'miradddate' => date( 'Y-m-d H:i:s'),
								);
	if($this->session->userdata('sap_miro_num') != '')
	{							
	$this->acc_model->update_po($this->uri->segment(4),$this->uri->segment(5),$po);		
	
	//send email notification
			$var = array($this->session->userdata('sap_miro_num'), $this->session->userdata('uid'),$this->input->post('txt_po'),number_format($this->input->post('txt_qty')),$this->fungsi->format_idr($this->input->post('txt_total')),$this->fungsi->format_idr($this->input->post('txt_disc')),$this->fungsi->format_idr($this->input->post('txt_ppn')));
			$this->fungsi->send_notif(10, $var);
	}
	$this->session->set_flashdata('message_ok', 'MIRO Created, MIRO number :'.$this->session->userdata('sap_miro_num').' ACC No : '.$this->fungsi_sap->fm_accno_miro($this->session->userdata('sap_miro_num').date('Y')));
	redirect('accounting/miro/acc_miro_pending');	
}

}