<?php 
/*
Fungsi : Controller untuk admin cabang
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin_cabang extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_cabang  = 43;
	var $menu_add_cabang = 42;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/	

/* Fungsi untuk convert status cabang */
 	function convert_status_cab($status)
	{
		
		switch ($status)
		{
			case 1:
			  $status = '<font color="#00CC00"><b>Active</b></font>';
			  break;
			case 0:
			  $status = '<font color="#FF0000"><b>Not active</b></font>';
			  break;
		}
	
	return $status;
		
	}
	
/* Check ID cabang exist */
	public function idcab_check($idcab)
	{	
		$sql_idcab_check = $this->admin_model->search_idcab($idcab)->result();
		
		if ($this->fungsi->is_array_empty($sql_idcab_check)==FALSE) 
		{
			$this->form_validation->set_message('idcab_check', '%s '.$idcab.' already exist, please choose another ID');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
		
	}
/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->admin_add_cabang();
		
	}

	/* Admin add cabang */
	function admin_add_cabang()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_cabang);
			
		$data['menu_path'] = 'ADMIN > BRANCH > ADD BRANCH';
		$data['form_action']= site_url('admin/admin_cabang/add_cabang_proc');
		$this->load->view('admin/admin_cabang_form', $data);
		
	}
	
	
	/* Admin add cabang process */
	function add_cabang_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		//Config utk validasi form cabang
	$config = array(
               array(
                     'field'   => 'txt_idcab',
                     'label'   => 'Branch ID',
                     'rules'   => 'required|callback_idcab_check'
                  ),
               array(
                     'field'   => 'txt_cabname',
                     'label'   => 'Name',
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'txt_lifnr',
                     'label'   => 'Vendor Code SAP',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'txt_pic',
                     'label'   => 'PIC',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_lgort',
                     'label'   => 'Storage Code SAP',
                     'rules'   => 'required'
                  )
				  ,
				   array(
                     'field'   => 'txt_max_stor',
                     'label'   => 'Storage Max Capacity',
                     'rules'   => 'required'
                  )
				   ,array(
                     'field'   => 'txt_pcglaccuo',
                     'label'   => 'Petty Cash Account',
                     'rules'   => 'required'
					 )
					    ,array(
                     'field'   => 'txt_pcglaccop',
                     'label'   => 'Petty Cash Account',
                     'rules'   => 'required'
					 )
					 ,array(
                     'field'   => 'txt_costctr',
                     'label'   => 'Cost Center',
                     'rules'   => 'required'
					 )
					    ,array(
                     'field'   => 'txt_pcbankglacc',
                     'label'   => 'Petty Cash Account',
                     'rules'   => 'required'
					 )
					   ,array(
                     'field'   => 'txt_shortname',
                     'label'   => 'Branch Shortname',
                     'rules'   => 'required'
					 )
					 ,array(
                     'field'   => 'txt_max_pc_op',
                     'label'   => 'Maximum PC OP Transfer',
                     'rules'   => 'required'
					 )
				
				  //Not validate form
				  ,array(
                     'field'   => 'txt_addr',
                     'label'   => 'Address',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'rg_active',
                     'label'   => 'Status',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_prov',
                     'label'   => 'Prov',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_city',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_fax',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'txt_phone',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$cabang = array( 	'idcab'		=> $this->input->post('txt_idcab'),
								'cabname'	=> $this->input->post('txt_cabname'),
								'addr'		=> $this->input->post('txt_addr'),
								'active'	=> $this->input->post('rg_active'),
								'pic'		=> $this->input->post('txt_pic'),
								'phone'		=> $this->input->post('txt_phone'),
								'city'		=> $this->input->post('txt_city'),
								'fax'		=> $this->input->post('txt_fax'),
								'prov'		=> $this->input->post('txt_prov'),
								'pcglaccuo'	=> $this->input->post('txt_pcglaccuo'),
								'pcglaccop'	=> $this->input->post('txt_pcglaccop'),
								'pcbankglacc'	=> $this->input->post('txt_pcbankglacc'),
								'costctr'	=> $this->input->post('txt_costctr'),
								'cabshorttxt'	=> $this->input->post('txt_shortname'),
								'max_stor'	=> $this->fungsi->hapus_koma($this->input->post('txt_max_stor')),
								'max_pcop_trf'	=> $this->fungsi->convert_idr_to_num($this->input->post('txt_max_pc_op')),
								'lifnr'		=> $this->input->post('txt_lifnr'),
								'werks'		=> $this->input->post('txt_werks'),
								'lgort'		=> $this->input->post('txt_lgort'),
								'addby'		=> $this->session->userdata('uid'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
						);
			$this->admin_model->add_cabang($cabang);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data saved');
			redirect('admin/admin_cabang');
			}
		else
			{
				$this->admin_add_cabang();
			}
	}
	
	/* Display list cabang */
	function admin_list_cabang()
	{	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_cabang);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$cabang = $this->admin_model->get_cabang_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->admin_model->count_all_cabang();
		$config['base_url'] = site_url('admin/admin_cabang/admin_list_cabang/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('Branch ID', 'Name', 'PIC', 'Status', 'Options');
				
					foreach ($cabang  as $cabangs)
					{	
			
		$this->table->add_row($cabangs->idcab, $cabangs->cabname, $cabangs->pic, $this->convert_status_cab($cabangs->active), anchor('admin/admin_cabang/edit_cabang/'.$cabangs->idcab,'Edit',array('class' => 'update')));	
							
					}
					$data['table'] = $this->table->generate();
					
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'ADMIN > BRANCH > BRANCH LIST';
		$this->load->view('admin/admin_cabang_list', $data);
		
	}
	
	/* Edit cabang */
	function edit_cabang()
	{
		
		//Get data detail cabang by id cabang
		$sql_cab_edit = $this->admin_model->get_cab_detail($this->uri->segment(4));
		
		foreach ($sql_cab_edit->result() as $row_cab)
		{	
			$data['default']['txt_idcab'] = $row_cab->idcab;
			$data['default']['txt_cabname'] = $row_cab->cabname;
			$data['default']['rg_active'] = $row_cab->active;
			$data['default']['txt_pic'] = $row_cab->pic;
			$data['default']['txt_addr'] = $row_cab->addr;
			$data['default']['txt_prov'] = $row_cab->prov;
			$data['default']['txt_city'] =  $row_cab->city;
			$data['default']['txt_fax'] =  	$row_cab->fax;
			$data['default']['txt_phone'] =  $row_cab->phone;
			$data['default']['txt_pcglaccuo'] =  $row_cab->pcglaccuo;
			$data['default']['txt_pcglaccop'] =  $row_cab->pcglaccop;
			$data['default']['txt_pcbankglacc'] =  $row_cab->pcbankglacc;
			$data['default']['txt_costctr'] =  $row_cab->costctr;
			$data['default']['txt_max_stor'] = number_format($row_cab->max_stor);
			$data['default']['txt_lifnr'] =  $row_cab->lifnr;
			$data['default']['txt_werks'] =  $row_cab->werks;
			$data['default']['txt_lgort'] =  $row_cab->lgort;
			$data['default']['txt_shortname'] =  $row_cab->cabshorttxt;
			$data['default']['txt_max_pc_op'] =  $this->fungsi->format_idr($row_cab->max_pcop_trf);
		}
		$data['default']['readonly'] =  'readonly="readonly"';
		
		$data['menu_path'] = 'ADMIN > BRANCH > LIST BRANCH > EDIT BRANCH';
		$data['form_action']= site_url('admin/admin_cabang/edit_cabang_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('admin/admin_cabang/admin_list_cabang','Back', array('class' => 'back')));
		$this->load->view('admin/admin_cabang_form', $data);
	}
	
	
	/* Admin edit cabang process */
	function edit_cabang_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		//Config utk validasi form cabang
 $config = array(
                array(
                     'field'   => 'txt_cabname',
                     'label'   => 'Name',
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'txt_lifnr',
                     'label'   => 'Vendor Code SAP',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'txt_pic',
                     'label'   => 'PIC',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_lgort',
                     'label'   => 'Storage Code SAP',
                     'rules'   => 'required'
                  )
				  ,
				   array(
                     'field'   => 'txt_max_stor',
                     'label'   => 'Storage Max Capacity',
                     'rules'   => 'required'
                  )
				   ,
				   array(
                     'field'   => 'txt_max_stor',
                     'label'   => 'Quota maksimal tanki',
                     'rules'   => 'required'
                  )
				  ,array(
                     'field'   => 'txt_pcglaccuo',
                     'label'   => 'Petty Cash Account',
                     'rules'   => 'required'
					 )
					    ,array(
                     'field'   => 'txt_pcglaccop',
                     'label'   => 'Petty Cash Account',
                     'rules'   => 'required'
					 )
					 ,array(
                     'field'   => 'txt_costctr',
                     'label'   => 'Cost Center',
                     'rules'   => 'required'
					 )
					    ,array(
                     'field'   => 'txt_pcbankglacc',
                     'label'   => 'Petty Cash Account',
                     'rules'   => 'required'
					 )
					 ,array(
                     'field'   => 'txt_shortname',
                     'label'   => 'Branch Shortname',
                     'rules'   => 'required'
					 )
					 ,array(
                     'field'   => 'txt_max_pc_op',
                     'label'   => 'Maximum PC OP Transfer',
                     'rules'   => 'required'
					 )
				   //Not validate form
				  ,array(
                     'field'   => 'txt_addr',
                     'label'   => 'Alamat',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'rg_active',
                     'label'   => 'Status',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_prov',
                     'label'   => 'Prov',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_city',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_fax',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'txt_phone',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$cabang = array( 	
								'cabname'	=> $this->input->post('txt_cabname'),
								'addr'		=> $this->input->post('txt_addr'),
								'active'	=> $this->input->post('rg_active'),
								'pic'		=> $this->input->post('txt_pic'),
								'phone'		=> $this->input->post('txt_phone'),
								'city'		=> $this->input->post('txt_city'),
								'fax'		=> $this->input->post('txt_fax'),
								'prov'		=> $this->input->post('txt_prov'),
								'pcglaccuo'	=> $this->input->post('txt_pcglaccuo'),
								'pcglaccop'	=> $this->input->post('txt_pcglaccop'),
								'pcbankglacc'	=> $this->input->post('txt_pcbankglacc'),
								'costctr'	=> $this->input->post('txt_costctr'),
								'max_stor'	=> $this->fungsi->hapus_koma($this->input->post('txt_max_stor')),
								'max_pcop_trf'	=> $this->fungsi->convert_idr_to_num($this->input->post('txt_max_pc_op')),
								'lifnr'		=> $this->input->post('txt_lifnr'),
								'werks'		=> $this->input->post('txt_werks'),
								'lgort'		=> $this->input->post('txt_lgort'),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d H:i:s'),
								'cabshorttxt'	=> $this->input->post('txt_shortname'),
								
						);
			$this->admin_model->update_cab($this->input->post('txt_idcab'), $cabang);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('admin/admin_cabang/admin_list_cabang');
			}
		else
			{
				$this->edit_cabang();
			}
	}
	
}