<?php 
/*
Fungsi : Controller untuk group notification
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Admin_notgrp extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_notgrp  = 67;
	var $menu_add_notgrp = 66;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/	



/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->admin_add_notgrp();
		
	}

	/* Admin add group notification */
	function admin_add_notgrp()
	{	
	
		//Testing
		// $this->fungsi_sap->fm_edit_pr('9800000005',12000,3000);
		 
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_notgrp);
		
		/*Get notification group member*/
		$notgrpusr = $this->admin_model->get_usrnotgrp()->result();
		
		$list = array();
		foreach ($notgrpusr  as $notgrpusrs)
					{	
		
		$list[] = '<input type="checkbox" name="chk_uid[]" id="chk_uid[]" value="'.$notgrpusrs->uid.'"'.set_checkbox('chk_uid[]', $notgrpusrs->uid, isset($default['chk_uid']) && $default['chk_uid'] == $notgrpusrs->uid  ? TRUE : FALSE ).' />'.$notgrpusrs->uid.' ('.$notgrpusrs->email.')';			
					}	
		$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		$new_list = $this->table->make_columns($list, 4);
		$data['table'] = $this->table->generate($new_list);		
		
		
		$data['menu_path'] = 'ADMIN > NOTIFICATION > ADD NOTIFICATION';
		$data['form_action']= site_url('admin/admin_notgrp/add_notgrp_proc');
		$this->load->view('admin/admin_notgrp_form', $data);
		
	}
	
	
	/* Admin add notification group process */
	function add_notgrp_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		//Config utk validasi deskripsi group supplier
	$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Group Name',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_msg',
                     'label'   => 'Message',
                     'rules'   => 'required'
                  ),
				  array(
					'field'   => 'chk_uid[]',
					'label'   => 'Member',
					'rules'   => 'required'
										  )
				,
				  array(
					'field'   => 'txt_subject',
					'label'   => 'Subject',
					'rules'   => 'required'
										  )
				  
            );
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			
			//Get last group not id
			$query_notid =  $this->fungsi->get_last_id('m_notgrp')->result();	
			//print_r($query_roleid);
			foreach($query_notid as $row_notid);
			$last_notid = $row_notid->Auto_increment;
			
			$not_mem = array();
			foreach($this->input->post('chk_uid') as $uid)
			{
				$not_mem[] = array( 	'idnotgrp'		=>  $last_notid ,
										'notgrp_uid'	=> 	$uid,
										'addby'			=> $this->session->userdata('uid'),
										'adddate' 		=> date( 'Y-m-d H:i:s'),
						);
			}
				
			/* Insert data */
			$groupnot = array( 	
								'desc'		=> $this->input->post('txt_desc'),
								'subject'	=> $this->input->post('txt_subject'),
								'msg'		=> $this->input->post('txt_msg'),
								'addby'		=> $this->session->userdata('uid'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
						);
			
			//Utk transaksi multiple gunakan fungsi transaction
			$this->db->trans_begin();
				
				$this->admin_model->add_notgrp($groupnot);
				$this->admin_model->add_grpmem_batch($not_mem);
				
			$this->db->trans_complete(); 
			
			if ($this->db->trans_status() === FALSE)
				{
					$this->session->set_flashdata('message_err', 'Data input error');	
					$this->db->trans_rollback();
				} 
			else
				{
					$this->session->set_flashdata('message_ok', 'Data input succesfully');
					 $this->db->trans_commit();
				}
			
			
			/*Set pesan sukses dan kembali ke menu add group supplier*/
			$this->session->set_flashdata('message_ok', 'Data saved');
			redirect('admin/admin_notgrp');
			}
		else
			{
				$this->admin_add_notgrp();
			}
	}
	
	/* Display list group notification */
	function admin_list_notgrp()
	{	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_notgrp);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$notgrp = $this->admin_model->get_notgrp_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->admin_model->count_all_notgrp();
		$config['base_url'] = site_url('admin/admin_notgrp/admin_list_notgrp/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('Group ID', 'Name', 'Options');
				
					foreach ($notgrp  as $notgrps)
					{	
			
		$this->table->add_row($notgrps->idnotgrp, $notgrps->desc, anchor('admin/admin_notgrp/edit_notgrp/'.$notgrps->idnotgrp,'Edit',array('class' => 'update')).' '.anchor('admin/admin_notgrp/del_notgrp/'.$notgrps->idnotgrp,'Delete',array('class'=> 'delete','onclick'=>"return confirm('Delete notification group with ID ".$notgrps->idnotgrp." ? it will delete members too!')")));	
							
					}
					$data['table'] = $this->table->generate();
					
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'ADMIN > NOTIFICATION > LIST NOTIFICATION';
		$this->load->view('admin/admin_notgrp_list', $data);
		
	}
	
	/* Delete group not */
	function del_notgrp()
	{	
		//Check otorisasirp
		$this->fungsi->trans_auth($this->session->userdata('delete'));
		
		$this->admin_model->del_notgrp($this->uri->segment(4));
		$this->session->set_flashdata('message_ok', 'Supplier group deleted');
		redirect('admin/admin_notgrp/admin_list_notgrp');
	}
	
	
	/* Edit group notification */
	function edit_notgrp()
	{
		
		//Get data member not group by id not group
		$sql_notgrpmem_edit = $this->admin_model->get_grpmem_bygid($this->uri->segment(4));
		$list_user = array();
		foreach ($sql_notgrpmem_edit->result() as $row_notgrpmem)
		{	
			$list_user[]  = $row_notgrpmem->notgrp_uid;
		}
		
		
		//Get data detail not group by id not group
		$sql_notgrp_edit = $this->admin_model->get_notgrp_detail($this->uri->segment(4));
		
		foreach ($sql_notgrp_edit->result() as $row_notgrp)
		{	
			$data['default']['txt_desc'] = $row_notgrp->desc;
			$data['default']['txt_msg'] = $row_notgrp->msg;
			$data['default']['txt_subject'] = $row_notgrp->subject;
		}
		
		/*Get notification group member*/
		$notgrpusr = $this->admin_model->get_usrnotgrp()->result();
		
		$list = array();
		foreach ($notgrpusr  as $notgrpusrs)
					{	
		
		$list[] = '<input type="checkbox" name="chk_uid[]" id="chk_uid[]" value="'.$notgrpusrs->uid.'"'.set_checkbox('chk_uid[]', $notgrpusrs->uid, isset($default['chk_uid']) && $default['chk_uid'] == $notgrpusrs->uid || $this->fungsi->search_array($list_user, $notgrpusrs->uid) == $notgrpusrs->uid ? TRUE : FALSE ).' />'.$notgrpusrs->uid.' ('.$notgrpusrs->email.')';
		//$this->table->add_row($notgrpusrs->uid);			
					}	
		$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		$new_list = $this->table->make_columns($list, 2);
		$data['table'] = $this->table->generate($new_list);		
		$data['menu_path'] = 'ADMIN > NOTIFICATION > EDIT NOTIFICATION';
		$data['form_action']= site_url('admin/admin_notgrp/edit_notgrp_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('admin/admin_notgrp/admin_list_notgrp','Back', array('class' => 'back')));
		$this->load->view('admin/admin_notgrp_form', $data);
	}
	
	
	/* Admin edit group not process */
	function edit_notgrp_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Group Name',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_msg',
                     'label'   => 'Message',
                     'rules'   => 'required'
                  )
				  ,
				  array(
					'field'   => 'chk_uid[]',
					'label'   => 'Member',
					'rules'   => 'required'
				),
				 array(
                     'field'   => 'txt_subject',
                     'label'   => 'Subject',
                     'rules'   => 'required'
                  )
				  
				  
            );
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				
			$not_mem = array();
			foreach($this->input->post('chk_uid') as $uid)
			{
				$not_mem[] = array( 	'idnotgrp'		=>  $this->uri->segment(4),
										'notgrp_uid'	=> 	$uid,
										'addby'			=> $this->session->userdata('uid'),
										'adddate' 		=> date( 'Y-m-d H:i:s'),
						);
			}
				
			/* Update data */
			$groupnot = array( 	
								'desc'		=> $this->input->post('txt_desc'),
								'subject'	=> $this->input->post('txt_subject'),
								'msg'		=> $this->input->post('txt_msg'),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d H:i:s'),
						);
						
			//Utk transaksi multiple gunakan fungsi transaction
			$this->db->trans_begin();
				
				$this->admin_model->del_memgrp($this->uri->segment(4));
				$this->admin_model->update_notgrp($this->uri->segment(4), $groupnot);
				$this->admin_model->add_grpmem_batch($not_mem);
				
			$this->db->trans_complete(); 
			
			if ($this->db->trans_status() === FALSE)
				{
					$this->session->set_flashdata('message_err', 'Data input error');	
					$this->db->trans_rollback();
				} 
			else
				{
					$this->session->set_flashdata('message_ok', 'Data input succesfully');
					 $this->db->trans_commit();
				}			
		
			
			/*Set pesan sukses dan kembali ke menu add not grp*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('admin/admin_notgrp/admin_list_notgrp');
			}
		else
			{
				$this->edit_notgrp();
			}
	}
	
}