<?php 
/*
Fungsi : Controller untuk petty cash operational
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Branch_bpkk extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_add_bpkk  = 103;
	var $menu_print_bpkk  = 104;
	var $menu_post_to_finance  = 106;
	

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	
//Cek valid amount
public function valid_amount($amount)
{
	if($amount > $this->fungsi->get_pc_bal_op($this->session->userdata('idcab')))
	{
		//$this->form_validation->set_message('valid_amount', 'Error, petty cash operational balances is insufficient');
		return FALSE;
	}
	else
	{
		
		return TRUE;
	}
	
}

/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/branch_model', '', TRUE);
		$this->load->model('finance/fin_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->create_bpkk();		
	}
//Cancel rembuirsement
function cancel_rmb()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_post_to_finance);
	
	/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$rmb = $this->branch_model->get_rmb_header_pending($this->session->userdata('idcab'),$this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->branch_model->get_rmb_header_pending_count($this->session->userdata('idcab'));
		
		$config['base_url'] = site_url('branch/branch_bpkk/cancel_rmb/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
		{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. RMB', 'Branch','Total Amount','Add by','Add date','Options');
					
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
					
					foreach ($rmb  as $rmbs)
					{	
						$this->table->add_row($rmbs->normbform, $rmbs->cabname , $this->fungsi->format_idr($rmbs->total), $rmbs->addby, $rmbs->adddate,anchor('branch/branch_bpkk/cancel_rmb_prev/'.$rmbs->idcab.'/'.$rmbs->normb.'/'.$rmbs->year,'Cancel',array('class' => 'delete')).' '.anchor_popup('branch/branch_bpkk/print_rmb_popup/'.$rmbs->idcab.'/'.$rmbs->normb.'/'.$rmbs->year,'Print',array('class' => 'print',$atts),$atts));	
					}
					
					$data['table'] = $this->table->generate();
		}		
		else
		{
			
			$data['message'] = 'No data';
			
		}
		
		$data['menu_path'] = 'BRANCH > BPKK > CANCEL REMBURSEMENT';
		$this->load->view('branch/branch_cancel_rmb', $data);
	
}

//Cetak rembuirsement popup
function print_rmb_popup()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));	
	
	//Get data RMB HEADER by ID CAB, No. RMB & year
	$query_rmb_header = $this->branch_model->get_rmbheader_byidcabnoyear($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
	foreach ($query_rmb_header->result() as $row_rmb_header)
		{
			$data['txt_normbform'] = $row_rmb_header->normbform;
			$data['txt_adddate'] = date("d.m.Y",   strtotime($row_rmb_header->adddate));	
			$data['txt_addby'] = $row_rmb_header->addby;
			if($row_rmb_header->chdate == '0000-00-00 00:00:00')
			{
				$data['txt_chdate'] = '';	
			}
			else
			{
				$data['txt_chdate'] = date("d.m.Y",   strtotime($row_rmb_header->chdate));	
			}
			
			$data['tables']='';
			$query_bpkk_header = $this->fin_model->get_detail_bpkk_header($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
			foreach ($query_bpkk_header->result() as $row_bpkk_header)
			{
						$data['tables'].='<tr>
										  <td width="622" align="left">'.$row_bpkk_header->nobpkkform.'</td>
										  <td width="230" align="right">'.$this->fungsi->format_idr($row_bpkk_header->total).'</td>
											</tr>';
			}
			
			
			$data['txt_total'] = $row_rmb_header->total;
			$data['txt_terbilang'] = $this->fungsi->terbilang($row_rmb_header->total).' RUPIAH';
		}
		
	$this->load->view('popup/popup_rmb', $data);
}

function cancel_rmb_prev()
{
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('cancel'));
	
	//Get data RMB HEADER by ID CAB, No. RMB & year
	$query_rmb_header = $this->branch_model->get_rmbheader_byidcabnoyear($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
	foreach ($query_rmb_header->result() as $row_rmb_header)
		{
			$data['txt_normbform'] = $row_rmb_header->normbform;
			$data['txt_adddate'] = date("d.m.Y",   strtotime($row_rmb_header->adddate));	
			$data['txt_addby'] = $row_rmb_header->addby;
			if($row_rmb_header->chdate == '0000-00-00 00:00:00')
			{
				$data['txt_chdate'] = '';	
			}
			else
			{
				$data['txt_chdate'] = date("d.m.Y",   strtotime($row_rmb_header->chdate));	
			}
			
			$data['txt_total'] = $row_rmb_header->total;
			$data['txt_terbilang'] = $this->fungsi->terbilang($row_rmb_header->total).' RUPIAH';
		}
		
			//Get BPKK Header
	$query_bpkk_header = $this->fin_model->get_detail_bpkk_header($row_rmb_header->idcab,$row_rmb_header->normb, $row_rmb_header->year);
	$data['tables'] = '';
	$totalbpkk = 0;
	$bg=0;
	foreach ($query_bpkk_header->result() as $row_bpkk_header)
		{	
		$totalbpkk = $row_bpkk_header->total + $totalbpkk;
			if($bg==0)
					{
					$data['tables'].="<tr style=background-color:#;>";
					$bg++;
					}
					else
					{
					$data['tables'].="<tr style=background-color:#eeeeee;>";
					$bg--;
					}
					$data['tables'] .= '
										  <td align="center">'.$row_bpkk_header->nobpkkform.'<input type="hidden" name="item[]" id="item[]"  value="'.$row_bpkk_header->idcab.'|'.$row_bpkk_header->nobpkk.'|'.$row_bpkk_header->year.'"/></td>
										  <td align="right">'.$this->fungsi->format_idr($row_bpkk_header->total).'</td>
										  <td align="center">'.anchor_popup('branch/branch_bpkk/print_bpkk_popup/'.$row_bpkk_header->idcab.'/'.$row_bpkk_header->nobpkk.'/'.$row_bpkk_header->year,'Preview',array('class' => 'print')).'</td>
										</tr>';
		}
	$data['totalbpkk'] = $totalbpkk;
		
		$data['menu_path'] = 'BRANCH > BPKK > CANCEL REIMBURSEMENT';
		$data['link'] = array('link_back' => anchor('branch/branch_bpkk/cancel_rmb','Back', array('class' => 'back')));
		$data['form_action']= site_url('branch/branch_bpkk/cancel_rmb_proc/'.$this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6));
		$this->load->view('branch/branch_cancel_rmb_form', $data);	
	
}

function cancel_rmb_proc()
{
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Cancel Reason',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
	if ($this->form_validation->run() == TRUE)
			{
				
				foreach($this->input->post('item') as $val)
				{
				
				$rmb = explode("|", $val);
				//Update BPKK Header
				$bpkkheader = array( 'status'	 => 0,
									'chby'		 => $this->session->userdata('uid'),
									'chdate' 	 => date( 'Y-m-d H:i:s'),
								);
				$this->branch_model->update_bpkkheader($rmb[0],$rmb[1],$rmb[2],$bpkkheader);
			}
			
				$rmbheader = array( 
								'status' => 1,
								'canby' => $this->session->userdata('uid'),
								'candate' => date( 'Y-m-d H:i:s'),
								'candesc' => $this->input->post('txt_desc'),
								);
								
				$this->branch_model->update_rmbheader($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6),$rmbheader);		
				
				$this->session->set_flashdata('message_ok', 'Data cancelled');
	  			redirect('branch/branch_bpkk/print_bpkk/');						
			}
	else
			{
				$this->cancel_rmb_prev();
				
			}
	
}
//Posting BPKK to finance
function post_to_fin()
{
	$data['prev'] = 0;
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_post_to_finance);
	
	/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$bpkk = $this->branch_model->get_list_bpkk($this->session->userdata('idcab'),$this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->branch_model->get_list_bpkk_count($this->session->userdata('idcab'));
		
		$config['base_url'] = site_url('branch/branch_bpkk/post_to_fin/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
		{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('<input type="checkbox" onclick="toggleChecked(this.checked)">','No. BPKK', 'Branch','Type','Total Amount','Add by','Add date','Options');
					
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
					
					foreach ($bpkk  as $bpkks)
					{	
						$this->table->add_row('<input type="checkbox" name="checkbox[]" id="checkbox[]" class="checkbox"  value="'.$bpkks->idcab.'|'.$bpkks->nobpkk.'|'.$bpkks->year.'|'.$bpkks->idpcoprtyp.'"/>',$bpkks->nobpkkform, $bpkks->cabname , $bpkks->desc,$this->fungsi->format_idr($bpkks->total), $bpkks->addby, $bpkks->adddate,anchor_popup('branch/branch_bpkk/print_bpkk_popup/'.$bpkks->idcab.'/'.$bpkks->nobpkk.'/'.$bpkks->year,'Preview',array('class' => 'print',$atts),$atts));	
					}
					
					$data['table'] = $this->table->generate();
		}		
		else
		{
			
			$data['message'] = 'No data';
			
		}
		
		$data['menu_path'] = 'BRANCH > BPKK > POST TO FINANCE';
		$data['form_action']= site_url('branch/branch_bpkk/post_to_fin_prev');
		$this->load->view('branch/branch_bpkk_posttofin', $data);
}

function post_to_fin_prev()
{
	$data['prev'] = 1;
	$config = array(
               array(
                     'field'   => 'checkbox[]',
                     'label'   => 'Data BPKK',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
	if ($this->form_validation->run() == TRUE)
			{	
				$data['tables'] = '';
				$total = 0;
				$bg=0;
				$count_oa = 0;
				$count_op = 0;
				foreach($this->input->post('checkbox') as $val)
				{	
					$bpkk = explode("|", $val);
					
					if($bpkk[3] == 2)
					{
						$count_oa = $count_oa + 1;
					}
					else
					{
						$count_op = $count_op + 1;
					}
					
					
					$bpkks = $this->branch_model->get_bpkkheader_byidcabnoyear($bpkk[0],$bpkk[1],$bpkk[2])->result();
					foreach ($bpkks as $bpkkss);
					$cab = $this->admin_model->get_cab_detail($bpkk[0])->result();
					foreach ($cab as $cabs);
					$total = $total + $bpkkss->total;
					if($bg==0)
					{
					$data['tables'].="<tr style=background-color:#;>";
					$bg++;
					}
					else
					{
					$data['tables'].="<tr style=background-color:#eeeeee;>";
					$bg--;
					}
					$data['tables'] .= '
										  <td align="center">'.$bpkkss->nobpkkform.'<input type="hidden" name="item[]" id="item[]"  value="'.$bpkkss->idcab.'|'.$bpkkss->nobpkk.'|'.$bpkkss->year.'"/></td>
										  <td align="center">'.$cabs->cabname.'</td>
										  <td align="right">'.$this->fungsi->format_idr($bpkkss->total).'</td>
										  <td align="center">'.anchor_popup('branch/branch_bpkk/print_bpkk_popup/'.$bpkkss->idcab.'/'.$bpkkss->nobpkk.'/'.$bpkkss->year,'Preview',array('class' => 'print')).'</td>
										</tr>';
					//echo $bpkkss->idcab.' '.$bpkkss->nobpkk;
					//echo '<br>';
					//get_bpkkheader_byidcabnoyear
					//echo $pieces[0].','.$pieces[1]
				}
				//echo $count_oa;
				//echo $count_op;
				if($count_oa >= 1 && $count_op >= 1 )
			{
				$data['submit'] ='<font color="#FF0000"><b>Only 1 Ongkos angkut item permitted to create rembuirsement!</b></font>';	
			}
			else
			{
				$data['submit'] = '<input type="submit" name="button2" id="button2" value="Submit" class="button" />';
			}
			
			if($count_op > 5)
				{
					$data['submit'] ='<font color="#FF0000"><b>BPPK items restricted to 5 items only!</b></font>';	
				}
				
				$data['total'] = $total;
				$data['menu_path'] = 'BRANCH > BPKK > POSTING TO FINANCE > PREVIEW DATA';
				$data['form_action']= site_url('branch/branch_bpkk/post_to_fin_proc/');
				$this->load->view('branch/branch_bpkk_posttofin', $data);
			}
	else
			{
				
				$this->post_to_fin();
			}
}

function post_to_fin_proc()
{
	
	/*Get RMB counter*/
	$count = array();
	$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'RMB');
	$normbform = $count[0];
	$normb = $count[1];
	
	/*Insert RMB Header*/
	$rmbheader = array( 		'idcab'		=> $this->session->userdata('idcab'),
								'normbform' => $normbform,
								'normb'	 	=> $normb,
								'year'		 => date('Y'),
								'total' 	 =>  $this->input->post('total'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
	/*Insert RMB Detail*/
	$rmbdetail = array();
	
	foreach($this->input->post('item') as $val)
			{
				
				$rmb = explode("|", $val);
				$rmbdetail[] = array( 			'idcab'	 => $this->session->userdata('idcab'),
												'normb'	 	=> $normb,
												'nobpkk'	 => $rmb[1],
												'year'	 => $rmb[2],
												);
				//Update BPKK Header
				$bpkkheader = array( 'status'		=> 2,
									'chby'		 => $this->session->userdata('uid'),
									'chdate' 	 => date( 'Y-m-d H:i:s'),
								);
				$this->branch_model->update_bpkkheader($this->session->userdata('idcab'), $rmb[1], $rmb[2], $bpkkheader);
			}
		
		
		$this->branch_model->add_rmb_header($rmbheader);	
		$this->branch_model->add_rmb_detail($rmbdetail);	
					
		//Email notification to finance
		
		$this->session->set_flashdata('message_ok', 'Data saved, No. Rembuirse : '.$normbform);
		redirect('branch/branch_bpkk/post_to_fin');
}



//Create Petty Cash Operational
function create_bpkk()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_bpkk);
	
		$data['prev'] = '';
		
		$data['pettycashbalance'] = $this->fungsi->get_pc_bal_op($this->session->userdata('idcab'));
		
		/* Generate combo box */
			$query_gl = $this->branch_model->get_list_gl();
			$data_gl = $query_gl->result();
			$data['cb_gl']='';
			foreach($data_gl as $row)
			{
			$data['cb_gl'] .= $row->glacc==$data['default']['cb_gl'] ? '<option value="'.$row->glacc.'" selected="selected">': '<option value="'.$row->glacc.'">';
			$data['cb_gl'] .= $row->glacc.' - '.$row->desc.'</option>';
			}
			
			/* Generate combo box pc opr typ */
			$query_pcoprtyp = $this->branch_model->get_pc_opr_typ();
			$data_pcoprtyp = $query_pcoprtyp->result();
			$data['cb_pcoprtyp']='';
			foreach($data_pcoprtyp as $row_oprtyp)
			{
			$data['cb_pcoprtyp'] .= $row_oprtyp->idpcoprtyp==$data['default']['cb_pcoprtyp'] ? '<option value="'.$row_oprtyp->idpcoprtyp.'" selected="selected">': '<option value="'.$row_oprtyp->idpcoprtyp.'">';
			$data['cb_pcoprtyp'] .= $row_oprtyp->idpcoprtyp.' - '.$row_oprtyp->desc.'</option>';
			}		
		
		$data['menu_path'] = 'BRANCH > PETTY CASH > CREATE BPKK';
		$data['form_action']= site_url('branch/branch_bpkk/add_bpkk_prev');
		$this->load->view('branch/branch_bpkk_form', $data);
	}

function  add_bpkk_prev()
{
			$this->session->unset_userdata('bpkk_item');
			
			$bpkklist = array();
			
			if($this->input->post('txt_uraian1') != '' && $this->input->post('txt_amount1') != '')
			{
				$query_gl = $this->branch_model->get_list_gl_byglacc($this->input->post('cb_gl1'))->result();
				foreach($query_gl as $row);
				
				$bpkklist[] = array( 	'txt_uraian'		=>  $this->input->post('txt_uraian1'),
										'cb_gl'				=> 	$this->input->post('cb_gl1'),
										'cb_gl_desc'		=> 	$row->desc,
										'jumlah'			=> $this->input->post('txt_amount1'),
						);
			}
			
			if($this->input->post('txt_uraian2') != '' && $this->input->post('txt_amount2') != '')
			{
				$query_gl = $this->branch_model->get_list_gl_byglacc($this->input->post('cb_gl2'))->result();
				foreach($query_gl as $row);
				
				$bpkklist[] = array( 	'txt_uraian'		=>  $this->input->post('txt_uraian2'),
										'cb_gl'				=> 	$this->input->post('cb_gl2'),
										'cb_gl_desc'		=> 	$row->desc,
										'jumlah'			=> $this->input->post('txt_amount2'),
						);
			}
			
			if($this->input->post('txt_uraian3') != '' && $this->input->post('txt_amount3') != '')
			{
				$query_gl = $this->branch_model->get_list_gl_byglacc($this->input->post('cb_gl3'))->result();
				foreach($query_gl as $row);
				
				$bpkklist[] = array( 	'txt_uraian'		=>  $this->input->post('txt_uraian3'),
										'cb_gl'				=> 	$this->input->post('cb_gl3'),
										'cb_gl_desc'		=> 	$row->desc,
										'jumlah'			=> $this->input->post('txt_amount3'),
						);
			}
			
			if($this->input->post('txt_uraian4') != '' && $this->input->post('txt_amount4') != '')
			{
				$query_gl = $this->branch_model->get_list_gl_byglacc($this->input->post('cb_gl4'))->result();
				foreach($query_gl as $row);
				
				$bpkklist[] = array( 	'txt_uraian'		=>  $this->input->post('txt_uraian4'),
										'cb_gl'				=> 	$this->input->post('cb_gl4'),
										'cb_gl_desc'		=> 	$row->desc,
										'jumlah'			=> $this->input->post('txt_amount4'),
						);
			}
			
			//print_r($bpkklist);
			$no = 0;
			$data['table']= '';
			$total = 0;
			$bg=0;
			foreach($bpkklist as $row)
			{
				if($bg==0)
				{
				$data['table'].="<tr style=background-color:#eeeeee;>";
				$bg++;
				}
				else
				{
				$data['table'].="<tr style=background-color:#;>";
				$bg--;
				}
				$no = $no + 1;
			 	$data['table'].= '<td width="65" align="center" height="28">'.$no.'</td>
          		<td width="505">'.$row['txt_uraian'].'</td>
          		<td width="168">'.$row['cb_gl'].' - '.$row['cb_gl_desc'].'</td>
          		<td width="204" align="right">'.$row['jumlah'].'</td>
        		</tr>';
				
				$total = $total + $this->fungsi->convert_idr_to_num($row['jumlah']);
			}
		
		if (  $this->fungsi->is_array_empty(($bpkklist)) == FALSE )
			{
			
			$this->session->set_userdata('bpkk_item', $bpkklist);
			
			$data['pettycashbalance'] = $this->fungsi->get_pc_bal_op($this->session->userdata('idcab'));
			$data['totalamount'] = $total;
			$data['currpettycashbalance'] = $this->fungsi->get_pc_bal_op($this->session->userdata('idcab')) - $total;
			$data['txt_postdate'] = $this->input->post('txt_postdate');
			$data['prev'] = 1;
			
			if($this->valid_amount($total) == TRUE)
			{
				if($this->input->post('cb_pcoprtyp') == '2' && $no > 1)
				{
					$data['submit'] ='<font color="#FF0000"><b>Only 1 item permitted!</b></font>';
				}
				else
				{
					$data['submit'] = '<input type="submit" name="button2" id="button2" value="Submit" class="button" />';
				}
			}
			else
			{
					$data['submit'] ='<font color="#FF0000"><b>Cannot Save Data, Your Petty Cash Balances Is Insufficient!</b></font>';	
			}
			
			
			
			$query_pcoprtyp = $this->branch_model->get_pc_opr_typ_byid($this->input->post('cb_pcoprtyp'));
			$data_pcoprtyp = $query_pcoprtyp->result();
			foreach($data_pcoprtyp as $row_oprtyp);
			$data['pcoprtyp'] = $row_oprtyp->idpcoprtyp;
			$data['pcoprtyp_desc'] = $row_oprtyp->desc;
			
			$data['menu_path'] = 'BRANCH > PETTY CASH > CREATE BPKK > PREVIEW';
			$data['form_action']= site_url('branch/branch_bpkk/add_bpkk_proc');
			$this->load->view('branch/branch_bpkk_form', $data);
			}
		else
			{	
			
				$this->create_bpkk();
				
			}
			
	
}

function add_bpkk_proc()
{
	
	//print_r($this->session->userdata('bpkk_item'));
	
	//Input Header
	
	/*Get BPKK counter*/
	$count = array();
	$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'BPKK');
	$nobpkkform = $count[0];
	$nobpkk = $count[1];
	
	/*Insert BPKK Header*/
		$bpkkheader = array( 	'idcab'		 => $this->session->userdata('idcab'),
								'nobpkkform' => $nobpkkform,
								'nobpkk'	 => $nobpkk,
								'year'		 => date('Y'),
								'total' 	 =>  $this->input->post('txt_total'),
								'idpcoprtyp' =>  $this->input->post('txt_idpcoprtyp'),
								'addby'		 => $this->session->userdata('uid'),
								//Postdate
								'postdate'	 => date("Y-m-d",   strtotime($this->input->post('txt_postdate2'))),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
	/*Insert BPKK Detail*/
	$bpkkdetail = array();
	
	foreach($this->session->userdata('bpkk_item') as $row)
			{
				$i = $i + 1;
				$bpkkdetail[] = array( 			'idcab'		 => $this->session->userdata('idcab'),
												'nobpkk'	 => $nobpkk,
												'uraian'	 => $row['txt_uraian'],
												'year'		 => date('Y'),
												'itemno' 	 => $i,
												'total_item' => $this->fungsi->convert_idr_to_num($row['jumlah']),
												'glacc' 	 => $row['cb_gl'],
												);
			}
			
		/*Insert Saldo Petty cash operational cabang*/
		$pcbalopr = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 	 => $nobpkkform,
								'amount' => $this->input->post('txt_total') * -1,
								//Postdate
								'postdate'	 => date("Y-m-d",   strtotime($this->input->post('txt_postdate2'))),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
											
		$this->branch_model->add_bpkk_header($bpkkheader);	
		$this->branch_model->add_bpkk_detail($bpkkdetail);				
		$this->branch_model->add_pcopr_branch($pcbalopr);
		
		$this->session->set_flashdata('message_ok', 'Data saved, No. BPKK :'.$nobpkkform);
		redirect('branch/branch_bpkk/');
	
}
	
function print_bpkk()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_print_bpkk);
	
	/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$bpkk = $this->branch_model->get_list_bpkk($this->session->userdata('idcab'),$this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->branch_model->get_list_bpkk_count($this->session->userdata('idcab'));
		
		$config['base_url'] = site_url('branch/branch_bpkk/print_bpkk/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
		{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. BPKK', 'Branch','Type','Total Amount','Add by','Add date','Options');
					
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
					
					foreach ($bpkk  as $bpkks)
					{	
						$this->table->add_row($bpkks->nobpkkform, $bpkks->cabname , $bpkks->desc ,$this->fungsi->format_idr($bpkks->total), $bpkks->addby, $bpkks->adddate,  anchor('branch/branch_bpkk/branch_bpkk_edit/'.$bpkks->idcab.'/'.$bpkks->nobpkk.'/'.$bpkks->year,'Edit',array('class' => 'update')).' '.anchor('branch/branch_bpkk/branch_bpkk_cancel/'.$bpkks->idcab.'/'.$bpkks->nobpkk.'/'.$bpkks->year,'Cancel',array('class' => 'delete')).' '.anchor_popup('branch/branch_bpkk/print_bpkk_popup/'.$bpkks->idcab.'/'.$bpkks->nobpkk.'/'.$bpkks->year,'Print',array('class' => 'print',$atts),$atts));	
					}
					
					$data['table'] = $this->table->generate();
		}		
		else
		{
			
			$data['message'] = 'No data';
			
		}
		
		$data['menu_path'] = 'BRANCH > BPKK > PRINT BPKK';
		$this->load->view('branch/branch_bpkk_list', $data);
	
	
}

function print_bpkk2()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_print_bpkk);
	
	/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$bpkk = $this->branch_model->get_list_bpkk2($this->session->userdata('idcab'),$this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->branch_model->get_list_bpkk_count2($this->session->userdata('idcab'));
		
		$config['base_url'] = site_url('branch/branch_bpkk/print_bpkk/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
		{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. BPKK', 'Branch','Type','Total Amount','Add by','Add date','Options');
					
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
					
					foreach ($bpkk  as $bpkks)
					{	
						$this->table->add_row($bpkks->nobpkkform, $bpkks->cabname , $bpkks->desc ,$this->fungsi->format_idr($bpkks->total), $bpkks->addby, $bpkks->adddate,  anchor_popup('branch/branch_bpkk/print_bpkk_popup/'.$bpkks->idcab.'/'.$bpkks->nobpkk.'/'.$bpkks->year,'Print',array('class' => 'print',$atts),$atts));	
					}
					
					$data['table'] = $this->table->generate();
		}		
		else
		{
			
			$data['message'] = 'No data';
			
		}
		
		$data['menu_path'] = 'BRANCH > BPKK > PRINT BPKK';
		$this->load->view('branch/branch_bpkk_list', $data);
	
	
}

function branch_bpkk_edit()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('edit'));
	
	//Get data BPKK HEADER by ID CAB, BPKK & year
	$query_bpkk_header = $this->branch_model->get_bpkkheader_byidcabnoyear($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
//print_r($query_bpkk_header );
	foreach ($query_bpkk_header->result() as $row_bpkk_header)
		{
			$data['txt_nobppkform'] = $row_bpkk_header->nobpkkform;
			$data['txt_adddate'] = date("d.m.Y",   strtotime($row_bpkk_header->adddate));	
			$data['txt_addby'] = $row_bpkk_header->addby;
			if($row_bpkk_header->chdate == '0000-00-00 00:00:00')
			{
				$data['txt_chdate'] = '';	
			}
			else
			{
				$data['txt_chdate'] = date("d.m.Y",   strtotime($row_bpkk_header->chdate));	
			}
			
			
			$data['txt_chby'] = $row_bpkk_header->chby;
			$data['txt_idcab'] = $row_bpkk_header->idcab;
			$data['txt_total'] = $row_bpkk_header->total;
			$data['txt_terbilang'] = $this->fungsi->terbilang($row_bpkk_header->total).' RUPIAH';
		}
		
			$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No.', 'Uraian','G/L Account','Jumlah', 'Options');
	//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_bpkk_header->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['txt_cabname'] = $row_cab->cabname;
				}
		$query_bpkk_detail = $this->branch_model->get_bpkkdetail_byidcabnoyear_glacc($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
	foreach ($query_bpkk_detail->result() as $row_bpkk_detail)
		{
						$this->table->add_row($row_bpkk_detail->itemno, $row_bpkk_detail->uraian, $row_bpkk_detail->glacc.' - '. $row_bpkk_detail->desc,$this->fungsi->format_idr($row_bpkk_detail->total_item), anchor('branch/branch_bpkk/branch_bpkk_edit_detail/'.$row_bpkk_detail->idcab.'/'.$row_bpkk_detail->nobpkk.'/'.$row_bpkk_detail->year.'/'.$row_bpkk_detail->itemno,'Edit',array('class' => 'update')));	
					
		}
		
		$data['table'] = $this->table->generate();
		
		$data['menu_path'] = 'BRANCH > BPKK > PRINT BPKK > EDIT BPKK';
		$data['link'] = array('link_back' => anchor('branch/branch_bpkk/print_bpkk','Back', array('class' => 'back')));
		$this->load->view('branch/branch_bpkk_edit', $data);	
}

function branch_bpkk_edit_detail()
{		
//Get data BPKK HEADER by ID CAB, BPKK & year
	$query_bpkk_header = $this->branch_model->get_bpkkheader_byidcabnoyear($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
//print_r($query_bpkk_header );
	foreach ($query_bpkk_header->result() as $row_bpkk_header);
	
	$query_bpkk_detail = $this->branch_model->get_bpkkdetail_byidcabnoyearno($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6),$this->uri->segment(7));
	foreach ($query_bpkk_detail->result() as $row_bpkk_detail);
		$data['txt_itemno'] = $row_bpkk_detail->itemno;
		$data['txt_uraian'] = $row_bpkk_detail->uraian;
		$data['txt_total'] = $row_bpkk_detail->total_item;
		
		
			/*Generate combo box G/L*/
			$query_gl = $this->branch_model->get_list_gl();
			$data_gl = $query_gl->result();
			$data['cb_gl'] = $row_bpkk_detail->glacc;
			foreach($data_gl as $row)
			{
			$data['cb_gl'] .= $row->glacc == $row_bpkk_detail->glacc ? '<option value="'.$row->glacc.'" selected="selected">': '<option value="'.$row->glacc.'">';
			$data['cb_gl'] .= $row->glacc.' - '.$row->desc.'</option>';
			}	

		$data['menu_path'] = 'BRANCH > BPKK > PRINT BPKK > EDIT BPKK '.$row_bpkk_header->nobpkkform.' NO. '.$row_bpkk_detail->itemno;
		$data['link'] = array('link_back' => anchor('branch/branch_bpkk/branch_bpkk_edit/'.$this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6),'Back', array('class' => 'back')));
		$data['form_action']= site_url('branch/branch_bpkk/update_bpkk_detail/'.$this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6).'/'.$this->uri->segment(7));
		$this->load->view('branch/branch_bpkk_edit_detail', $data);	
}

function update_bpkk_detail()
{
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('edit'));
	
		/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_uraian',
                     'label'   => 'Uraian',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
	if ($this->form_validation->run() == TRUE)
			{	
				$detail = array( 'uraian' => $this->input->post('txt_uraian'),
								'glacc' => $this->input->post('cb_gl'),
								);
				$header = array( 'chby' => $this->session->userdata('uid'),
								'chdate' => date( 'Y-m-d H:i:s'),
								);
				$this->branch_model->update_bpkkheader($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6),$header);			
				$this->branch_model->update_bpkkdetail($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6),$this->uri->segment(7),$detail);
			$this->session->set_flashdata('message_ok', 'Data changed');
	  		redirect('branch/branch_bpkk/branch_bpkk_edit/'.$this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6));	
			}
		else
			{
				$this->branch_bpkk_edit_detail();
			}
}

function branch_bpkk_cancel()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('cancel'));
	
	//Get data BPKK HEADER by ID CAB, BPKK & year
	$query_bpkk_header = $this->branch_model->get_bpkkheader_byidcabnoyear($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
//print_r($query_bpkk_header );
	foreach ($query_bpkk_header->result() as $row_bpkk_header)
		{
			$data['txt_nobppkform'] = $row_bpkk_header->nobpkkform;
			$data['txt_adddate'] = date("d.m.Y",   strtotime($row_bpkk_header->adddate));	
			$data['txt_addby'] = $row_bpkk_header->addby;
			if($row_bpkk_header->chdate == '0000-00-00 00:00:00')
			{
				$data['txt_chdate'] = '';	
			}
			else
			{
				$data['txt_chdate'] = date("d.m.Y",   strtotime($row_bpkk_header->chdate));	
			}
			
			
			$data['txt_chby'] = $row_bpkk_header->chby;
			$data['txt_idcab'] = $row_bpkk_header->idcab;
			$data['txt_total'] = $row_bpkk_header->total;
			$data['txt_terbilang'] = $this->fungsi->terbilang($row_bpkk_header->total).' RUPIAH';
		}
		
			$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No.', 'Uraian','G/L Account','Jumlah');
	//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_bpkk_header->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['txt_cabname'] = $row_cab->cabname;
				}
		$query_bpkk_detail = $this->branch_model->get_bpkkdetail_byidcabnoyear_glacc($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
	foreach ($query_bpkk_detail->result() as $row_bpkk_detail)
		{
						$this->table->add_row($row_bpkk_detail->itemno, $row_bpkk_detail->uraian, $row_bpkk_detail->glacc.' - '. $row_bpkk_detail->desc,$this->fungsi->format_idr($row_bpkk_detail->total_item));	
					
		}
		
		$data['table'] = $this->table->generate();
		
		$data['menu_path'] = 'BRANCH > BPKK > PRINT BPKK > CANCEL BPKK';
		$data['link'] = array('link_back' => anchor('branch/branch_bpkk/print_bpkk','Back', array('class' => 'back')));
		$data['form_action']= site_url('branch/branch_bpkk/cancel_bpkk_proc/'.$this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6));
		$this->load->view('branch/branch_bpkk_cancel', $data);	
	
}

function cancel_bpkk_proc()
{
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_desc',
                     'label'   => 'Cancel Reason',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
	if ($this->form_validation->run() == TRUE)
			{
				
				$header = array( 
								'status' => 1,
								'canby' => $this->session->userdata('uid'),
								 'candate' => date("Y-m-d H:i:s",   strtotime($this->input->post('txt_postdate'))),
								);
		
		/*Insert Saldo Petty cash operational cabang*/
		$pcbalopr = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 	 => $this->input->post('txt_nobpkkform'),
								'status'	 => 1,
								'amount' 	 => $this->input->post('txt_total'),
								//Postdate
								'postdate'	 => date("Y-m-d",   strtotime($this->input->post('txt_postdate'))),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'));
								
				$this->branch_model->update_bpkkheader($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6),$header);		
				$this->branch_model->add_pcopr_branch($pcbalopr);	
				
				$this->session->set_flashdata('message_ok', 'Data cancelled');
	  			redirect('branch/branch_bpkk/print_bpkk/');						
			}
	else
			{
				$this->branch_bpkk_cancel();
				
			}
	
}

function print_bpkk_popup()
{
		//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Get data BPKK HEADER by ID CAB, BPKK & year
	$query_bpkk_header = $this->branch_model->get_bpkkheader_byidcabnoyear($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
	foreach ($query_bpkk_header->result() as $row_bpkk_header)
		{
			$data['txt_nobppkform'] = $row_bpkk_header->nobpkkform;
			$data['txt_adddate'] = date("d.m.Y",   strtotime($row_bpkk_header->adddate));	
			$data['txt_addby'] = $row_bpkk_header->addby;
			$data['txt_idcab'] = $row_bpkk_header->idcab;
			$data['txt_total'] = $row_bpkk_header->total;
			$data['txt_terbilang'] = $this->fungsi->terbilang($row_bpkk_header->total).' RUPIAH';
		}
//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_bpkk_header->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['txt_cabname'] = $row_cab->cabname;
				}
	//Get data BPKK DETAIL by ID CAB, BPKK & year
$data['detail'].= '';
$query_bpkk_detail = $this->branch_model->get_bpkkdetail_byidcabnoyear($this->uri->segment(4),$this->uri->segment(5),$this->uri->segment(6));
	foreach ($query_bpkk_detail->result() as $row_bpkk_detail)
		{
$data['detail'].= '<tr>
        <td width="622">'.$row_bpkk_detail->uraian.'</td>
        <td width="230" align="right">'.$this->fungsi->format_idr($row_bpkk_detail->total_item).'</td>
        </tr>';
		}
$this->load->view('popup/popup_bpkk_cab', $data);
}

}