<?php 
/*
Fungsi : Controller untuk branch MIGO
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Branch_migo extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_create_migo  = 88;

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	//Cek valid stock
public function valid_stock($idcab, $qty)
{
	
	if($this->fungsi->get_stock_bal($idcab) < $qty)
	{
		return false;
	}
	else
	{
		
		return true;
	}
	
}

/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/branch_model', '', TRUE);
		$this->load->model('finance/fin_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->branch_create_migo();		
	}
	
/*Create MIGO*/
function branch_cancel_migo()
{
$data['prev']=0;
$data['menu_path'] = 'BRANCH > MIGO > CANCEL MIGO';
$data['form_action']= site_url('branch/branch_migo/cancel_migo_prev');	
$this->load->view('branch/branch_cancel_migo_form', $data);	
}

/*Cancel MIGO prev*/
function cancel_migo_prev()
{
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_ebeln',
                     'label'   => 'No. PO',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_year',
                     'label'   => 'Year',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				
				$data['prev']=1;
				//Check otorisasi
				$this->fungsi->trans_auth($this->session->userdata('cancel'));
	
	//Get data PC by no cpv & year
	$query_po_edit = $this->branch_model->get_po_bynoyearidcab($this->input->post('txt_ebeln'),$this->input->post('txt_year'),$this->session->userdata('idcab'));
	foreach ($query_po_edit->result() as $row_po);
		
			$data['txt_ebeln'] = $row_po->ebeln;
			$data['txt_migo'] = $row_po->mblnr;
			$data['txt_preq_no'] = $row_po->preq_no;
			$data['txt_year'] = $row_po->year;
			$data['txt_vendor'] = $row_po->vendor;
			$data['txt_net_price'] =  $row_po->net_price;
			$data['txt_qty'] =  $row_po->quantity;
			$data['txt_total'] =  ($row_po->net_price * $row_po->quantity) - $row_po->disc;
			$data['txt_totalall'] =  (($row_po->net_price * $row_po->quantity) - $row_po->disc) + $row_po->tax;
			$data['txt_ppn'] =  $row_po->tax;
			$data['txt_disc'] =  $row_po->disc;				
		
			$data['menu_path'] = 'BRANCH > MIGO > CANCEL MIGO > PREVIEW PO '.$row_po->ebeln;
			$data['form_action']= site_url('branch/branch_migo/cancel_migo_proc');	
			$this->load->view('branch/branch_cancel_migo_form', $data);	
			}
		else
			{
				$this->branch_create_migo();
			}
	
}

/*Cancel MIGO process*/
function cancel_migo_proc()
{
	//Check stock
	if($this->valid_stock($this->session->userdata('idcab'), $this->input->post('txt_qty')) == FALSE)
				{
				
				$this->session->set_flashdata('message_err', 'Stock Insufficient!');
				redirect('branch/branch_migo/branch_cancel_migo/');	
					
				}
			
	$this->fungsi_sap->fm_cancel_migo($this->input->post('txt_migo'),$this->input->post('txt_year'),$this->input->post('txt_cancel_date'),$this->session->userdata('pic'));

if( $this->session->userdata('sap_migorev_num') != '' )
	{
		//Update data PO
		$po = array(	'mblnr' => '',
						//'quantity' => '',
						//'net_price' => '',
						//'disc' => '',
						//'tax' => '',
						//'chby'	=> $this->session->userdata('uid'),
						//'chdate' => date( 'Y-m-d H:i:s')
						);
		$this->branch_model->update_po($this->input->post('txt_ebeln'),$this->input->post('txt_year'),$po);	
				
		//Insert Stock
		$stock = array(	'ref' => $this->session->userdata('sap_migorev_num'),
						'idcab'	=> $this->session->userdata('idcab'),
						'year' => date('Y'),
						'qty' => $this->input->post('txt_qty') * -1,
						'addby'	=> $this->session->userdata('uid'),
						'postdate'	=> date("Y-m-d",   strtotime($this->input->post('txt_cancel_date'))),
						'adddate' => date( 'Y-m-d H:i:s'),
								);
		$this->branch_model->add_stock($stock);	
		
		//Insert history cancel MIGO
				$hmigocan = array('ebeln' => $this->input->post('txt_ebeln'),
									'year'	=>  $this->input->post('txt_year'),
									'mblnr' => $this->input->post('txt_migo'),
									'mblnr_cancel' => $this->session->userdata('sap_migorev_num'),
									'reason' => $this->input->post('txt_cancel'),
									'canby' => $this->session->userdata('uid'),
									'candate' => date( 'Y-m-d H:i:s'),
							);	
				$this->branch_model->add_h_migocan($hmigocan);
		
		//Update PR
		//Update status PR = Close
		$pr = array(    'closed'	 => 0,
						'clby'		 => '',
						'cldate' 	 => '',
						'chby'	=> $this->session->userdata('uid'),
						'chdate' => date( 'Y-m-d H:i:s')
				   );
		$this->branch_model->update_pr($this->input->post('txt_preq_no'),$this->input->post('txt_year'),$pr);			
		//Email to accounting
		//send email notification
			//$var = array($this->session->userdata('sap_migo_num'), $this->session->userdata('uid'),$this->input->post('txt_ebeln'),number_format($this->input->post('txt_qty')),$this->fungsi->format_idr($this->input->post('txt_totalall')), $this->fungsi->format_idr($this->input->post('txt_disc')), $this->fungsi->format_idr($this->input->post('txt_ppn')));
			//$this->fungsi->send_notif(11, $var);
	}
	
	$this->session->set_flashdata('message_ok', 'MIGO Cancelled, MIGO number :'.$this->session->userdata('sap_migorev_num'));
	redirect('branch/branch_migo/branch_cancel_migo/');	
	
}


/*Create MIGO*/
function branch_create_migo()
{
$data['prev']=0;
$data['menu_path'] = 'BRANCH > MIGO > CREATE MIGO';
$data['form_action']= site_url('branch/branch_migo/add_migo_prev');	
$this->load->view('branch/branch_migo_form', $data);	
}	

/*Add MIGO prev*/
function add_migo_prev()
{
	/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_ebeln',
                     'label'   => 'No. PO',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_year',
                     'label'   => 'Year',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				$data['prev']=1;
				//Check otorisasi
				$this->fungsi->trans_auth($this->session->userdata('add'));
	
	//Get data PC by no cpv & year
	$query_po_edit = $this->branch_model->get_po_bynoyearidcab($this->input->post('txt_ebeln'),$this->input->post('txt_year'),$this->session->userdata('idcab'));
	foreach ($query_po_edit->result() as $row_po);
		
			$data['txt_ebeln'] = $row_po->ebeln;
			$data['txt_year'] = $row_po->year;
			$data['txt_vendor'] = $row_po->vendor;
			$data['txt_net_price'] =  $row_po->net_price;
			$data['txt_qty'] =  $row_po->quantity;
			$data['txt_total'] =  ($row_po->net_price * $row_po->quantity) - $row_po->disc;
			$data['txt_totalall'] =  (($row_po->net_price * $row_po->quantity) - $row_po->disc) + $row_po->tax;
			$data['txt_ppn'] =  $row_po->tax;
			$data['txt_disc'] =  $row_po->disc;				
			$data['txt_postdate'] =  $this->input->post('txt_postdate');
			$data['menu_path'] = 'BRANCH > MIGO > CREATE MIGO > PREVIEW PO '.$row_po->ebeln;
			$data['form_action']= site_url('branch/branch_migo/add_migo_proc');	
			$this->load->view('branch/branch_migo_form', $data);	
			}
		else
			{
				$this->branch_create_migo();
			}
	
}

function add_migo_proc()
{
	$this->fungsi_sap->fm_create_migo($this->input->post('txt_ebeln'),$this->session->userdata('lgort'),$this->input->post('txt_vendor'),$this->session->userdata('cabshorttxt'),'Used Oil',$this->input->post('txt_qty'),$this->input->post('txt_ebeln'), $this->input->post('txt_postdate2'));

if( $this->session->userdata('sap_migo_num') != '' )
	{
		
		//Insert table mutasi PO
		$po_mutasi = array(	'ebeln' => $this->input->post('txt_ebeln'),
							'idcab'	=> $this->session->userdata('idcab'),
							'qty' => $this->input->post('txt_qty'),
							'oa' => $this->fungsi->get_oa_trf($this->session->userdata('idcab'),date("Y-m-d",   strtotime($this->input->post('txt_postdate2')))),
							'addby'		 => $this->session->userdata('uid'),
							'adddate' 	 => date( 'Y-m-d H:i:s'),
						);
						
		/*Cabang surabaya blom ada OA*/
			/*if	($this->session->userdata('idcab')!=6)			
		{	*/	
				//Insert Table mutasi PO
				$this->db->insert('t_po_mutasi',$po_mutasi); 
			/*}*/
			
		//Update data PO
		$po = array(	'mblnr' => $this->session->userdata('sap_migo_num'));
		
		$this->branch_model->update_po($this->input->post('txt_ebeln'),$this->input->post('txt_year'),$po);	
				
		//Insert Stock
		$stock = array(	'ref' => $this->session->userdata('sap_migo_num'),
						'idcab'	=> $this->session->userdata('idcab'),
						'year' => date('Y'),
						'qty' => $this->input->post('txt_qty'),
						//postdate
						'postdate' 	 => date("Y-m-d",   strtotime($this->input->post('txt_postdate2'))),
						'addby'	=> $this->session->userdata('uid'),
						'adddate' => date( 'Y-m-d H:i:s'),
								);
		$this->branch_model->add_stock($stock);	
		
		//Email to accounting
		//send email notification
			$var = array($this->session->userdata('sap_migo_num'), $this->session->userdata('uid'),$this->input->post('txt_ebeln'),number_format($this->input->post('txt_qty')),$this->fungsi->format_idr($this->input->post('txt_totalall')), $this->fungsi->format_idr($this->input->post('txt_disc')), $this->fungsi->format_idr($this->input->post('txt_ppn')));
			$this->fungsi->send_notif(11, $var);
	}
	
	$this->session->set_flashdata('message_ok', 'MIGO Created, MIGO number :'.$this->session->userdata('sap_migo_num'));
	redirect('branch/branch_migo/');	
	
}

}