<?php 
/*
Fungsi : Controller untuk branch PR
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Branch_po extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_print_po  = 59;

/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/
	
/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/branch_model', '', TRUE);
		$this->load->model('finance/fin_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->branch_list_po();		
	}
	

/*Print PO*/
function print_po_popup()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Get data PC by no cpv & year
	$query_po_edit = $this->branch_model->get_po_bynoyear($this->uri->segment(4),$this->uri->segment(5));
	
	
	foreach ($query_po_edit->result() as $row_po)
		{
			$data['txt_vendor'] = $row_po->vendor.' - '.$row_po->vendor_name;
			$data['txt_idtop'] = $row_po->idtop;
			
			$data['txt_ebeln'] = $row_po->ebeln;
			$data['txt_pr'] = $row_po->preq_no;
			$data['txt_migo'] = $row_po->mblnr;
			$data['txt_adddate'] = date("d.m.Y",   strtotime($row_po->adddate));	
			$data['txt_addby'] = $row_po->addby;
			$data['txt_idcab'] = $row_po->idcab;
			$data['txt_migo'] = $row_po->mblnr;
			$data['txt_ppn'] = $this->fungsi->format_idr($row_po->tax);
			$data['txt_net_price'] =  $this->fungsi->format_idr($row_po->net_price);
			$data['txt_disc'] =  $this->fungsi->format_idr($row_po->disc);
			$data['txt_qty'] =  number_format($row_po->quantity);
			$data['txt_total'] =  $this->fungsi->format_idr($row_po->net_price * $row_po->quantity);
			$data['txt_total_all'] =  $this->fungsi->format_idr((($row_po->net_price * $row_po->quantity) - $row_po->disc) + $row_po->tax);
			$data['txt_terbilang'] = strtoupper($this->fungsi->terbilang(round((($row_po->net_price * $row_po->quantity) - $row_po->disc)+ $row_po->tax)) .' RUPIAH');
		}
		
	//Get PO type
	$query_po_typ = $this->db->query("SELECT * 
							   FROM
							   m_top
							   WHERE idtop ='".$data['txt_idtop']."'");
							   
	foreach ($query_po_typ->result() as $row_po_typ);
	$data['txt_po_typ'] = 	$row_po_typ->desc;
					   
//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_po->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['txt_cabname'] = strtoupper($row_cab->cabname);
				}
$this->load->view('popup/popup_po_cab', $data);
	
}	

function list_po()
{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Otorisasi menu
	$this->fungsi->menu_auth($this->menu_print_po);
	
	/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$po = $this->branch_model->get_list_po2($this->session->userdata('idcab'),$this->config->item('paging_limit'), $offset, 0)->result();
		$num_rows = $this->branch_model->get_list_po_count($this->session->userdata('idcab'),0);
		
		$config['base_url'] = site_url('branch/branch_po/list_po/');
	
		if ($num_rows > 0) // Jika query menghasilkan data
		{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. PO', 'Branch', 'Price/Liter', 'Total Liter', 'R. Disc', 'Total Before PPN', 'PPN', 'Total', 'Add by','Add date','Options');
					
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
					
					foreach ($po  as $pos)
					{	
						$this->table->add_row($pos->ebeln, $pos->cabname, $this->fungsi->format_idr($pos->net_price), $this->fungsi->format_idr($pos->quantity),$this->fungsi->format_idr($pos->disc), $this->fungsi->format_idr(($pos->net_price*$pos->quantity) - $pos->disc), $this->fungsi->format_idr($pos->tax),$this->fungsi->format_idr((($pos->net_price*$pos->quantity) - $pos->disc) + $pos->tax),$pos->addby, $pos->adddate, anchor_popup('branch/branch_po/print_po_popup/'.$pos->ebeln.'/'.$pos->year,'Print',array('class' => 'print',$atts),$atts));	
					}
					
					$data['table'] = $this->table->generate();
		}		
		else 
		{
			
			$data['message'] = 'No data';
			
		}
		
		$data['menu_path'] = 'BRANCH > PURCHASE ORDER > LIST PURCHASE ORDER';
		$this->load->view('branch/branch_po_list', $data);
	
	
}


//Testing closing PR
function close_pr()
{	
	//Get Data PR
	$query_get_pr = $this->branch_model->get_pr_bynoyear($this->uri->segment(4),$this->uri->segment(5));
	foreach ($query_get_pr->result() as $row_pr);
	
	//Edit PR
	$this->fungsi_sap->fm_edit_pr($this->uri->segment(4),$row_pr->quantity,$row_pr->c_amt_bapi,$this->session->userdata('pic'));
	
	//Create PO
	$this->fungsi_sap->fm_create_po($this->session->userdata('lifnr'), $this->session->userdata('lgort'),$row_pr->c_amt_bapi,$this->uri->segment(4),$this->session->userdata('pic'));
	
	//MIGO
	$this->fungsi_sap->fm_create_migo($this->session->userdata('cabshorttxt'),$this->session->userdata('lgort'),$this->session->userdata('lifnr'),$this->session->userdata('cabshorttxt'),'Used Oil',$row_pr->quantity,$this->session->userdata('sap_po_num'));
	
	//Update status PR = Close
	$pr = array(        'c_amt_bapi' => $row_pr->c_amt_bapi,
						'quantity'	 => $row_pr->quantity,
						'closed'	 => 1,
						'clby'		 => $this->session->userdata('uid'),
						'cldate' 	 => date( 'Y-m-d H:i:s'),
								);
	//Insert PO Data
	$po = array(		'ebeln' => $this->session->userdata('sap_po_num'),
						'idcab'	=> $this->session->userdata('idcab'),
						'preq_no' => $this->session->userdata('sap_pr_num'),
						'vendor' => $this->session->userdata('lifnr'),
						'mblnr' => $this->session->userdata('sap_migo_num'),
						'year' => date('Y'),
				       	'net_price' => $row_pr->c_amt_bapi,
						'quantity'	 => $row_pr->quantity,
						'addby'		 => $this->session->userdata('uid'),
						'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
	/*Insert Saldo Petty cash cabang*/
		/*$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 	 => $this->session->userdata('sap_po_num'),
								'amount' 	=> ( $row_pr->c_amt_bapi * $row_pr->quantity ) * -1,
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);*/
	if( $this->session->userdata('sap_po_num') != '' )
	{
		$this->branch_model->update_pr($this->uri->segment(4),$this->uri->segment(5),$pr);							
		$this->branch_model->add_po($po);
		//Update petty cash balance
		//$this->branch_model->add_pc_branch($pcbal);
	}
	
	$this->session->set_flashdata('message_ok', 'PO Created, PO number :'.$this->session->userdata('sap_po_num'));
	redirect('branch/branch_pr/list_pr');	
}

}