<?php 
/*
Fungsi : Controller untuk manifest
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cabang_mnfst extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_mnfst  = 81;
	var $menu_add_mnfst = 80;
	var $menu_counter_mnfst = 80;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/	


/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/cabang_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->cabang_add_mnfst();
		
	}

	/* Cabang add manifest */
	function cabang_add_mnfst()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_mnfst);
			
		$data['menu_path'] = 'BRANCH > MANIFEST > ADD MANIFEST';
		$data['form_action']= site_url('cabang/cabang_mnfst/add_mnfst_proc');
		$this->load->view('branch/cabang_manifest_form', $data);
		
	}
	
	
	/* Admin add supp process */
	function add_mnfst_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->mnfst_auth($this->session->userdata('add'));
		
		//Config utk validasi form manifest
	$config = array(
               array(
                     'field'   => 'txt_idsupp',
                     'label'   => 'Supp ID',
                     'rules'   => 'required|callback_idcab_check'
                  ),
               array(
                     'field'   => 'mnfstname',
                     'label'   => 'Name',
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'txt_lifnr',
                     'label'   => 'Vendor Code SAP',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'txt_pic',
                     'label'   => 'PIC',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_lgort',
                     'label'   => 'Storage Code SAP',
                     'rules'   => 'required'
                  )
				  ,
				   array(
                     'field'   => 'txt_max_stor',
                     'label'   => 'Storage Max Capacity',
                     'rules'   => 'required'
                  )
				  //Not validate form
				  ,array(
                     'field'   => 'txt_addr',
                     'label'   => 'Address',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'rg_active',
                     'label'   => 'Status',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_prov',
                     'label'   => 'Prov',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_city',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_fax',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'txt_phone',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$mnfst = array( 	'idcab'		=> $this->input->post('txt_idcab'),
								'cabname'	=> $this->input->post('txt_cabname'),
								'addr'		=> $this->input->post('txt_addr'),
								'active'	=> $this->input->post('rg_active'),
								'pic'		=> $this->input->post('txt_pic'),
								'phone'		=> $this->input->post('txt_phone'),
								'city'		=> $this->input->post('txt_city'),
								'fax'		=> $this->input->post('txt_fax'),
								'prov'		=> $this->input->post('txt_prov'),
								'max_stor'	=> $this->fungsi->hapus_koma($this->input->post('txt_max_stor')),
								'lifnr'		=> $this->input->post('txt_lifnr'),
								'werks'		=> $this->input->post('txt_werks'),
								'lgort'		=> $this->input->post('txt_lgort'),
								'addby'		=> $this->session->userdata('uid'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
						);
			$this->cabang_model->add_mnfst($mnfst);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data saved');
			redirect('cabang/cabang_manifest');
			}
		else
			{
				$this->cabang_mnfst();
			}
	}
	
	/* Display list Manifest */
	function cabang_list_mnfst()
	{	
		//Check otorisasi
		$this->fungsi->mnfst_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_supp);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$cabang = $this->cabang_model->get_mnfst_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->cabang_model->count_all_mnfst();
		$config['base_url'] = site_url('cabang/cabang_supp/cabang_list_supp/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID Manifest', 'Delivery No.', 'PIC', 'Status', 'Options');
				
					foreach ($mnfst  as $mnfsts)
					{	
			
		$this->table->add_row($mnfsts->idsupp, $mnfsts->supname, $mnfsts->pic, $this->convert_status_sup($mnfsts->active), anchor('branch/cabang_mnfst/edit_mnfst/'.$supps->idmnfst,'Edit',array('class' => 'update')));	
							
					}
					$data['table'] = $this->table->generate();
					
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'MANIFEST > LIST MANIFEST';
		$this->load->view('branch/cabang_mnfst_list', $data);
		
	}
	
	/* Edit Manifest */
	function edit_mnfst()
	{
		
		//Get data detail Manifest by id cab
		$sql_supp_edit = $this->cabang_model->get_mnfst_detail($this->uri->segment(4));
		
		foreach ($sql_mnfst_edit->result() as $row_mnfst)
		{	
			$data['default']['txt_idcab'] = $row_cab->idcab;
			$data['default']['txt_cabname'] = $row_cab->cabname;
			$data['default']['rg_active'] = $row_cab->active;
			$data['default']['txt_pic'] = $row_cab->pic;
			$data['default']['txt_addr'] = $row_cab->addr;
			$data['default']['txt_prov'] = $row_cab->prov;
			$data['default']['txt_city'] =  $row_cab->city;
			$data['default']['txt_fax'] =  	$row_cab->fax;
			$data['default']['txt_phone'] =  $row_cab->phone;
			$data['default']['txt_max_stor'] = number_format($row_cab->max_stor);
			$data['default']['txt_lifnr'] =  $row_cab->lifnr;
			$data['default']['txt_werks'] =  $row_cab->werks;
			$data['default']['txt_lgort'] =  $row_cab->lgort;
		}
		$data['default']['readonly'] =  'readonly="readonly"';
		
		$data['menu_path'] = 'MANIFEST > LIST MANIFEST > EDIT MANIFEST';
		$data['form_action']= site_url('branch/cabang_mnfst/edit_mnfst_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('cabang/cabang_mnfst/cabang_list_mnfst','Back', array('class' => 'back')));
		$this->load->view('cabang/cabang_manifest_form', $data);
	}
	
	
	/* Cabang edit supplier process */
	function edit_mnfst_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		//Config utk validasi form supplier
 $config = array(
                array(
                     'field'   => 'txt_cabname',
                     'label'   => 'Name',
                     'rules'   => 'required'
                  ),
				array(
                     'field'   => 'txt_lifnr',
                     'label'   => 'Vendor Code SAP',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'txt_pic',
                     'label'   => 'PIC',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'txt_lgort',
                     'label'   => 'Storage Code SAP',
                     'rules'   => 'required'
                  )
				  ,
				   array(
                     'field'   => 'txt_max_stor',
                     'label'   => 'Storage Max Capacity',
                     'rules'   => 'required'
                  )
				   ,
				   array(
                     'field'   => 'txt_max_stor',
                     'label'   => 'Quota maksimal tanki',
                     'rules'   => 'required'
                  )
				   //Not validate form
				  ,array(
                     'field'   => 'txt_addr',
                     'label'   => 'Alamat',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'rg_active',
                     'label'   => 'Status',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_prov',
                     'label'   => 'Prov',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_city',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'txt_fax',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'txt_phone',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$cabang = array( 	
								'cabname'	=> $this->input->post('txt_cabname'),
								'addr'		=> $this->input->post('txt_addr'),
								'active'	=> $this->input->post('rg_active'),
								'pic'		=> $this->input->post('txt_pic'),
								'phone'		=> $this->input->post('txt_phone'),
								'city'		=> $this->input->post('txt_city'),
								'fax'		=> $this->input->post('txt_fax'),
								'prov'		=> $this->input->post('txt_prov'),
								'max_stor'	=> $this->fungsi->hapus_koma($this->input->post('txt_max_stor')),
								'lifnr'		=> $this->input->post('txt_lifnr'),
								'werks'		=> $this->input->post('txt_werks'),
								'lgort'		=> $this->input->post('txt_lgort'),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d H:i:s'),
						);
			$this->cabang_model->update_supp($this->input->post('txt_idsupp'), $supp);
			
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('cabang/cabang_supp/cabang_list_supp');
			}
		else
			{
				$this->edit_supp();
			}
	}
	 //Counter Manifest
	function cabang_count_mnfst()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_counter_mnfst);
			
		$data['menu_path'] = 'BRANCH > MANIFEST > COUNTER MANIFEST';
		$data['form_action']= site_url('cabang/cabang_mnfst/cabang_count_mnfst');
		$this->load->view('branch/cabang_count_form', $data);
		
	}
	
	
}