<?php 
/*
Fungsi : Controller untuk qa
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cabang_qa extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_qa_app  = 93;
	var $menu_add_qa = 125;
	var $menu_list_stb_app  = 126;
	var $menu_add_stb = 91;
	
/*-------------Inisialisasi variabel--------------*/ 

/*------------Fungsi local------------------------*/
	
/*------------Fungsi local------------------------*/
	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/cabang_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->cabang_add_qa();
		
	}
	
	
	function cabang_add_qa()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_qa);
		$data['menu_path'] = 'BRANCH > QUALITY > QUALITY CONTROL';
		$data['form_action']= site_url('branch/cabang_qa/add_qa_proc');
		
		$this->load->view('branch/cabang_qa_form', $data);
		
	}
			
	/* Cabang add qa process */
	function add_qa_proc()
	{	
			
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		$data['prev'] = '';
		
		
		/*Get BA counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'BA');
		$nobaform = $count[0];
		$noba = $count[1];
		
		//Config utk validasi form qa
	$config = array(
                  array(
                     'field'   => 'qctbk',
                     'label'   => 'Chemical',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'qcair',
                     'label'   => 'Water Content',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'qcbakar',
                     'label'   => 'Fuel',
                     'rules'   => 'required'
                  )
				  //Not validate form
				    ,array(
                     'field'   => 'qcresidu',
                     'label'   => 'Residu',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'qct',
                     'label'   => 'Temperature',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'adj',
                     'label'   => 'Volume Adjustment',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'addby',
                     'label'   => 'Add By',
                     'rules'   => ''
                  )
				  ,
				  array(
                     'field'   => 'posting',
                     'label'   => 'Posting Date Available',
                     'rules'   => 'required'

                  ),
				  array(
                     'field'   => 'adddate',
                     'label'   => 'Add Date',
                     'rules'   => ''
                  )
				   //Not validate form
            );
			
		//Data Type form
		$this->load->helper('form'); 
		
		
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data qa */
			$qa = array( 		'idba'	    => $nobaform,
								'idcab'		=> $this->session->userdata('idcab'),
								'qct'	    => $this->input->post('qct'),
								'qcair'		=> $this->input->post('qcair'),
								'qctbk'		=> $this->input->post('qctbk'),
								'qcbakar'	=> $this->input->post('qcbakar'),	
								'qcresidu'	=> $this->input->post('qcresidu'),
								'vol'		=> $this->fungsi->hapus_koma($this->input->post('vol')),
								'adj'  		=> $this->fungsi->hapus_koma($this->input->post('adj')),
								'scrap'	    => $this->fungsi->hapus_koma($this->input->post('adj'))* -1,
								'posting'  	=> date("Y-m-d", strtotime($this->input->post('posting'))),
								'year'	    => date('Y'),
								'inf'	    => $this->input->post('inf'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
								'addby'		=> $this->session->userdata('uid'),
								
						);
						
					/*Insert to t_pcbal*/
		//$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
//								'ref'	 => $noopform,
//								'amount' 	 => $this->fungsi->hapus_koma($this->input->post('pur')) * -1,
//								
//								'addby'		 => $this->session->userdata('uid'),
//								'adddate' 	 => date( 'Y-m-d H:i:s'),
//								);
			/*Insert to t_stockbal*/
		/*$salbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 => $noopform,
								'qty'		 => $this->input->post('vol'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);*/
				
			$this->cabang_model->add_qa($qa);
		/*Set pesan sukses dan kembali ke menu add qa*/
			
			$this->session->set_flashdata('idba', $this->input->post('idba'));
			$this->session->set_flashdata('message_ok', 'Data saved, BA Number :'.$nobaform);
			redirect('branch/cabang_qa');
			}
		else
			{
				$this->cabang_add_qa();
			}
	}
	

/*Print QA*/
function print_qa_popup()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Get data for print
	$query_qa = $this->cabang_model->get_list_qa_print_paging($this->uri->segment(4),$this->uri->segment(5));
	foreach ($query_qa->result() as $row_qa)
		{
			$data['idba'] = $row_qa->idba;
			$data['qcresidu'] = $row_qa->qcresidu;
			$data['adddate'] = date("d.m.Y",   strtotime($row_qa->adddate));	
			$data['qcair'] = $row_qa->qcair;
			$data['qctbk'] = $row_qa->qctbk;
			$data['inf'] = $row_qa->inf;
			$data['vol'] = $row_qa->vol;
			$data['scrap'] = $row_qa->scrap;
			$data['adj'] = $row_qa->adj;
			$data['qct'] = $row_qa->qct;
			$data['qcbakar'] = $row_qa->qcbakar;
			$data['addby'] = $row_qa->addby;
			$data['idcab'] = $this->session->userdata('idcab');
			}
//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_qa->idcab);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['cabname'] = $row_cab->cabname;
				}
$this->load->view('popup/popup_ba', $data);
	
}

	
	
	/* Display list qa */
	function cabang_list_qa_app()
	{	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_qa_app);
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$qa = $this->cabang_model->get_qa_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->cabang_model->count_all_qa();
		$config['base_url'] = site_url('branch/cabang_qa/cabang_list_qa_app/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID BA', 'Vol', 'Adjustment', 'Options');
				    
					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
				
					foreach ($qa  as $qas)
					{	
			
		$this->table->add_row($qas->idba, $qas->vol, $qas->adj,  anchor('branch/cabang_qa/edit_qa/$qas->idba','Cancel',array('class' => 'update')).' '.anchor_popup('branch/cabang_qa/print_qa_popup/'.$qas->idba,'Print',array('class'=> 'print',$atts),$atts));
		
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'BRANCH > QUALITY > LIST BA APPROVAL';
		$this->load->view('branch/cabang_qa_list', $data);
		
	}
	
function cabang_stb_qa()
{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_qa);
		$data['menu_path'] = 'BRANCH > QUALITY > QA GOODS RECEIPT';
		$data['form_action']= site_url('branch/cabang_qa/cabang_stb_qa_proc');
		
		$this->load->view('branch/cabang_stb_form', $data);
		
	}


function cabang_stb_qa_proc()
{
	
	
	//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		$data['prev'] = '';
		
	/* Set validasi */
		$config = array(
					array(
                     'field'   => 'qctbk',
                     'label'   => 'Chemical',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'nama_supp',
                     'label'   => 'Supplier',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'nama_trans',
                     'label'   => 'Transporter',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'qcair',
                     'label'   => 'Water Content',
                     'rules'   => 'required'
                  ),
				  array(
                     'field'   => 'qcbakar',
                     'label'   => 'Fuel',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'qcresidu',
                     'label'   => 'Residu',
                     'rules'   => 'required'
                  )
				    ,array(
                     'field'   => 'qct',
                     'label'   => 'Temperature',
                     'rules'   => 'required'
            ) ,array(
                     'field'   => 'vol',
                     'label'   => 'Volume',
                     'rules'   => 'required'
            ) ,array(
                     'field'   => 'donumb',
                     'label'   => 'DO Number',
                     'rules'   => 'required'
            ) ,array(
                     'field'   => 'posting',
                     'label'   => 'Posting Date',
                     'rules'   => 'required'
            ) ,array(
                     'field'   => 'mnfst',
                     'label'   => 'Manifest Number',
                     'rules'   => 'required'
            ),array(
                     'field'   => 'volmnfst',
                     'label'   => 'Vol Manifest',
                     'rules'   => 'required'
            )
			);
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{	
				//Check otorisasi transaksi
	//$this->fungsi->trans_auth($this->session->userdata('add'));
	
	/*Get stb counter*/
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'STB');
		$nostbform = $count[0];
		$nostb = $count[1];
	/* Insert data */
			$stb = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'idstb'	     => $nostbform,
								'qct'	     => $this->input->post('qct'),
								'qcair'		 => $this->input->post('qcair'),
								'qctbk'		 => $this->input->post('qctbk'),
								'idtop'		 => $this->input->post('idtop'),
								'volmnfst'		 => $this->fungsi->hapus_koma($this->input->post('volmnfst')),
								'slsh'		 => $this->fungsi->hapus_koma($this->input->post('slsh')),
								'idsupp'	 => $this->input->post('idsupp'),
								'suppname'		 => $this->input->post('nama_supp'),
								'idtrans'		 => $this->input->post('idtrans'),
								'transname'		 => $this->input->post('nama_trans'),
								'qcbakar'	 => $this->input->post('qcbakar'),	
								'vnumb'  	=> $this->input->post('vnumb'),
								'qcresidu'	 => $this->input->post('qcresidu'),
								'inf'	     => $this->input->post('inf'),
								'mnfst'	     => $this->input->post('mnfst'),
								'type'	     => $this->input->post('type'),
								'year'	    => date('Y'),
								'donumb'	 => $this->input->post('donumb'),
								'vol'		 => $this->fungsi->hapus_koma($this->input->post('vol')),
								'posting'  	=> date("Y-m-d", strtotime($this->input->post('posting'))),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
	
			//Get nama cabang
			$sql_cab_detail = $this->admin_model->get_cab_detail($this->input->post('txt_idcab'));
			foreach ($sql_cab_detail->result() as $row_cab);
								
			$this->cabang_model->add_stb($stb);
			/*Set pesan sukses dan kembali ke menu add cabang*/
			$this->session->set_flashdata('message_ok', 'Data saved, STB number :'.$nostbform);
			redirect('branch/cabang_qa/cabang_stb_qa');
			
			}
		else
			{
				
				$this->cabang_stb_qa();
				
			}
}	
/*Print stb*/
function print_stb_popup()
{
	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Get data for print
	$nostb = $this->uri->segment(4).'/'.$this->uri->segment(5).'/'.$this->uri->segment(6).'/'.$this->uri->segment(7).'/'.$this->uri->segment(8);

	$query_stb = $this->cabang_model->get_list_stb_print_paging($nostb);
	
	foreach ($query_stb->result() as $row_stb)
		{
			$data['idba'] = $row_stb->idba;
			$data['qcresidu'] = $row_stb->qcresidu;
			$data['adddate'] = date("d.m.Y",   strtotime($row_stb->adddate));	
			$data['qcair'] = $row_stb->qcair;
			$data['qctbk'] = $row_stb->qctbk;
			$data['inf'] = $row_stb->inf;
			$data['stb'] = $row_stb->idstb;
			$data['vol'] = $row_stb->vol;
			$data['qct'] = $row_stb->qct;
			$data['qcbakar'] = $row_stb->qcbakar;
			$data['suppname'] = $row_stb->suppname;
			$data['addby'] = $row_stb->addby;
			$data['idcab'] = $row_stb->idcab;
			}
//Get data detail cabang by id cabang
				$sql_cab_detail = $this->admin_model->get_cab_detail($row_stb->idstb);
				foreach ($sql_cab_detail->result() as $row_cab)
				{	
					$data['cabname'] = $row_cab->cabname;
				}
$this->load->view('popup/popup_stb', $data);
	
}

	
	
	/* Display list stb */
	function cabang_list_stb_app()
	{	
		
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_stb_app);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
			
		$stb = $this->cabang_model->get_stb_paging($this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->cabang_model->count_all_stb();
		$config['base_url'] = site_url('branch/cabang_qa/cabang_list_stb_app/');
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID STB', 'Supp', 'Vol Manifest','Vol STB', 'Selisih', 'Transporter', 'DO Number', 'Manifest', 'No. Pol', 'Keterangan','Options');
				    
					$atts = array(
              'width'      => '1000',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );
				
					foreach ($stb  as $stbs)
					{	
			
		$this->table->add_row($stbs->idstb, $stbs->suppname,$stbs->volmnfst,$stbs->vol,$stbs->slsh,$stbs->transname, $stbs->donumb, $stbs->mnfst, $stbs->vnumb, $stbs->inf,  anchor('branch/cabang_qa/edit_stb/$stbs->idstb','Edit',array('class' => 'update')).' '. anchor('branch/cabang_qa/edit_stb/$stbs->idstb','Delete',array('class' => 'update')).' '.anchor_popup('branch/cabang_qa/print_stb_popup/'.$stbs->idstb,'Print STB',array('class'=> 'print',$atts),$atts));
		
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'BRANCH > QUALITY > LIST QA GOODS RECEIPT';
		$this->load->view('branch/cabang_stb_list', $data);
		
	}
	
	function del_stb()
{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('delete'));
	
	$this->cabang_model->del_stb($this->uri->segment(4));
	$this->session->set_flashdata('message_ok', 'STB succesfully delete');
	redirect('branch/cabang_qa/cabang_stb_list');
}
	
	
	/* Edit stb */
	function edit_stb()
	{
		
		//Get data detail qa
		$sql_stb_edit = $this->cabang_model->get_stb_detail($this->uri->segment(4));
		
		foreach ($sql_stb_edit->result() as $row_qa)
		{	
			$data['default']['idcab']   = $row_qa->idcab;
			$data['default']['vol']     = $row_qa->vol;
			$data['default']['type']    = $row_qa->type;
			$data['default']['idsupp']  = $row_qa->idsupp;
			$data['default']['idtrans'] = $row_qa->idtrans;
			$data['default']['vnumb']   = $row_qa->vnumb;
			$data['default']['prnumb']  =  $row_qa->prnumb;
			$data['default']['donumb']  =  	$row_qa->donumb;
			$data['default']['mnfst']   =  $row_op->mnfst;
			$data['default']['inf']     = $row_op->inf;
			$data['default']['invoice']     = $row_op->invoice;
			$data['default']['adddate'] =  $row_op->adddate;
			$data['default']['chdate']  =  $row_op->chdate;
			$data['default']['chby']    =  $row_op->chby;
			$data['default']['addby']   =  $row_op->addby;
		}
		$data['default']['readonly'] =  'readonly="readonly"';
		
		$data['menu_path'] = 'BRANCH > QUALITY > LIST EDIT GOODS RECEIPT';
		$data['form_action']= site_url('branch/cabang_qa/edit_stb_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('branch/cabang_qa/cabang_list_qa','Back', array('class' => 'back')));
		$this->load->view('branch/cabang_stb_form', $data);
	}
	
	
	
	/* Cabang edit stb process */
	function edit_stb_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		//Config utk validasi form qa
 $config = array(
 					array(
                     'field'   => 'idtrans',
                     'label'   => 'ID Transporter',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'adddate',
                     'label'   => 'Add Date',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'chdate',
                     'label'   => 'Change Date',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'chby',
                     'label'   => 'Change By',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'addby',
                     'label'   => 'Add By',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$stb_cancel = array( 'idstb'	=> $nobaform,
								'idcab'		=> $this->session->userdata('idcab'),
								'qct'	    => $this->input->post('qct'),
								'qcair'		=> $this->input->post('qcair'),
								'qctbk'		=> $this->input->post('qctbk'),
								'qcbakar'	=> $this->input->post('qcbakar'),	
								'qcresidu'	=> $this->input->post('qcresidu'),
								'vol'		=> $this->fungsi->hapus_koma($this->input->post('vol')),
								'adj'  		=> $this->fungsi->hapus_koma($this->input->post('adj')),
								'scrap'	    => $this->fungsi->hapus_koma($this->input->post('scrap')),
								'year'	    => date('Y'),
								'inf'	    => $this->input->post('inf'),
								'chdate'	=> date( 'Y-m-d H:i:s'),
								'chby'		=> $this->session->userdata('uid'),
								'cancel'	=> 1,
								
						);
						
					/*Insert to t_pcbal*/
					$pcbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
											'ref'	 	 => $noopcform,
											'amount' 	 => $this->fungsi->hapus_koma($this->input->post('fee')),
											'addby'		 => $this->session->userdata('uid'),
											'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			/*Insert to t_stockbal*/
		$salbal = array( 		'idcab'		 => $this->session->userdata('idcab'),
								'ref'	 => $noopcform,
								'qty'		 => $this->input->post('vol'),
								'addby'		 => $this->session->userdata('uid'),
								'adddate' 	 => date( 'Y-m-d H:i:s'),
								);
								
			$this->cabang_model->update_op($this->input->post('idba'), $qa_cancel);
			$this->branch_model->add_pc_branch($pcbal);
			$this->cabang_model->add_saldo_branch($salbal);
			
			/*Set pesan sukses dan kembali ke menu add op*/
			$this->session->set_flashdata('message_ok', 'Data CANCELED');
			redirect('branch/cabang_qa/cabang_list_stb');
			}
		else
			{
				$this->edit_stb();
			}
	}
	
}
