<?php
/*
Fungsi : Controller untuk transporter
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cabang_trans extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	
/*-------------Inisialisasi variabel--------------*/ 
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_trans  = 50;
	var $menu_add_trans = 49;
	
/*-------------Inisialisasi variabel--------------*/ 	

/*------------Fungsi lokal------------------------*/	
/* Fungsi untuk convert status supp */
 	function convert_status_trans($status)
	{
		
		switch ($status)
		{
			case 1:
			  $status = '<font color="#00CC00"><b>WGI</b></font>';
			  break;
			case 0:
			  $status = '<font color="#FF0000"><b>Ext WGI</b></font>';
			  break;
		}
	
	return $status;
		
	}

/*------------Fungsi local------------------------*/	
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('branch/cabang_model', '', TRUE);
		$this->fungsi->check_login();
	}
	
	
	public function index()
	{	
		$this->cabang_add_trans();
		
	}

	/*  add transporter */
	function cabang_add_trans()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_trans);
			
		$data['menu_path'] = 'BRANCH > TRANSPORTER > ADD TRANSPORTER';
		$data['form_action']= site_url('branch/cabang_trans/add_trans_proc');
		$this->load->view('branch/cabang_trans_form', $data);
		
	}
	
	
	/* Admin add trans process */
	function add_trans_proc()
	{	
		//Check otorisasi transaksi
		//$this->fungsi->trans_auth($this->session->userdata('add'));
		
		//Config utk validasi form trans
	$config = array(
               array(
                     'field'   => 'name',
                     'label'   => 'Name Transporter',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'pic',
                     'label'   => 'PIC',
                     'rules'   => 'required'
                  ),
				  //Not validate form
				  array(
                     'field'   => 'idtrans',
                     'label'   => 'Trans ID',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'active',
                     'label'   => 'Status',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'idcab',
                     'label'   => 'II cabang',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'addr',
                     'label'   => 'Address',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'prov',
                     'label'   => 'Prov',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'city',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'fax',
                     'label'   => 'Fax',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'phone',
                     'label'   => 'Phone',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		//Check validasi form
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$trans = array( 	
								'name'	    => $this->input->post('name'),
								'idcab'		=> $this->session->userdata('idcab'),
								'idtrans'	=> $this->input->post('idtrans'),
								'mbrekomklh'	=> date("Y-m-d", strtotime($this->input->post('mbrekomklh'))),
								'mbijindarat'	=>date("Y-m-d", strtotime($this->input->post('mbijindarat'))),
								'mbstnk'	=> date("Y-m-d", strtotime($this->input->post('mbstnk'))),
								'mbpajak'	=> date("Y-m-d", strtotime($this->input->post('mbpajak'))),
								'mbkir'	    => date("Y-m-d", strtotime($this->input->post('mbkir'))),
								'vnumb'  	=> $this->input->post('vnumb'),
								'addr'		=> $this->input->post('addr'),
								'status'	=> $this->input->post('active'),
								'pic'		=> $this->input->post('pic'),
								'phone'		=> $this->input->post('phone'),
								'city'		=> $this->input->post('city'),
								'fax'		=> $this->input->post('fax'),
								'prov'		=> $this->input->post('prov'),
								'addby'		=> $this->session->userdata('uid'),
								'adddate' 	=> date( 'Y-m-d H:i:s'),
						);
			$this->cabang_model->add_trans($trans);
			
			/*Set pesan sukses dan kembali ke menu add */
			$this->session->set_flashdata('message_ok', 'Data saved');
			redirect('branch/cabang_trans');
			}
		else
			{
				$this->cabang_add_trans();
			}
	}
	
	/* Display list trans */
	function cabang_list_trans()
	{	
	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_trans);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } 
			else 
			{
                $data['search']  =  $this->session->userdata('sess_search');
            }
			
		$trans = $this->cabang_model->get_trans_paging($this->config->item('paging_limit'), $offset,$data['search'])->result();
		
		$num_rows = $this->cabang_model->count_all_trans( $data['search']);
		$config['base_url'] = site_url('branch/cabang_trans/cabang_list_trans/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('Trans ID', 'Name', 'PIC', 'Status', 'Options');
				
					foreach ($trans  as $transs)
					{	
			
		$this->table->add_row($transs->idtrans, $transs->name, $transs->pic, $this->convert_status_trans($transs->status), anchor('branch/cabang_trans/edit_trans/'.$transs->idtrans,'Edit',array('class' => 'update')).'  '.anchor('branch/cabang_trans/del_trans/'.$transs->idtrans,'Delete',array('class'=> 'delete','onclick'=>"return confirm('Delete Transport with ID ".$transs->idtrans." ?')")));		
							
					}
					$data['table'] = $this->table->generate();
					
				}
			else
				{
					$data['message'] = 'No data';
				}		
		$data['menu_path'] = 'BRANCH > TRANSPORTER > TRANSPORTER LIST';
		$data['form_action']= site_url('branch/cabang_trans/cabang_list_trans/');
		$this->load->view('branch/cabang_trans_list', $data);
		
	}
	
	function del_trans()
{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('delete'));
	
	$this->cabang_model->del_trans($this->uri->segment(4));
	$this->session->set_flashdata('message_ok', 'Transporter succesfully delete');
	redirect('branch/cabang_trans/cabang_list_trans');
}
	
	/* Edit transporter */
	function edit_trans()
	{
		
		//Get data detail  by id trans
		$sql_trans_edit = $this->cabang_model->get_trans_detail($this->uri->segment(4));
		
		foreach ($sql_trans_edit->result() as $row_trans)
		{	
			$data['default']['idtrans'] = $row_trans->idtrans;
			$data['default']['name'] = $row_trans->name;
			$data['default']['active'] = $row_trans->status;
			$data['default']['pic'] = $row_trans->pic;
			$data['default']['addr'] = $row_trans->addr;
			$data['default']['prov'] = $row_trans->prov;
			$data['default']['city'] =  $row_trans->city;
			$data['default']['fax'] =  	$row_trans->fax;
			$data['default']['vnumb'] =  $row_trans->vnumb;
			$data['default']['mbrekomklh'] =  $row_trans->mbrekomklh;
			$data['default']['mbijindarat'] =  $row_trans->mbijindarat;
			$data['default']['mbstnk'] =  $row_trans->mbstnk;
			$data['default']['mbpajak'] =  $row_trans->mbpajak;
			$data['default']['mbkir'] =  $row_trans->mbkir;
			$data['default']['phone'] =  $row_trans->phone;
			
			
		}
		$data['default']['readonly'] =  'readonly="readonly"';
		
		$data['menu_path'] = 'BRANCH > TRANSPORTER  > LIST TRANSPORTER > EDIT TRANSPORTER';
		$data['form_action']= site_url('branch/cabang_trans/edit_trans_proc/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('branch/cabang_trans/cabang_list_trans','Back', array('class' => 'back')));
		$this->load->view('branch/cabang_trans_form', $data);
	}
	
	
	/*  edit transporter process */
	function edit_trans_proc()
	{	
		//Check otorisasi transaksi
		$this->fungsi->trans_auth($this->session->userdata('edit'));
		
		//Config utk validasi form transporter
 $config = array(
                array(
                     'field'   => 'name',
                     'label'   => 'Name Transporter',
                     'rules'   => 'required'
                  ),
				   array(
                     'field'   => 'pic',
                     'label'   => 'PIC',
                     'rules'   => 'required'
                  ),
				  //Not validate form
				  array(
                     'field'   => 'idtrans',
                     'label'   => 'Trans ID',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'active',
                     'label'   => 'Status',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'idcab',
                     'label'   => 'II cabang',
                     'rules'   => ''
                  )
				  ,array(
                     'field'   => 'addr',
                     'label'   => 'Address',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'prov',
                     'label'   => 'Prov',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'city',
                     'label'   => 'City',
                     'rules'   => ''
                  )
				   ,array(
                     'field'   => 'fax',
                     'label'   => 'Fax',
                     'rules'   => ''
                  )
				    ,array(
                     'field'   => 'phone',
                     'label'   => 'Phone',
                     'rules'   => ''
                  )
				   //Not validate form
            );
	
	
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
			/* Insert data */
			$trans = array( 	
								'name'	         => $this->input->post('name'),
								'idcab'		     => $this->session->userdata('idcab'),
								'mbrekomklh'	 => date("Y-m-d", strtotime($this->input->post('mbrekomklh'))),
								'mbijindarat'	 =>date("Y-m-d", strtotime($this->input->post('mbijindarat'))),
								'mbstnk'	     => date("Y-m-d", strtotime($this->input->post('mbstnk'))),
								'mbpajak'	     => date("Y-m-d", strtotime($this->input->post('mbpajak'))),
								'mbkir'	         => date("Y-m-d", strtotime($this->input->post('mbkir'))),
								'vnumb'  	     => $this->input->post('vnumb'),
								'addr'		     => $this->input->post('addr'),
								'status'	=> $this->input->post('active'),
								'pic'		=> $this->input->post('pic'),
								'phone'		=> $this->input->post('phone'),
								'city'		=> $this->input->post('city'),
								'fax'		=> $this->input->post('fax'),
								'prov'		=> $this->input->post('prov'),
								'chby'		=> $this->session->userdata('uid'),
								'chdate' 	=> date( 'Y-m-d H:i:s'),
						);
			$this->cabang_model->update_trans($this->uri->segment(4), $trans);
			
			/*Set pesan sukses dan kembali ke menu add transporter*/
			$this->session->set_flashdata('message_ok', 'Data changed');
			redirect('branch/cabang_trans/cabang_list_trans');
			}
		else
			{
				$this->edit_trans();
			}
	}
	
}