<?php 
/*
Fungsi : Controller untuk master data group
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class M_group extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('legal/group_model', '', TRUE);
		$this->fungsi->check_login();
		$this->fungsi->sess_search_segment();
	}
	
	//Menu ID utk keperluan otorisasi
	var $menu_list_group  = 12;
	var $menu_add_group = 50;
	
	public function index()
	{	
		$this->add_m_group();
	}
	
	/* Form add role */
	function add_m_group()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_group);
	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$list_group = $this->group_model->get_paging_group($this->config->item('paging_limit'), $offset, $data['search'])->result	
		();
		$num_rows = $this->group_model->count_rows_group( $data['search']);
		$config['base_url'] = site_url('legal/m_group/add_m_group/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Nama', 'Keterangan', 'PIC', 'Options');
				
					foreach ($list_group as $row)
					{	
		$this->table->add_row($row->idcab, $row->cabname, $row->cabshorttxt, $row->pic,
		anchor('legal/m_group/edit_group/'.$row->idcab,'Edit',array('class' => 'update')));
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		
		//Get last last id
		$query_id =  $this->fungsi->get_last_id('m_cab')->result();	

		foreach($query_id as $row);
		$last_id = $row->Auto_increment;
		
		$data['default']['txt_id'] = $last_id;
		
		$data['menu_path'] = 'MASTER DATA > MASTER GROUP > ENTRY/LIST GROUP';
		$data['form_action']= site_url('legal/m_group/do_add_group');
		$data['add_disabled']='disabled="disabled"';
		$this->load->view('legal/m_group_form', $data);
		
	}
	
	/* Add Master Data Group */
	function do_add_group()
	{	
	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		$config = array(
                array(
						 'field'   => 'txt_nama',
						 'label'   => 'Nama Group',
						 'rules'   => 'required'
					  ),
				 array(
						 'field'   => 'txt_pic',
						 'label'   => 'PIC',
						 'rules'   => 'required'
					  ),
            );
			
		$this->form_validation->set_rules($config); 
		if ($this->form_validation->run() == TRUE)
			{
				
				/* Insert data */
				$group	   = array( 'cabname'			=> $this->input->post('txt_nama'),
									'cabshorttxt'		=> $this->input->post('txt_desc'),
									'pic'				=> $this->input->post('txt_pic'),
									'addby'				=> $this->session->userdata('uid'),
									'adddate'			=> date('Y-m-d H:i:s'),
							);
				$this->group_model->add_group($group);
				$this->session->set_flashdata('message_ok', 'Data input succesfully');			
				redirect('legal/m_group');
			}
		else
			{
				$this->add_m_group();
			}
	}
	
	/* Edit Data Group */
	function edit_group()
	{
		//Check otorisasi
			$this->fungsi->trans_auth($this->session->userdata('edit'));
			$query_edit = $this->group_model->get_groupdata($this->uri->segment(4))->row();
			
			$data['default']['txt_id'] 			= $query_edit ->idcab;
			$data['default']['txt_nama'] 		= $query_edit ->cabname;
			$data['default']['txt_desc'] 		= $query_edit ->cabshorttxt;
			$data['default']['txt_pic'] 		= $query_edit ->pic;
					
		$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > EDIT DATA GROUP';
		$data['form_action']= site_url('legal/m_group/update_group/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('legal/m_group/#tabs-2','Back', array('class' => 'back')));
		$data['add_disabled']='';
		$this->load->view('legal/m_group_form', $data);
	}
	
	/* Update group */
	function update_group()
	{	
		
	$config = array(
				array(
						 'field'   => 'txt_nama',
						 'label'   => 'Name',
						 'rules'   => 'required'
					  ),	
				array(
						 'field'   => 'txt_pic',
						 'label'   => 'PIC',
						 'rules'   => 'required'
					  ),	
            );
			
		$this->form_validation->set_rules($config); 
		if ($this->form_validation->run() == TRUE)
			{
				
				/* Insert data */
				$group = array( 
									'cabname'			=> $this->input->post('txt_nama'),
									'cabshorttxt'   	=> $this->input->post('txt_desc'),
									'pic'				=> $this->input->post('txt_pic'),	
									'chby'				=> $this->session->userdata('uid'),
									'chdate'			=> date('Y-m-d H:i:s'),
							);
						
				$this->group_model->update_group($this->uri->segment(4), $group);
				$this->session->set_flashdata('message_ok', 'Data Update Succesfully');
				redirect('legal/m_group/add_m_group/#tabs-2');
			}
		else
			{
				$this->add_m_group();
			}
	
	}
}