<?php 
/*
Fungsi : Controller untuk master perijinan
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class M_perijinan extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('legal/perijinan_model', '', TRUE);
		$this->fungsi->check_login();
		$this->fungsi->sess_search_segment();
	}
	
	//Menu ID utk keperluan otorisasi
	var $menu_add_perijinan = 43;
	
	public function index()
	{	
		$this->add_m_perijinan();
	}
	
	/* Form add role */
	function add_m_perijinan()
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_add_perijinan);
	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		 if(isset($_POST['submit']))
            {
                $data['search'] = $this->input->post('txt_search');
	                //set session user data untuk pencarian, untuk paging pencarian
	                $this->session->set_userdata('sess_search', $data['search']);
            } else {
                $data['search']  =  $this->session->userdata('sess_search');
            }
		
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		$list_mperijinan = $this->perijinan_model->get_paging_masterperijinan($this->config->item('paging_limit'), $offset, $data[	
		'search'])->result();
		$num_rows = $this->perijinan_model->count_rows_masterperijinan( $data['search']);
		$config['base_url'] = site_url('legal/m_perijinan/add_m_perijinan/');
		$data['total'] = $num_rows;
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;
					
					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);
		
					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('ID', 'Keterangan', 'Options');
				
					foreach ($list_mperijinan as $row)
					{	
		$this->table->add_row($row->id, $row->ket_group,
		anchor('legal/m_perijinan/edit_perijinan/'.$row->id,'Edit',array('class' => 'update')));
					}
					$data['table'] = $this->table->generate();
				}
			else
				{
					$data['message'] = 'No data to display';
				}		
		
		//Get last id
		$query_id =  $this->fungsi->get_last_id('group')->result();	

		foreach($query_id as $row);
		$last_id = $row->Auto_increment;
		
		$data['default']['txt_id'] = $last_id;
		
		$data['menu_path'] = 'MASTER DATA > MASTER PERIJINAN > ENTRY/LIST PERIJINAN';
		$data['form_action']= site_url('legal/m_perijinan/do_add_perijinan');
		$data['add_disabled']='disabled="disabled"';
		$this->load->view('legal/m_perijinan_form', $data);
		
	}
	
	/* Add Master Data Perijinan */
	function do_add_perijinan()
	{	
	
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('add'));
		
		$config = array(
                array(
						 'field'   => 'txt_desc',
						 'label'   => 'Keterangan',
						 'rules'   => 'required'
					  ),
            );
			
		$this->form_validation->set_rules($config); 
		if ($this->form_validation->run() == TRUE)
			{	
				/* Insert data */
				$perijinan = array( 'ket_group'		=> $this->input->post('txt_desc'),
									'roleid'		=> $this->session->userdata('roleid'),
							);
				$this->perijinan_model->add_perijinan($perijinan);
				$this->session->set_flashdata('message_ok', 'Data input succesfully');			
				redirect('legal/m_perijinan');
			}
		else
			{
				$this->add_m_perijinan();
			}
	}
	
	/* Edit Perijinan */
	function edit_perijinan()
	{
				
		//Check otorisasi
			$this->fungsi->trans_auth($this->session->userdata('edit'));
			$query_edit = $this->perijinan_model->get_groupmaster($this->uri->segment(4))->row();
		
			$data['default']['txt_id'] 			= $query_edit ->id;
			$data['default']['txt_desc'] 		= $query_edit ->ket_group;
					
		$data['menu_path'] = 'PERIJINAN > MASTER DATA PERIJINAN > EDIT DATA PERIJINAN';
		$data['form_action']= site_url('legal/m_perijinan/update_mperijinan/'.$this->uri->segment(4));
		$data['link'] = array('link_back' => anchor('legal/m_perijinan/#tabs-2','Back', array('class' => 'back')));
		$data['add_disabled']='';
		$this->load->view('legal/m_perijinan_form', $data);
	}
	
	/* Update Master Perijinan */
	function update_mperijinan()
	{	
		
	$config = array(
				array(
						 'field'   => 'txt_desc',
						 'label'   => 'Keterangan Perijinan',
						 'rules'   => 'required'
					  ),	
            );
			
		$this->form_validation->set_rules($config); 
		if ($this->form_validation->run() == TRUE)
			{
				
				/* Insert data */
				$perijinan = array( 
									'roleid'			=> $this->session->userdata('roleid'),
									'ket_group'			=> $this->input->post('txt_desc'),	
							);
						
				$this->perijinan_model->update_masterperijinan($this->uri->segment(4), $perijinan);
				$this->session->set_flashdata('message_ok', 'Data Update Succesfully');
				redirect('legal/m_perijinan/add_m_perijinan/#tabs-2');
			}
		else
			{
				$this->add_m_perijinan();
			}
	
	}

	
}