<?php 
/*
Fungsi : Controller untuk frame body
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ppicSample extends CI_Controller {
	
	//Menu ID utk keperluan otorisasi
	var $menu_create_form_sample_lab = 175;
	var $menu_print_sertifikat = 180;
	var $list_ba_sample = 210;
	
	public function index()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_form_sample_lab);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->ppic_sample_model->viewBeritaAcara($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->ppic_sample_model->countBeritaAcara($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('ppic_sample/ppicSample/index');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Options');
				
			foreach($berita_acara as $row)
			{
				if($this->ppic_sample_model->viewResampleStatus($row->id_ba) == '1')
				{
					$this->table->add_row($row->id_ba, anchor('ppic_sample/ppicSample/resampleForm/'.$row->id,'Resample Form',array('class' => 'update')));
				} elseif($this->ppic_sample_model->viewResampleStatus($row->id_ba) == '2')
				{
					$this->table->add_row($row->id_ba, anchor('ppic_sample/ppicSample/resampleForm2/'.$row->id,'Resample Form ke-2',array('class' => 'update')));
				} else
				{
					$this->table->add_row($row->id_ba, anchor('ppic_sample/ppicSample/createForm/'.$row->id,'Create Form',array('class' => 'update')));
				}
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > PPIC > CREATE FORM SAMPLE LAB';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('ppic_sample/ppicSample/index');
		$this->load->view('ppic_sample/tampil_berita_acara', $data);
	}

	public function resampleForm($id)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_form_sample_lab);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > PPIC > FORM DAN LABEL SAMPLE';
		$nomor_sample = preg_replace('/\D/', '', $this->ppic_sample_model->getNomorBeritaAcara($id));
		$nomor_sample = $nomor_sample.'R';

		$where = array('id_sample_lab' => $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample)));
		$cek = $this->ppic_sample_model->getDataWhere('t_qa', $where)->num_rows();
		if($cek == 0)
		{
			$dataAddToQA = array('id_sample' => $nomor_sample,
								 'idba' => $this->ppic_sample_model->getNomorBeritaAcara($id),
								 'id_sample_ppic' => $this->tsfs->entsfs($nomor_sample), 
								 'id_sample_lab' => $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample)),
								 'addby' => $this->session->userdata('uid'),
								 'adddate' => date('Y-m-d H:i:s'),
								 'year' => date('Y')
						   );
			$this->ppic_sample_model->createDataToQA('t_qa', $dataAddToQA);
		}

		$data['id_formulir'] = $id;
		$data['nomor_sample'] = $nomor_sample;
		$data['kode_label_ppic'] = $this->tsfs->entsfs($nomor_sample);
		$data['kode_label_lab'] = $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample));
		$this->load->view('ppic_sample/form_dan_label_sample', $data);
	}

	public function resampleForm2($id)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_form_sample_lab);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > PPIC > FORM DAN LABEL SAMPLE';
		$nomor_sample = preg_replace('/\D/', '', $this->ppic_sample_model->getNomorBeritaAcara($id));
		$nomor_sample = $nomor_sample.'RR';

		$where = array('id_sample_lab' => $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample)));
		$cek = $this->ppic_sample_model->getDataWhere('t_qa', $where)->num_rows();
		if($cek == 0)
		{
			$dataAddToQA = array('id_sample' => $nomor_sample,
								 'idba' => $this->ppic_sample_model->getNomorBeritaAcara($id),
								 'id_sample_ppic' => $this->tsfs->entsfs($nomor_sample), 
								 'id_sample_lab' => $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample)),
								 'addby' => $this->session->userdata('uid'),
								 'adddate' => date('Y-m-d H:i:s'),
								 'year' => date('Y')
						   );
			$this->ppic_sample_model->createDataToQA('t_qa', $dataAddToQA);
		}

		$data['id_formulir'] = $id;
		$data['nomor_sample'] = $nomor_sample;
		$data['kode_label_ppic'] = $this->tsfs->entsfs($nomor_sample);
		$data['kode_label_lab'] = $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample));
		$this->load->view('ppic_sample/form_dan_label_sample', $data);
	}

	public function createForm($id)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_form_sample_lab);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['menu_path'] = 'CIBITUNG > PPIC > FORM DAN LABEL SAMPLE';
		$nomor_sample = preg_replace('/\D/', '', $this->ppic_sample_model->getNomorBeritaAcara($id));

		$where = array('id_sample_lab' => $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample)));
		$cek = $this->ppic_sample_model->getDataWhere('t_qa', $where)->num_rows();
		if($cek == 0)
		{
			$dataAddToQA = array('id_sample' => $nomor_sample,
								 'idba' => $this->ppic_sample_model->getNomorBeritaAcara($id),
								 'id_sample_ppic' => $this->tsfs->entsfs($nomor_sample), 
								 'id_sample_lab' => $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample)),
								 'addby' => $this->session->userdata('uid'),
								 'adddate' => date('Y-m-d H:i:s'),
								 'year' => date('Y')
						   );
			$this->ppic_sample_model->createDataToQA('t_qa', $dataAddToQA);
		}

		$data['id_formulir'] = $id;
		$data['nomor_sample'] = $nomor_sample;
		$data['kode_label_ppic'] = $this->tsfs->entsfs($nomor_sample);
		$data['kode_label_lab'] = $this->tsfs->entsfs($this->tsfs->entsfs($nomor_sample));
		$this->load->view('ppic_sample/form_dan_label_sample', $data);
	}

	public function cetakFormulir($id_sample)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_form_sample_lab);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		$data['row'] = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row();
		$this->load->view('ppic_sample/cetak_formulir', $data);
	}

	public function cetakLabel($id_sample)
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_form_sample_lab);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));

		$data['kode_label_ppic'] = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('id_sample_ppic');
		$data['kode_label_lab'] = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('id_sample_lab');
		$this->load->view('ppic_sample/cetak_label', $data);
	}

	public function viewListPrintSertifikat()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_print_sertifikat);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->ppic_sample_model->viewNomorSampleForSertifikat($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->ppic_sample_model->countNomorSampleForSertifikat($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('ppic_sample/ppicSample/viewListPrintSertifikat');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Options');
				
			foreach($nomor_sample as $row)
			{	
				$this->table->add_row($row->idba, anchor('ppic_sample/ppicSample/printSertifikat/'.$row->id_sample,'Print Sertifikat',array('class' => 'update', 'target' => '_blank')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > PPIC > PRINT SERTIFIKAT';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('ppic_sample/ppicSample/viewListPrintSertifikat');
		$this->load->view('ppic_sample/tampil_berita_acara', $data);
	}

	public function viewListPrintSertifikatRetesting()
	{
		//Otorisasi menu
		//$this->fungsi->menu_auth($this->menu_print_sertifikat);
		
		//Check otorisasi
		//$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->ppic_sample_model->viewRetestingForSertifikat($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->ppic_sample_model->countRetestingForSertifikat($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('ppic_sample/ppicSample/viewListPrintSertifikatRetesting');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Options');
				
			foreach($nomor_sample as $row)
			{	
				$this->table->add_row($row->retesting_ba, anchor('ppic_sample/ppicSample/printSertifikatRetesting/'.$row->retesting_id,'Print Sertifikat',array('class' => 'update', 'target' => '_blank')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > PPIC > PRINT SERTIFIKAT RETESTING';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('ppic_sample/ppicSample/viewListPrintSertifikatRetesting');
		$this->load->view('ppic_sample/tampil_berita_acara', $data);
	}

	public function hasilAnalisa()
	{
		$this->db2 = $this->load->database('default2', TRUE);
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->ppic_sample_model->viewNomorSampleForSertifikat($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->ppic_sample_model->countNomorSampleForSertifikat($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('ppic_sample/ppicSample/hasilAnalisa');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Nomor Sample', 'Pengirim', 'Manifest', 'PPIC', 'Tanggal', 'Options');
				
			foreach($nomor_sample as $row)
			{	
				if($row->status == 'DITERIMA')
				{
					$rowCIS = $this->db2->get_where('berita_acara', array('id_ba' => $row->idba))->row();
					$rowRLIS = $this->db->get_where('berita_acara', array('id_ba' => $row->idba))->row();
					$tanggal = date("d-m-Y H:i:s", strtotime($rowRLIS->jam_input_security));
					if($row->print_counter == 0)
					{
						$this->table->add_row($row->idba, $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $row->id_sample_ppic, $tanggal, anchor('ppic_sample/ppicSample/printSertifikatDiterima/'.$row->id_sample,'<b style="color:green;">Diterima</b>',array('class' => 'update' ,'target' => '_blank')));
					} else
					{
						$this->table->add_row($row->idba, $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $row->id_sample_ppic, $tanggal, anchor('ppic_sample/ppicSample/printSertifikatDiterima/'.$row->id_sample,'<b>Diterima</b>',array('class' => 'update' ,'target' => '_blank')));
					}
				} else
				{
					$rowCIS = $this->db2->get_where('berita_acara', array('id_ba' => $row->idba))->row();
					$rowRLIS = $this->db->get_where('berita_acara', array('id_ba' => $row->idba))->row();
					$tanggal = date("d-m-Y H:i:s", strtotime($rowRLIS->jam_input_security));
					if($row->print_counter == 0)
					{
						$this->table->add_row($row->idba, $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $row->id_sample_ppic, $tanggal, anchor('ppic_sample/ppicSample/printSertifikat/'.$row->id_sample,'<b style="color:red;">Ditolak</b>',array('class' => 'update' ,'target' => '_blank')));
					} else
					{
						$this->table->add_row($row->idba, $row->id_sample, $rowCIS->nama_sup, $rowCIS->no_manifest, $row->id_sample_ppic, $tanggal, anchor('ppic_sample/ppicSample/printSertifikat/'.$row->id_sample,'<b>Ditolak</b>',array('class' => 'update' ,'target' => '_blank')));
					}
				}
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > PPIC > HASIL ANALISA';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('ppic_sample/ppicSample/hasilAnalisa');
		$this->load->view('ppic_sample/tampil_berita_acara', $data);
	}

	public function printSertifikat($id_sample)
	{
		$this->db2 = $this->load->database('default2', TRUE);
		$data['nomor_sample'] = $id_sample;
		
		$data['data_analisis'] = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row();

		$idba = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('idba');
		$data['keterangan'] = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row();
		$data['security'] = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row();

		$this->load->view('ppic_sample/tampil_print_sertifikat', $data);
	}

	public function printSertifikatRetesting($retesting_id)
	{
		$this->db2 = $this->load->database('default2', TRUE);
		$data['retesting_id'] = $retesting_id;
		
		$data['data_analisis'] = $this->db->get_where('retesting', array('retesting_id' => $retesting_id))->row();

		$idba = $this->db->get_where('retesting', array('retesting_id' => $retesting_id))->row('retesting_ba');
		$data['keterangan'] = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row();
		$data['security'] = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row();

		$this->load->view('ppic_sample/tampil_print_sertifikat_retesting', $data);
	}

	public function printSertifikatDitolak($id_sample)
	{
		$this->db2 = $this->load->database('default2', TRUE);
		$data['nomor_sample'] = $id_sample;
		
		$data['data_analisis'] = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row();

		$idba = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('idba');
		$data['keterangan'] = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row();
		$data['security'] = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row();

		$print_counter = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('print_counter');
		$print_counter = array('print_counter' => $print_counter+1);
		$this->db->where('id_sample', $id_sample);
		$this->db->update('t_qa', $print_counter);

		$this->load->view('ppic_sample/tampil_print_sertifikat_ditolak', $data);
	}

	public function printSertifikatDiterima($id_sample)
	{
		$this->db2 = $this->load->database('default2', TRUE);
		$data['nomor_sample'] = $id_sample;
		
		$data['data_analisis'] = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row();

		$idba = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('idba');
		$data['keterangan'] = $this->db2->get_where('berita_acara', array('id_ba' => $idba))->row();
		$data['security'] = $this->db->get_where('berita_acara', array('id_ba' => $idba))->row();

		$print_counter = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row('print_counter');
		$print_counter = array('print_counter' => $print_counter+1);
		$this->db->where('id_sample', $id_sample);
		$this->db->update('t_qa', $print_counter);

		$this->load->view('ppic_sample/tampil_print_sertifikat_diterima', $data);
	}

	public function listBASample()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->list_ba_sample);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->ppic_sample_model->viewNomorSampleForSertifikat($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->ppic_sample_model->countNomorSampleForSertifikat($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('ppic_sample/ppicSample/listBASample');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Nomor Sample', 'PPIC', 'LAB', 'Options', '');
				
			foreach($nomor_sample as $row)
			{	
				$this->table->add_row($row->idba, $row->id_sample, $row->id_sample_ppic, $row->id_sample_lab, anchor('ppic_sample/ppicSample/printSertifikat/'.$row->id_sample,'Print Sertifikat',array('class' => 'update', 'target' => '_blank')), anchor('ppic_sample/ppicSample/doRetestingForQA/'.$row->id_sample,'Retesting',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > PPIC > LIST BA - SAMPLE';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('ppic_sample/ppicSample/listBASample');
		$this->load->view('ppic_sample/tampil_berita_acara', $data);
	}

	function doRetestingForQA($id_sample)
	{
		$result = $this->db->get_where('t_qa', array('id_sample' => $id_sample))->row();
		$data = array('retesting_ba' => $result->idba,
					'retesting_ppic' => $result->id_sample_ppic,
					'retesting_lab' => $result->id_sample_lab,
					'addby' => $this->session->userdata('uid'),
					'adddate' => date('Y-m-d H:i:s')
				);
		$this->db->insert('retesting', $data);
		$this->session->set_flashdata('message_ok', 'Data input succesfully');
		redirect('ppic_sample/ppicSample/listBASample');
	}

	function tableWaktu()
	{
		$this->db2 = $this->load->database('default2', TRUE);
		$this->db4 = $this->load->database('default4', TRUE);
		//Otorisasi menu
		//$this->fungsi->menu_auth($this->menu_print_sertifikat);
		
		//Check otorisasi
		//$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$nomor_sample = $this->ppic_sample_model->viewNomorSampleForSertifikat($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->ppic_sample_model->countNomorSampleForSertifikat($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('ppic_sample/ppicSample/tableWaktu');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Nomor Berita Acara', 'Nomor Sample', 'Type', 'Status', 'PPIC', 'LAB', 'Pengirim', 'Jam Masuk Security', 'Jam Masuk Timbangan', 'Waktu Timbangan', 'Jam Masuk PPIC', 'Waktu Ambil Sample', 'Jam Input QA', 'Jam Selesai QA', 'Waktu Analisa', 'Jam Keluar Timbangan', 'Waktu Bongkar');
				
			foreach($nomor_sample as $row)
			{
				$rowCIS = $this->db2->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$rowRLIS = $this->db->get_where('berita_acara', array('id_ba' => $row->idba))->row();
				$rowTIS = $this->db4->get_where('tr_timbangan', array('noref' => $row->idba))->row();
				$mystring = $row->id_sample;
				$findme   = 'R';
				$pos = strpos($mystring, $findme);
				$status_resample = ($pos == TRUE ? 'Resample' : '');
				$jam_masuk_timbangan = (strtotime($rowTIS->datetime_in) != 0 ? $this->fungsi->formatWaktu24($rowTIS->datetime_in) : 'Tidak ada ref');
				$jam_keluar_timbangan = (strtotime($rowTIS->datetime_out) != 0 ? $this->fungsi->formatWaktu24($rowTIS->datetime_out) : 'Tidak ada ref');
				$waktu_masuk = $this->fungsi->selisihWaktu($rowRLIS->jam_input_security, $rowTIS->datetime_in);
				$waktu_ambil_sample = $this->fungsi->selisihWaktu($rowTIS->datetime_in, $row->adddate);
				$waktu_analisa = $this->fungsi->selisihWaktu($row->adddate, $row->waktu_approve_qa);
				$waktu_bongkar = $this->fungsi->selisihWaktu($row->waktu_approve_qa, $rowTIS->datetime_out);

				$this->table->add_row($row->idba, $row->id_sample, $rowRLIS->type, $status_resample, $row->id_sample_ppic, $row->id_sample_lab, $rowCIS->nama_sup, $this->fungsi->formatWaktu24($rowRLIS->jam_input_security), $jam_masuk_timbangan, $waktu_masuk, $this->fungsi->formatWaktu24($row->adddate), $waktu_ambil_sample, $this->fungsi->formatWaktu24($row->waktu_periksa_qa), $this->fungsi->formatWaktu24($row->waktu_approve_qa), $waktu_analisa, $jam_keluar_timbangan, $waktu_bongkar);
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > PPIC > TABLE WAKTU';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('ppic_sample/ppicSample/tableWaktu');
		$this->load->view('ppic_sample/table_waktu', $data);
	}

	function tableWaktuExcel()
	{
		$awal = $this->input->post('awal');
		$akhir = $this->input->post('akhir');
		$data['all_data'] = $this->ppic_sample_model->viewNomorSampleWithRange($awal, $akhir)->result();
		$data['namafile'] = 'table_waktu_'.$awal.'_'.$akhir;
		$this->load->view('ppic_sample/table_waktu_excel', $data);
	}
}