<?php 

/*

Fungsi : Controller untuk create BA

*/



if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Reflog_ba extends CI_Controller {

	

/*-------------Inisialisasi variabel--------------*/ 

	

	//Menu ID utk keperluan otorisasi

	var $menu_list_ba  = 176;
	var $menu_create_ba = 173;
	var $list_proforma_invoice = 208;

	

/*-------------Inisialisasi variabel--------------*/ 	



/*------------Fungsi local------------------------*/	

	function __construct()

	{

		parent::__construct();
	$this->load->model('reflog/reflog_model', '', TRUE);

		$this->fungsi->check_login();
	}
	public function index()
	{	
		$this->reflog_add_ba();
	}

	function listProformaInvoice()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->list_proforma_invoice);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->reflog_model->viewSTBA($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->reflog_model->countSTBA($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('reflog/reflog_ba/listProformaInvoice');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('STBA', 'Supplier', 'Tanggal', 'Options');
				
			foreach($berita_acara as $row)
			{	
				$this->table->add_row($row->idstba, $row->suppname, date('d M Y', strtotime($row->adddate)), anchor('reflog/reflog_ba/detailProforma/'.$row->id,'Detail',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > GEO COLLECT > LIST PROFORMA INVOICE';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('reflog/reflog_ba/listProformaInvoice');
		$data['master_cabang'] = $this->db->get('m_cab')->result();
		$this->load->view('reflog/list_proforma_invoice', $data);
	}

	function detailProforma($id)
	{
		$stba = $this->db->get_where('t_stba', array('id' => $id));
		$data['pembayaran'] = $this->db->query('select * from inv_stba where idstba = "'.$stba->row('idstba').'"')->row();
		$data['supplier'] = $this->db->get_where('m_supp', array('idsupp' => $stba->row('idsupp')))->row();
		$data['stba'] = $stba->row();
		$data['detail'] = $this->db->get_where('t_stba_detail', array('idstba' => $stba->row('idstba')));
		$data['kacab'] = $this->db->query('select * from t_stba join master_user on t_stba.idcab = master_user.idcab join m_cab on t_stba.idcab = m_cab.idcab where idstba = "'.$stba->row('idstba').'" and roleid = "17"');
		$data['norek'] = $this->db->query('select * from va_supplier join m_supp on va_supplier.idsupp = m_supp.idsupp join rekening_va on va_supplier.idva = rekening_va.id');
		$this->load->view('reflog/detail_proforma', $data);
	}
	
	function reflog_add_ba()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->reflog_model->viewBeritaAcaraBaru($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->reflog_model->countBeritaAcaraBaru($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('reflog/reflog_ba/reflog_add_ba');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Berita Acara', 'Nomor Polisi', 'Tipe', 'Volume', 'Tanggal', 'Jam Masuk', 'Options');
				
			foreach($berita_acara as $row)
			{	
				$this->table->add_row($row->id_ba, $row->no_pol, $row->type, number_format($row->vol_security).' L', date('d M Y', strtotime($row->jam_input_security)), date('H:i', strtotime($row->jam_input_security)), anchor('reflog/reflog_ba/reflog_add_ba_form/'.$row->id,'Entry Data',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > GEO COLLECT > CREATE BA FROM SECURITY';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('reflog/reflog_ba/reflog_add_ba');
		$this->load->view('reflog/reflog_list_ba', $data);
	}


	function reflog_add_ba_form($id)
	{	
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_create_ba);
		$data['menu_path'] = 'CIBITUNG > GEO COLLECT > CREATE BA FROM SECURITY';
		$data['form_action']= site_url('reflog/reflog_ba/add_ba_proc');
		$data['id_ba'] = $this->db->get_where('berita_acara', array('id' => $id))->row('id_ba');
		$this->load->view('reflog/reflog_add_ba_form', $data);
	}

	function popup_sj_ba()
	{
		$this->load->view('reflog/popup_sj_ba');
	}

	function popup_supplier_pusat()
	{
		$this->load->view('reflog/popup_supplier_pusat');
	}

	function popup_supplier_pusat_ppn()
	{
		$this->load->view('reflog/popup_supplier_pusat_ppn');
	}

	/* Cabang add ba process */
	function add_ba_proc()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$no_pol = $this->input->post('no_pol');
		$id_vendor = $this->input->post('id_vendor');
		$nama_vendor = $this->input->post('nama_vendor');
		$sewa_trans = $this->input->post('sewa_trans');
		$wgi_trans = $this->input->post('wgi_trans');
		$no_pol2 = $this->input->post('no_pol2');
		$no_sj = $this->input->post('no_sj');
		$no_manifest = $this->input->post('manifest');
		$note1_coll = $this->input->post('note1_coll');
		$pengirim = $this->input->post('pengirim');
		$jam_datang_coll = $this->input->post('jam_datang_coll');
		$jam_diserahkan_coll = $this->input->post('jam_diserahkan_coll');
		$vol_coll = $this->input->post('vol_coll');
		$harga = $this->input->post('harga');
		$iso = $this->input->post('iso');
		$type = $this->input->post('tipe');
		$trans = $this->input->post('trans');
		$matdoc = $this->input->post('matdoc');
		$transporter = $this->input->post('transporter');
		$harga_sup = $this->input->post('harga_sup');
		$trans_sup = $this->input->post('trans_sup');
		$sj_supp = $this->input->post('sj_supp');
		$id_supp = $this->input->post('supp');
		$po = $this->input->post('po');
		$pp = $this->input->post('pp');
		$ppn = $this->input->post('ppn');
		$harga_tot = $this->input->post('harga_tot');
		$id_ba = $this->input->post('id_ba');

		if($this->input->post('pengirim') == 'CABANG')
		{
			$dataRLIS = array('no_pol' => $no_pol,
						'id_vendor' => $id_vendor,
						'nama_vendor' => $nama_vendor,
						'sewa_trans' => $sewa_trans,
						'wgi_trans' => $wgi_trans,
						'no_pol2' => $no_pol2,
						'no_sj' => $no_sj,
						'no_manifest' => $no_manifest,
						'note_coll' => $note_coll,
						'pengirim' => $pengirim,
						'jam_datang_coll' => $jam_datang_coll,
						'jam_diserahkan_coll' => $jam_diserahkan_coll,
						'vol_coll' => $vol_coll,
						'harga' => $harga,
						'no_iso' => $iso,
						'type' => $type,
						'trans' => $trans,
						'sap_mblnr' => $matdoc,
						'transporter' => $transporter,
						'status_geocoll' => '1'
					);
			$this->db->where('id_ba', $id_ba);
			$this->db->update('berita_acara', $dataRLIS);

			$deliveryNote = array('status' => '1');
			$this->db->where('dnnumb', $no_sj);
			$this->db->update('t_dn', $deliveryNote);			

			$dataCIS = array('no_pol' => $no_pol,
						'id_vendor' => $id_vendor,
						'nama_vendor' => $nama_vendor,
						'sewa_trans' => $sewa_trans,
						'wgi_trans' => $wgi_trans,
						'no_pol2' => $no_pol2,
						'no_sj' => $no_sj,
						'no_manifest' => $no_manifest,
						'note1_coll' => $note_coll,
						'pengirim' => $pengirim,
						'jam_datang_coll' => $jam_datang_coll,
						'jam_diserahkan_coll' => $jam_diserahkan_coll,
						'vol_coll' => $vol_coll,
						'harga' => $harga,
						'iso' => $iso,
						'type' => $type,
						'trans' => $trans,
						'mblnr' => $matdoc,
						'status_col' => '1',
						'transporter' => $transporter
					);
			$this->db2->where('id_ba', $id_ba);
			$this->db2->update('berita_acara', $dataCIS);

			$suratJalan = array('status' => '1');
			$this->db2->where('no_sj', $no_sj);
			$this->db2->update('sj', $suratJalan);
		}

		elseif($this->input->post('pengirim') == 'SUPPLIER')
		{
			$dataRLIS = array('no_pol' => $no_pol,
						'id_vendor' => $id_vendor,
						'nama_vendor' => $nama_vendor,
						'harga_sup' => $harga_sup,
						'trans_sup' => $trans_sup,
						'no_sj' => $sj_supp,
						'no_manifest' => $no_manifest,
						'note_coll' => $note_coll,
						'pengirim' => $pengirim,
						'jam_datang_coll' => $jam_datang_coll,
						'jam_diserahkan_coll' => $jam_diserahkan_coll,
						'vol_coll' => $vol_coll,
						'harga' => $harga,
						'id_supp' => $id_supp,
						'no_iso' => $iso,
						'type' => $type,
						'trans' => $trans,
						'status_geocoll' => '1',
						'po' => $po,
						'pp' => $pp,
						'transporter' => $transporter
					);
			$this->db->where('id_ba', $id_ba);
			$this->db->update('berita_acara', $dataRLIS);

			$dataCIS = array('no_pol' => $no_pol,
						'id_vendor' => $id_vendor,
						'nama_vendor' => $nama_vendor,
						'harga_sup' => $harga_sup,
						'trans_sup' => $trans_sup,
						'no_sj' => $sj_supp,
						'no_manifest' => $no_manifest,
						'note1_coll' => $note_coll,
						'pengirim' => $pengirim,
						'jam_datang_coll' => $jam_datang_coll,
						'jam_diserahkan_coll' => $jam_diserahkan_coll,
						'vol_coll' => $vol_coll,
						'harga' => $harga,
						'id_supp' => $id_supp,
						'iso' => $iso,
						'type' => $type,
						'trans' => $trans,
						'status_col' => '1',
						'po' => $po,
						'pp' => $pp,
						'transporter' => $transporter
					);
			$this->db2->where('id_ba', $id_ba);
			$this->db2->update('berita_acara', $dataCIS);
		}

		elseif($this->input->post('pengirim') == 'SUPPLIERPJK')
		{
			$dataRLIS = array('no_pol' => $no_pol,
						'id_vendor' => $id_vendor,
						'nama_vendor' => $nama_vendor,
						'harga_sup' => $harga_sup,
						'trans_sup' => $trans_sup,
						'no_sj' => $sj_supp,
						'no_manifest' => $no_manifest,
						'note_coll' => $note_coll,
						'pengirim' => $pengirim,
						'jam_datang_coll' => $jam_datang_coll,
						'jam_diserahkan_coll' => $jam_diserahkan_coll,
						'vol_coll' => $vol_coll,
						'harga' => $harga,
						'id_supp' => $id_supp,
						'no_iso' => $iso,
						'type' => $type,
						'trans' => $trans,
						'status_geocoll' => '1',
						'ppn' => $ppn,
						'harga_tot' => $harga_tot,
						'po' => $po,
						'pp' => $pp,
						'transporter' => $transporter
					);
			$this->db->where('id_ba', $id_ba);
			$this->db->update('berita_acara', $dataRLIS);

			$dataCIS = array('no_pol' => $no_pol,
						'id_vendor' => $id_vendor,
						'nama_vendor' => $nama_vendor,
						'harga_sup' => $harga_sup,
						'trans_sup' => $trans_sup,
						'no_sj' => $sj_supp,
						'no_manifest' => $no_manifest,
						'note1_coll' => $note_coll,
						'pengirim' => $pengirim,
						'jam_datang_coll' => $jam_datang_coll,
						'jam_diserahkan_coll' => $jam_diserahkan_coll,
						'vol_coll' => $vol_coll,
						'harga' => $harga,
						'id_supp' => $id_supp,
						'iso' => $iso,
						'type' => $type,
						'trans' => $trans,
						'status_col' => '1',
						'ppn' => $ppn,
						'harga_tot' => $harga_tot,
						'po' => $po,
						'pp' => $pp,
						'transporter' => $transporter
					);
			$this->db2->where('id_ba', $id_ba);
			$this->db2->update('berita_acara', $dataCIS);
		}
		$this->session->set_flashdata('message_ok', 'Data saved, BA Number :'.$id_ba);
		redirect('reflog/reflog_ba');
	}

	/* Display list DN */

	function reflog_list_ba()

	{	
	//Check otorisasi
	$this->fungsi->trans_auth($this->session->userdata('view'));
	
	//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_ba);

		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset =    $this->uri->segment($uri_segment);
		
		$dn = $this->reflog_model->get_ba_paging($this->session->userdata('idcab'),$this->config->item('paging_limit'), $offset)->result();
		$num_rows = $this->reflog_model->count_all_ba($this->session->userdata('idcab'));
		
		$config['base_url'] = site_url('reflog/reflog_ba/reflog_list_ba/');
		
		if ($num_rows > 0) // Jika query menghasilkan data
				{
					// Membuat pagination			
					$config['total_rows'] = $num_rows;
					$config['per_page'] = $this->config->item('paging_limit');
					$config['uri_segment'] = $uri_segment;
					$this->pagination->initialize($config);
					$data['pagination'] = $this->pagination->create_links();
					$i = 0 + $offset;		

					$tmpl = array( 'table_open'    => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
								  'row_alt_start'  => '<tr class="zebra">',
								  'row_alt_end'    => '</tr>'
								  );
					$this->table->set_template($tmpl);

					// Set heading untuk tabel
					$this->table->set_empty("&nbsp;");
					$this->table->set_heading('No. BA', 'Pengirim', 'Manifest', 'Volume', 'Driver', 'Options');

					$atts = array(
              'width'      => '100',
              'height'     => '100',
              'scrollbars' => 'yes',
              'status'     => 'yes',
              'resizable'  => 'yes',
              'screenx'    => '0',
              'screeny'    => '0'
            );

				

					foreach ($ba  as $bas)
					{	
	$this->table->add_row($bas->dnnumb, $bas->cabname, $bas->mnfst, $bas->vol, $bas->driver,  anchor_popup('branch/cabang_dn/print_dn_popup/'.$dns->iddn.'/'.$bas->idcab.'/'.$bas->year,'Print',array('class'=> 'print',$atts),$atts).' '.anchor('branch/cabang_dn/cancel_dn/'.$bas->iddn.'/'.$bas->idcab.'/'.$bas->year,'Cancel',array('class'=> 'delete',$atts),$atts));


					}
					$data['table'] = $this->table->generate();
				    }
			else
				{
					$data['message'] = 'No data';
				}		

		$data['menu_path'] = 'CIBITUNG > REFLOG > LIST BERITA ACARA';
		$this->load->view('reflog/reflog_ba_list', $data);
	}
}