<?php 

/*

Fungsi : Controller untuk create BA

*/



if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Security_ba extends CI_Controller {

	

/*-------------Inisialisasi variabel--------------*/ 

	

	//Menu ID utk keperluan otorisasi

	var $menu_list_ba  = 189;

	var $menu_create_ba = 172;

	

/*-------------Inisialisasi variabel--------------*/ 	



/*------------Fungsi local------------------------*/	

	function __construct()
	{

		parent::__construct();
		$this->load->model('security/security_model', '', TRUE);
		$this->fungsi->check_login();
	}

	public function index()
	{	
		$this->security_add_ba();
	}
	


	function security_add_ba()
	{	
		$count = array();
		$count = $this->fungsi->get_no($this->session->userdata('idcab'), 'BA');
		$nobaform = $count[0];
		$noba = $count[1];

		$this->fungsi->menu_auth($this->menu_create_ba);
		$data['menu_path'] = 'CIBITUNG > SECURITY > BA > CREATE BA';
		$data['form_action']= site_url('security/security_ba/add_ba_proc');
		$data['no_ba'] = $nobaform;
		$data['pengirim_security'] = $this->db->get('pengirim_security')->result();
		$this->load->view('security/security_ba_form', $data);
	}

	function add_ba_proc()
	{
		$this->fungsi->trans_auth($this->session->userdata('add'));
		$count = array();
		$count = $this->fungsi->get_no_count($this->session->userdata('idcab'), 'BA');
		$nobaform = $count[0];
		$noba = $count[1];

		$data = array(
						'id_ba' => $nobaform,
						'type' => $this->input->post('type'),
						'no_pol' => $this->input->post('vnumb'),
						'vol_security' => $this->input->post('vol_security'),
						'no_manifest' => $this->input->post('no_manifest'),
						'pengirim' => $this->input->post('jenis_pengirim'),
						'nama_sup' => $this->input->post('nama_sup'),
						'no_sj' => $this->input->post('no_sj'),
						'driver_security' => $this->input->post('driver'),
						'jam_input_security' => date('Y-m-d H:i:s'),
						'note_security' => $this->input->post('inf')
					 );

		$dataCIS = array(
						'id_ba' => $nobaform,
						'tgl_input' => date('Y-m-d'),
						'no_sj' => $this->input->post('no_sj'),
						'pengirim' => $this->input->post('jenis_pengirim'),
						'no_manifest' => $this->input->post('no_manifest'),
						'no_pol' => $this->input->post('vnumb'),
						'jam_datang_coll' => date('H:i'),
						'vol_coll' => $this->input->post('vol_security'),
						'note1_coll' => $this->input->post('inf'),
						'nama_sup' => $this->input->post('nama_sup'),
						'type' => $this->input->post('type'),
						'no_iso' => $this->input->post('no_iso'),
						'transporter' => $this->input->post('trans'),
						'status_sec' => '1',
					 );

		$this->security_model->addBASecurity($data);
		$this->security_model->addBASecurityToCISBA($dataCIS);
		$this->session->set_flashdata('message_ok', 'Data saved, BA Number :'.$nobaform);
		redirect('security/security_ba');
	}

	function edit_ba_proc()
	{
		$this->db2 = $this->load->database('default2', TRUE);

		$data = array('type' => $this->input->post('type'),
					'no_pol' => $this->input->post('vnumb'),
					'vol_security' => $this->input->post('vol_security'),
					'pengirim' => $this->input->post('jenis_pengirim'),
					'nama_sup' => $this->input->post('nama_sup'),
					'no_manifest' => $this->input->post('no_manifest'),
					'no_sj' => $this->input->post('no_sj'),
					'note_security' => $this->input->post('inf')
				);
		$this->db->where('id', $this->input->post('id'));
		$this->db->update('berita_acara', $data);

		$ambil_mulai = date("Y-m-d H:i:s", strtotime($this->input->post('ambil_mulai')));
		$ambil_selesai = date("Y-m-d H:i:s", strtotime($this->input->post('ambil_selesai')));
		$qc_terima = date("Y-m-d H:i:s", strtotime($this->input->post('qc_terima')));

		$dataQA = array('ambil_mulai' => $ambil_mulai,
					'ambil_selesai' => $ambil_selesai,
					'qc_terima' => $qc_terima
				);
		$this->db->where('idba', $this->input->post('id_ba'));
		$this->db->update('t_qa', $dataQA);

		$dataCIS = array('no_sj' => $this->input->post('no_sj'),
						'pengirim' => $this->input->post('jenis_pengirim'),
						'no_manifest' => $this->input->post('no_manifest'),
						'no_pol' => $this->input->post('vnumb'),
						'vol_coll' => $this->input->post('vol_security'),
						'note1_coll' => $this->input->post('inf'),
						'nama_sup' => $this->input->post('nama_sup'),
						'type' => $this->input->post('type'),
						'no_iso' => $this->input->post('no_iso'),
						'transporter' => $this->input->post('trans')
					);
		$this->db2->where('id_ba', $this->input->post('id_ba'));
		$this->db2->update('berita_acara', $dataCIS);

		$this->session->set_flashdata('message_ok', 'Data saved');
		redirect('security/security_ba/edit_form_ba/'.$this->input->post('id'));
	}

	function edit_form_ba($id)
	{
		$this->db2 = $this->load->database('default2', TRUE);
		$data['data'] = $this->db->get_where('berita_acara', array('id' => $id))->row();
		$data['pengirim_security'] = $this->db->get('pengirim_security')->result();
		$id_ba = $data['data']->id_ba;
		$data['dataCIS'] = $this->db2->get_where('berita_acara', array('id_ba' => $id_ba))->row();
		$data['dataQA'] = $this->db->get_where('t_qa', array('idba' => $id_ba))->row();
		$data['form_action'] = site_url('security/security_ba/edit_ba_proc');
		$this->load->view('security/security_ba_form_edit', $data);
	}

	function list_ba()
	{
		//Otorisasi menu
		$this->fungsi->menu_auth($this->menu_list_ba);
		
		//Check otorisasi
		$this->fungsi->trans_auth($this->session->userdata('view'));
		
		if(isset($_POST['submit']))
        {
            $data['search'] = $this->input->post('txt_search');
	        //set session user data untuk pencarian, untuk paging pencarian
	        $this->session->set_userdata('sess_search', $data['search']);
        } else 
        {
            $data['search']  =  $this->session->userdata('sess_search');
        }
			
		/* Setting Parameter Untuk Paging */
		$uri_segment = 4;
		$offset = $this->uri->segment($uri_segment);
		$berita_acara = $this->security_model->viewBeritaAcara($this->config->item('paging_limit'), $offset, $data['search'])->result();
		$num_rows = $this->security_model->countBeritaAcara($data['search']);
		$data['total'] = $num_rows;
		$config['base_url'] = site_url('security/security_ba/list_ba');
		if($num_rows > 0) // Jika query menghasilkan data
		{
			// Membuat pagination			
			$config['total_rows'] = $num_rows;
			$config['per_page'] = $this->config->item('paging_limit');
			$config['uri_segment'] = $uri_segment;
			$this->pagination->initialize($config);
			$data['pagination'] = $this->pagination->create_links();
			$i = 0 + $offset;
		
			$tmpl = array('table_open' => '<table border="0" cellpadding="1" cellspacing="1" id="list">',
						  'row_alt_start' => '<tr class="zebra">',
						  'row_alt_end' => '</tr>'
						 );
			$this->table->set_template($tmpl);
		
			// Set heading untuk tabel
			$this->table->set_empty("&nbsp;");
			$this->table->set_heading('Berita Acara', 'Tipe', 'Nomor Polisi', 'Volume', 'Jenis Pengirim', 'Nama Pengirim', 'Tanggal', 'Jam Masuk', 'Option');
				
			foreach($berita_acara as $row)
			{	
				$this->table->add_row($row->id_ba, $row->type, $row->no_pol, number_format($row->vol_security).' L', $row->pengirim, $row->nama_sup, date('d M Y', strtotime($row->jam_input_security)), date('H:i', strtotime($row->jam_input_security)), anchor('security/security_ba/edit_form_ba/'.$row->id,'Edit',array('class' => 'update')));
			}
			$data['table'] = $this->table->generate();
		} else
		{
			$data['message'] = 'No data to display';
		}		
		$data['menu_path'] = 'CIBITUNG > SECURITY > LIST BA SECURITY';
		//$data['link'] = array('link_back' => anchor('admin/admin_role','Back', array('class' => 'back')));	
		$data['form_action']= site_url('security/security_ba/list_ba');
		$this->load->view('security/security_list_ba', $data);
	}	

}