<?php 
/*
Fungsi : Controller untuk user forget password
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_forget_pass extends CI_Controller {
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('admin/admin_model', '', TRUE);
	}
	
	public function index()
	{	
		$this->user_forget_pwd_form();
	}
	
	/* Display forget password form */
	function user_forget_pwd_form()
	{	
		$data['cap']= $this->fungsi->setChaptcha();
		$data['menu_path'] = 'FORGET PASSWORD';
		$data['form_action']= site_url('user/user_forget_pass/send_pass');
		$data['link'] = array('link_back' => anchor('user/user_login','Back', array('class' => 'back')));
		$this->load->view('user/user_forget_pass_form', $data);
		
	}
	
	/* Send password to email */
	function send_pass()
	{
		/* Set validasi */
		$config = array(
						   array(
									 'field'   => 'txt_uid',
									 'label'   => 'User ID',
									 'rules'   => 'required'
									),
									
							 array(	 
								 'field'   => 'txt_cap',
								 'label'   => 'Code',
								 'rules'   => 'required|callback_valid_captcha' 
							  	)
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
						
				$query_user = $this->admin_model->get_user_uid($this->input->post('txt_uid'));
				if($query_user->num_rows() > 0 ) 
					{	
						
						$query_user = $this->admin_model->get_user_uid($this->input->post('txt_uid'));
						foreach ($query_user->result() as $row_user);
						
						$msg='Your password is <b>'.$this->fungsi->decrypt1($row_user->pass).'</b>';
						$msg.='<br><br><br><br>';
						
						$msg.='Warm regards, System administrator :)';
						
						$this->fungsi->send_email($row_user->email, 'Your password', $msg);
						
						$this->session->set_flashdata('message_ok', 'Password already send to your email');
						redirect('user/user_forget_pass');
						
					}
					else
					{
						$this->session->set_flashdata('message_err', 'User ID not register');
						redirect('user/user_forget_pass');
						
						
					}
			}
		else
			{
				$this->user_forget_pwd_form();
			}
	}
	
	
	/* Fungsi Validasi Captcha */
function valid_captcha($str)
{
    $expiration = time()-3600;
    $this->db->query("DELETE FROM captcha WHERE captcha_time < ".$expiration);
    $sql = "SELECT COUNT(*) AS count FROM captcha WHERE word = ? 
                AND ip_address = ? AND captcha_time > ?";
    $binds = array($str, $this->input->ip_address(), $expiration);
    $query = $this->db->query($sql, $binds);
    $row = $query->row();
    
    if ($row->count == 0) 
    {
		$this->form_validation->set_message('valid_captcha', "Code that you entered is wrong, please try again");
        return FALSE;
    }
	else
	{
        return TRUE;
    }          
 }
	
	
	
	
}
?>