<?php 
/*
Fungsi : Controller untuk user login
*/

if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_login extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -  
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in 
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct()
	{
		parent::__construct();
		$this->load->model('user/user_model', '', TRUE);
		$this->load->model('admin/admin_model', '', TRUE);
	}
	
	public function index()
	{	
		$this->user_login_form();
	}
	
	/* Display login form */
	function user_login_form()
	{
		$data['menu_path'] = 'PLEASE LOGIN';
		$data['form_action']= site_url('user/user_login/do_login');
		$this->load->view('user/user_login_form', $data);
		
	}
	
	/* Cek login */
	function do_login()
	{
		/* Server SAP nya lagi error blokir dulu yang login */
		/*$this->session->set_flashdata('message_err', 'DUE TO SYSTEM ERROR, THIS APP TEMPORARY DISABLED.');
		redirect('user/user_login/');	*/
		/* Server SAP nya lagi error blokir dulu yang login */
		
		/* Set validasi */
		$config = array(
               array(
                     'field'   => 'txt_uid',
                     'label'   => 'User ID',
                     'rules'   => 'required'
                  ),
               array(
                     'field'   => 'txt_pass',
                     'label'   => 'Password',
                     'rules'   => 'required'
                  )
            );
		$this->form_validation->set_rules($config); 
		
		if ($this->form_validation->run() == TRUE)
			{
				$query_user_check = $this->user_model->check_login($this->input->post('txt_uid'));	
				//Jika UID ditemukan maka check password
				if ($query_user_check->num_rows() > 0)
				{	
					$data_user = $query_user_check->result();
					foreach($data_user  as $row_user);
					
						if( $this->fungsi->decrypt1($row_user->pass) == $this->input->post('txt_pass') )
						{
							//Check apakah user di lock ?
							if( $row_user->lock == 1 )
							{
								//Check apakah user di lock ?
								$this->session->set_flashdata('message_err', 'Your account is locked, please contact admin');
								redirect('user/user_login/');	
							}
							else
							{
								//Masukan informasi cabang
								$query_cab = $this->admin_model->get_cab_detail($row_user->idcab)->result();	
								foreach($query_cab  as $row_cab);
								
								//Masukkan informasi user kedalam session
								$ses_data_user = array('uid' => $row_user->uid, 'login' => TRUE, 'dispname'=>$row_user->dispname,'idcab' => $row_user->idcab,'namacab' => $row_cab->cabname,'lifnr' => $row_cab->lifnr,'max_stor' => $row_cab->max_stor,'lgort' => $row_cab->lgort,'pic' => $row_cab->pic,'cabshorttxt' => $row_cab->cabshorttxt,'pcbankglacc' => $row_cab->pcbankglacc,'costcenter' => $row_cab->costctr);
								
								$this->session->set_userdata($ses_data_user);
								
								//Masukkan informasi role kedalam session
								$query_role = $this->admin_model->get_role_roleid($row_user->roleid)->result();	
								foreach($query_role  as $row_role);
								
							/*	
								$total_role_cust = $this->admin_model->count_rows_rolecust($row_role->roleid);	
								$total_role_div = $this->admin_model->count_rows_rolediv($row_role->roleid);	
								*/
								$ses_data_role = array('roleid' => $row_role->roleid ,'rolename'=>$row_role->rolename
								, 'view'=>$row_role->view, 'add'=>$row_role->add, 'edit'=>$row_role->edit
								, 'delete'=>$row_role->delete, 'app'=>$row_role->app, 'cancel'=>$row_role->cancel);
								
								$this->session->set_userdata($ses_data_role);
								
								//Jika login bukan sebagai check apakah period sudah di open atau belum ?
								/*if($row_user->idcab != 1)
								{
									
									if($this->fungsi_sap->fm_check_open_period(date('n'), date('Y'))==1)
									{
										$this->session->set_flashdata('message_err', 'CANNOT LOGIN, PERIODE NOT OPEN! Please Call ACCOUNTING!!!!!!');
										redirect('user/user_login/');	
										
									}
								}*/
								/*
								//Masukkan informasi role menu kedalam session
								$query_rolemenu = $this->admin_model->get_rolemenu_roleid($row_user->roleid)->result();	
								foreach($query_rolemenu  as $row_rolemenu)
								{
									$ses_data_rolemenu['rolemenu'][] = array('mid'=>$row_rolemenu->mid);
								}
								
								$this->session->set_userdata($ses_data_rolemenu);
								
								$this->load->view('frame/frame_main');	
								
								foreach($this->session->userdata('im') as $row_arr)
								{
									if($row_arr["mid"]==10000)
									{
										echo 'Found';
									}
									else
									{
										echo 'Not Found';
									}
									//echo $row_arr["roleid"];
									//echo $row_arr["mid"];
									//echo '<br>';
								}
								//print_r($ses_data_rolemenu);
								//print_r($this->session->all_userdata());
							*/	
							$this->load->view('frame/frame_main');	
							}
						}
						else
						{
							$this->session->set_flashdata('message_err', 'User ID or password is wrong, please try again');
							redirect('user/user_login/');
						}
					
				}
				else
				{	
					$this->session->set_flashdata('message_err', 'User ID or password is wrong, please try again');
					redirect('user/user_login/');
				}
			}
		else
			{
				$this->user_login_form();
			}
	}
	
	/* Fungsi logout */
	function logout()
	{	
		$this->session->sess_destroy();
		$this->session->set_flashdata('message_err', 'Please login to enter system');
		redirect('user/user_login/');
		
	}
}
?>