<?php 
/*
Fungsi : Semua fungsi-fungsi SAP ditaruh disini
*/
Class Fungsi_sap
{
function Fungsi_sap()
	{
		/* Load Library CI */
		$this->CI =& get_instance();
		$this->CI->load->library(array('session','form_validation'));
		$this->CI->load->model('user/user_model', '', TRUE);
		$this->CI->load->helper(array('captcha'));
		
	}


 /*-----------------------------------SAP Function-------------------------------*/	
 
 
 //Koneksi ke SAP
 function sap_connection_string()
 {
		$connection  = array(  
							"ASHOST"=>"192.168.100.13"        // application server 
							,"SYSNR"=>"00"         // system number
							,"CLIENT"=>"500"           // client     
							,"USER"=>"imc_dpermana"       // user
							,"PASSWD"=>"mitra10"     // password
							);	
		return 	$connection;
 }
 //Get Vendor
 function fm_search_vendor($opt)
 {
 			$sap = new SAPConnection();
			$sap->Connect($this->sap_connection_string());
			if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open();
			if ($sap->GetStatus() != SAPRFC_OK ) {
		   	$sap->PrintStatus();
		   	exit;
			}

    $fce = &$sap->NewFunction ("YFM_DISPVEN_CIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	
	if ( $opt == 'name1' )
	{
	$fce->GV_NAME1 = '*'.strtoupper($_GET['term']).'*';
	$fce->GV_LIFNR = '';
	}
	else
	{
	$fce->GV_NAME1 = '';
	$fce->GV_LIFNR = '*'.strtoupper($_GET['term']).'*';
	}
	
	
    $fce->Call();
	
	$return_arr = array();
	
	 if ($fce->GetStatus() == SAPRFC_OK) {
		 
		 $fce->GI_HEADER_LFA1->Reset();
		 
		  while ( $fce->GI_HEADER_LFA1->Next() )
		{
			 
			 if ($opt == 'name1')
			{
			 $row_array['label'] = $fce->GI_HEADER_LFA1->row["NAME1"];
			 $row_array['value'] = $fce->GI_HEADER_LFA1->row["NAME1"];
			 $row_array['idsupp'] = $this->fm_delete_zero_value($fce->GI_HEADER_LFA1->row["LIFNR"]);
			}
			else
			{
			 $row_array['label'] = $this->fm_delete_zero_value($fce->GI_HEADER_LFA1->row["LIFNR"]);
			 $row_array['value'] = $this->fm_delete_zero_value($fce->GI_HEADER_LFA1->row["LIFNR"]);
			 $row_array['nama_supp'] = $fce->GI_HEADER_LFA1->row["NAME1"];
			}
	
			 array_push($return_arr,$row_array);
			 
		}
		
		echo json_encode($return_arr);
		 	 
	 }
	 
	 else
	 
	 {
		 
		 
     $fce->PrintStatus();
	 $sap->Close();
		 
		 
	 }
 }
 //Delete zero leading for customer/vendor/material and other number
 function fm_delete_zero_value($string){
	$lv_found = 0;
	$lv_result = '';
	$string = trim($string);
	for ($i = 0; $i <= strlen($string); $i++) {
		if(isset($string[$i]))
		{
				if ( ($lv_found == 0) and ($string[$i] == "0") ){
					
				}else{
					$lv_found = 1;
					$lv_result = $lv_result.$string[$i];
				}
		}
	}
	return $lv_result;
}

//Convert vendor number to sap number format
function fm_convert_vendor($vendor)
{
	if (is_numeric($vendor))
	{
		return str_pad($vendor, 10, "0", STR_PAD_LEFT);
	}
	else
	{
		return $vendor;
	}

}

//SAP format number
function fm_sap_format_number($string){
	return number_format($string,3,',', '.');
}

//Convert to SAP date format
function fm_sap_yyyymmdd($date)
{	
return date("Ymd",   strtotime($date));	
}


//Convert to date to month
function fm_sap_month($month)
{	
return date("m",   strtotime($month));	
}

//Convert SAP number to PHP number format
function fm_sap_format_number2($string){
	$lv_found = 0;
	$lv_result = '';
	for ($i = 0; $i <= strlen($string); $i++) {
		if ( ($lv_found == 0) and ($string[$i] != ".") ){
			$lv_result = $lv_result.$string[$i];
		}else{
			$lv_found = 1;
			//$lv_result = $lv_result.$string[$i];
		}
	}
	return $lv_result;
}

//Convert SAP date format to PHP date format
function fm_format_ddmmyy($date)
{	
return date("d.m.Y",   strtotime($date));	
}


//SAP format number
function fm_sap_format_number3($string){
	return number_format($string);
}

//Create PR
function fm_create_pr($preqname, $quantity, $deliv_date, $c_amt_bapi)
{			
			$this->CI->session->unset_userdata('sap_pr_num');
			
			$sap = new SAPConnection();
			$sap->Connect($this->sap_connection_string());
			if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open();
			if ($sap->GetStatus() != SAPRFC_OK ) {
		   	$sap->PrintStatus();
		   	exit;
			}
			
			$fce = &$sap->NewFunction ("BAPI_REQUISITION_CREATE");
    		if ($fce == false ) {
       		$sap->PrintStatus();
       		exit;
    		}
			
			$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    		if ($fce2 == false ) {
       		$sap->PrintStatus();
       		exit;
    		}
	
			$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    		if ($fce3 == false ) {
       		$sap->PrintStatus();
      		exit;
    		}
				
		//PR ITEM
		$fce->REQUISITION_ITEMS->row["PREQ_ITEM"] = 1;
		$fce->REQUISITION_ITEMS->row["PREQ_NAME"] = $preqname;
		$fce->REQUISITION_ITEMS->row["DOC_TYPE"]  = '50';
	    //$fce->REQUISITION_ITEMS->row["SHORT_TEXT"] = '';
		$fce->REQUISITION_ITEMS->row["MATERIAL"] = 'R101';
		$fce->REQUISITION_ITEMS->row["PLANT"] = '1000';
		//$fce->REQUISITION_ITEMS->row["MAT_GRP"] = $_POST['txt_matkl'];
		$fce->REQUISITION_ITEMS->row["QUANTITY"] = $quantity;
		//$fce->REQUISITION_ITEMS->row["UNIT"] = $_POST['txt_meins'];
	    $fce->REQUISITION_ITEMS->row["DELIV_DATE"] = $this->fm_sap_yyyymmdd($deliv_date);
		$fce->REQUISITION_ITEMS->row["PRICE_UNIT"] = 1;
		$fce->REQUISITION_ITEMS->row["C_AMT_BAPI"] = $c_amt_bapi;
		//$fce->REQUISITION_ITEMS->row["ACCTASSCAT"] = $_POST['txt_knttp'];
		$fce->REQUISITION_ITEMS->row["CURRENCY"] = 'IDR';
		$fce->REQUISITION_ITEMS->row["GR_IND"] = 'X';
		//$fce->REQUISITION_ITEMS->row["GR_NON_VAL"] = 'X';
		$fce->REQUISITION_ITEMS->row["IR_IND"] = 'X';
	    $fce->REQUISITION_ITEMS->row["PUR_GROUP"] = '001';
		
	   $fce->REQUISITION_ITEMS->Append($fce->REQUISITION_ITEMS->row); 
	   
	   $fce->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK) 
 		{	
			//Jika no.PP kosong maka tampilkan pesan error
			if($fce->NUMBER != '')
			{
				$fce2->call();
				$this->CI->session->set_userdata('sap_pr_num',$fce->NUMBER);
			}
			else
			{	
				//Rollback process
				$fce3->call();
				
				$pr_num = '';
				
				$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
			 while ($fce->RETURN->Next())
			{
				if($bg==0)
				{
					echo"<tr style=background-color:#eeeeee;>";
					$bg++;
				}
				else
				{
					echo"<tr style=background-color:#;>";
					$bg--;
				}
				echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
				}
			    echo "</table>";	
			}
		}
		else
		{
			 $fce->PrintStatus();
			 $sap->Close();
		}
	//return $pr_num;
}

//Edit PR
function fm_edit_pr($old_prnum,$quantity,$c_amt_bapi)
{
	
			$sap = new SAPConnection();
			$sap->Connect($this->sap_connection_string());
			if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open();
			if ($sap->GetStatus() != SAPRFC_OK ) {
		   	$sap->PrintStatus();
		   	exit;
			}
			
			$fce = &$sap->NewFunction ("BAPI_REQUISITION_CHANGE");
			if ($fce == false ) {
			   $sap->PrintStatus();
			   exit;
			}
			
			$fce2 = &$sap->NewFunction ("BAPI_REQUISITION_GETDETAIL");
    		if ($fce2 == false ) {
       		$sap->PrintStatus();
       		exit;
    		}
			
			$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    		if ($fce3 == false ) {
       		$sap->PrintStatus();
       		exit;
    		}
			
			$fce4 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    		if ($fce4 == false ) {
       		$sap->PrintStatus();
       		exit;
    		}
			
			//Insert PP Old num
			$fce2->NUMBER  = $old_prnum;
	  		$fce2->call();
			
			//Get PP OLD data
			if ($fce2->GetStatus() == SAPRFC_OK) 
			{	 
				$fce2->REQUISITION_ITEMS->Reset();
				while ( $fce2->REQUISITION_ITEMS->Next() )
				 {
					 
					 //PP Old Data
					$fce->REQUISITION_ITEMS_OLD->row["PREQ_ITEM"] = $fce2->REQUISITION_ITEMS->row["PREQ_ITEM"]; 
					$fce->REQUISITION_ITEMS_OLD->row["PUR_GROUP"] = $fce2->REQUISITION_ITEMS->row["PUR_GROUP"]; 
					$fce->REQUISITION_ITEMS_OLD->row["SHORT_TEXT"] = $fce2->REQUISITION_ITEMS->row["SHORT_TEXT"]; 
					$fce->REQUISITION_ITEMS_OLD->row["MAT_GRP"] = $fce2->REQUISITION_ITEMS->row["MAT_GRP"]; 
					$fce->REQUISITION_ITEMS_OLD->row["QUANTITY"] = $fce2->REQUISITION_ITEMS->row["QUANTITY"]; 
					$fce->REQUISITION_ITEMS_OLD->row["UNIT"] = $fce2->REQUISITION_ITEMS->row["UNIT"]; 
					$fce->REQUISITION_ITEMS_OLD->row["DEL_DATCAT"] = $fce2->REQUISITION_ITEMS->row["DEL_DATCAT"]; 
					$fce->REQUISITION_ITEMS_OLD->row["DELIV_DATE"] = $fce2->REQUISITION_ITEMS->row["DELIV_DATE"]; 
					$fce->REQUISITION_ITEMS_OLD->row["REL_DATE"] = $fce2->REQUISITION_ITEMS->row["REL_DATE"]; 
					$fce->REQUISITION_ITEMS_OLD->row["C_AMT_BAPI"] = $fce2->REQUISITION_ITEMS->row["C_AMT_BAPI"]; 
					$fce->REQUISITION_ITEMS_OLD->row["PRICE_UNIT"] = $fce2->REQUISITION_ITEMS->row["PRICE_UNIT"]; 
					$fce->REQUISITION_ITEMS_OLD->row["GR_IND"] = $fce2->REQUISITION_ITEMS->row["GR_IND"]; 
					$fce->REQUISITION_ITEMS_OLD->row["IR_IND"] = $fce2->REQUISITION_ITEMS->row["IR_IND"]; 
					$fce->REQUISITION_ITEMS_OLD->row["CURRENCY"] = $fce2->REQUISITION_ITEMS->row["CURRENCY"]; 
	
	
					$fce->REQUISITION_ITEMS_OLD->row["PURCH_ORG"] = $fce2->REQUISITION_ITEMS->row["PURCH_ORG"]; 
					$fce->REQUISITION_ITEMS_OLD->row["FIXED_VEND"] = $fce2->REQUISITION_ITEMS->row["FIXED_VEND"]; 
					$fce->REQUISITION_ITEMS_OLD->row["INFO_REC"] = $fce2->REQUISITION_ITEMS->row["INFO_REC"]; 
					
					$fce->REQUISITION_ITEMS_OLD->Append($fce->REQUISITION_ITEMS_OLD->row); 
					
					//PP New Data
					$fce->REQUISITION_ITEMS_NEW->row["PREQ_ITEM"] = $fce2->REQUISITION_ITEMS->row["PREQ_ITEM"]; 
					$fce->REQUISITION_ITEMS_NEW->row["PUR_GROUP"] = $fce2->REQUISITION_ITEMS->row["PUR_GROUP"]; 
					$fce->REQUISITION_ITEMS_NEW->row["SHORT_TEXT"] = $fce2->REQUISITION_ITEMS->row["SHORT_TEXT"]; 
					$fce->REQUISITION_ITEMS_NEW->row["MAT_GRP"] = $fce2->REQUISITION_ITEMS->row["MAT_GRP"]; 
					
					$fce->REQUISITION_ITEMS_NEW->row["PURCH_ORG"] = $fce2->REQUISITION_ITEMS->row["PURCH_ORG"]; 
					$fce->REQUISITION_ITEMS_NEW->row["FIXED_VEND"] = $fce2->REQUISITION_ITEMS->row["FIXED_VEND"]; 
					$fce->REQUISITION_ITEMS_NEW->row["INFO_REC"] = $fce2->REQUISITION_ITEMS->row["INFO_REC"]; 
					
					//Change
					$fce->REQUISITION_ITEMS_NEW->row["QUANTITY"] = $quantity; 
					$fce->REQUISITION_ITEMS_NEW->row["UNIT"] = $fce2->REQUISITION_ITEMS->row["UNIT"]; 
					//Change
					$fce->REQUISITION_ITEMS_NEW->row["DEL_DATCAT"] = $fce2->REQUISITION_ITEMS->row["DEL_DATCAT"]; 
					//Change
					$fce->REQUISITION_ITEMS_NEW->row["DELIV_DATE"] = $fce2->REQUISITION_ITEMS->row["DELIV_DATE"]; 
					//Change
					$fce->REQUISITION_ITEMS_NEW->row["REL_DATE"] = $fce2->REQUISITION_ITEMS->row["REL_DATE"]; 
					//Change
					$fce->REQUISITION_ITEMS_NEW->row["C_AMT_BAPI"] = $c_amt_bapi; 
					$fce->REQUISITION_ITEMS_NEW->row["PRICE_UNIT"] = $fce2->REQUISITION_ITEMS->row["PRICE_UNIT"]; 
					$fce->REQUISITION_ITEMS_NEW->row["GR_IND"] = $fce2->REQUISITION_ITEMS->row["GR_IND"]; 
					$fce->REQUISITION_ITEMS_NEW->row["IR_IND"] = $fce2->REQUISITION_ITEMS->row["IR_IND"]; 
					$fce->REQUISITION_ITEMS_NEW->row["CURRENCY"] = $fce2->REQUISITION_ITEMS->row["CURRENCY"]; 
			
					$fce->REQUISITION_ITEMS_NEW->Append($fce->REQUISITION_ITEMS_NEW->row); 
					
					$fce->NUMBER  = $old_prnum;
					$fce->call();
					
					//Check error status
					$fce->RETURN->Reset();
					$error = 0;
					$bg = 0;
					// echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					 while ( $fce->RETURN->Next() )
					{
						if($fce->RETURN->row["TYPE"]=='E')
						
						{ 
						echo $fce->RETURN->row["MESSAGE"];
						//$error=1; 
						
						};
						
						/*if($bg==0)
						{
						echo"<tr style=background-color:#eeeeee;>";
						$bg++;
						}
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";*/
					}
						//echo "</table>";	
					
					//Rollback
					$fce4->call();
				 }
			}
			else
			{
				$fce2->PrintStatus();
			 	$sap->Close();
			}
	return $error;		
}

//Create PO
function fm_create_po($vendor,$sloc,$qty,$tax,$netprice,$pr_num,$preqname,$disc)
{	
	$this->CI->session->unset_userdata('sap_po_num');
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("BAPI_PO_CREATE1");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	//PO HEADER		
		$POHEADER = array();
        $POHEADER["COMP_CODE"] = 'WGI1';
		$POHEADER["DOC_TYPE"] = 'UO';
		$POHEADER["ITEM_INTVL"] = '00001';
		$POHEADER["VENDOR"] = $this->fm_convert_vendor($vendor);
		$POHEADER["PURCH_ORG"] = 'WGI1';
		$POHEADER["PUR_GROUP"] = '001';
		$POHEADER["CURRENCY"] = 'IDR';
		$POHEADER["CURRENCY_ISO"] = 'IDR';
		$POHEADER["DOC_DATE"] = date('Ymd');
		
	    $fce->POHEADER  = $POHEADER;
		
		$fce->NO_PRICE_FROM_PO  = 'X';
		
	   //PO HEADERX		
		$POHEADERX = array();
        $POHEADERX["COMP_CODE"] = 'X';
		$POHEADERX["DOC_TYPE"] = 'X';
		$POHEADERX["ITEM_INTVL"] = 'X';
		$POHEADERX["VENDOR"] = 'X';
		$POHEADERX["PURCH_ORG"] = 'X';
		$POHEADERX["PUR_GROUP"] = 'X';
		$POHEADERX["CURRENCY"] = 'X';
		$POHEADERX["CURRENCY_ISO"] = 'X';
		$POHEADERX["DOC_DATE"] = 'X';
		
	    $fce->POHEADERX  = $POHEADERX;
		
	   //PO ITEM
	   $fce->POITEM->row["PO_ITEM"] = '0000X';
	   $fce->POITEM->row["MATERIAL"] = 'R101';
	   $fce->POITEM->row["PLANT"] = "1000";
	   $fce->POITEM->row["STGE_LOC"] =  $sloc;
       $fce->POITEM->row["QUANTITY"] = $qty;
	   $fce->POITEM->row["PO_UNIT"] = "L";
	   $fce->POITEM->row["PO_UNIT_ISO"] = "L";
	   $fce->POITEM->row["TAX_CODE"] = $tax; //NON TAX: V0, TAX: V1
	   $fce->POITEM->row["GR_IND"] = 'X';
	   $fce->POITEM->row["IR_IND"] = 'X';
	   $fce->POITEM->row["GR_BASEDIV"] = 'X';
	   $fce->POITEM->row["NET_PRICE"] =  $netprice;
	   $fce->POITEM->row["PRICE_UNIT"] = 1;
	   $fce->POITEM->row["PREQ_NO"] =   $pr_num;
	   $fce->POITEM->row["PREQ_ITEM"] = '00001';
	   $fce->POITEM->row["PREQ_NAME"] = $preqname;
	   
	   $fce->POITEM->Append($fce->POITEM->row); 
	     
	    //PO ITEMX
	   $fce->POITEMX->row["PO_ITEM"] = 'X';
	   $fce->POITEMX->row["MATERIAL"] = 'X';
	   $fce->POITEMX->row["PLANT"] = 'X';
	   $fce->POITEMX->row["STGE_LOC"] = 'X';
	   $fce->POITEMX->row["QUANTITY"] = 'X';
	   $fce->POITEMX->row["PO_UNIT"] = 'X';
	   $fce->POITEMX->row["PO_UNIT_ISO"] = 'X';
	   $fce->POITEMX->row["TAX_CODE"] = 'X';
	   $fce->POITEMX->row["GR_IND"] = 'X';
	   $fce->POITEMX->row["IR_IND"] = 'X';
	   $fce->POITEMX->row["GR_BASEDIV"] = 'X';
	   $fce->POITEMX->row["PREQ_NO"] = 'X';
	   $fce->POITEMX->row["PREQ_ITEM"] = 'X';
	   $fce->POITEMX->row["PREQ_NAME"] = 'X';
	   $fce->POITEMX->row["NET_PRICE"] = 'X';
	   $fce->POITEMX->row["PRICE_UNIT"] = 'X';
	   
	   $fce->POITEMX->Append($fce->POITEMX->row); 
		
		if($disc > 0)
		{
		//PO CONDITIONS (DISCOUNT)
		 $fce->POCOND->row["ITM_NUMBER"] = '0000X';
		 $fce->POCOND->row["COND_ST_NO"] = '010';
		 $fce->POCOND->row["COND_TYPE"] = 'RB00';
		 $fce->POCOND->row["COND_VALUE"] = $disc * -1;
		 $fce->POCOND->row["CURRENCY"] = 'IDR';
		 $fce->POCOND->row["CURRENCY_ISO"] = 'IDR';
		 $fce->POCOND->row["COND_UNIT"] = 'L';
		 $fce->POCOND->row["COND_P_UNT "] = 1;
		 $fce->POCOND->row["CHANGE_ID"] = 'I';
		 
		 $fce->POCOND->Append($fce->POCOND->row); 
		
		 $fce->POCONDX->row["ITM_NUMBER"] = 'X';
		 $fce->POCONDX->row["COND_ST_NO"] = '000';
		 $fce->POCONDX->row["COND_TYPE"] = 'X';
		 $fce->POCONDX->row["COND_VALUE"] = 'X';
		 $fce->POCONDX->row["CURRENCY"] = 'X';
		 $fce->POCONDX->row["CHANGE_ID"] = 'X';
		 
		$fce->POCONDX->Append($fce->POCONDX->row);
		//PO CONDITIONS (DISCOUNT)
		}
	   $fce->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK) 
 		{
			if($fce->EXPPURCHASEORDER != '')
			{
				//Commit transaction
				$fce2->call();
				$this->CI->session->set_userdata('sap_po_num',$fce->EXPPURCHASEORDER);
				$sap->Close();
			}	
			else
			{			
			  	
			//Rollback transaction
			  $fce3->call();
	
			 $fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
			 while ( $fce->RETURN->Next() )
				{
						if($bg==0)
						{
						echo"<tr style=background-color:#eeeeee;>";
						$bg++;
						}
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
					echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
						}
					echo "</table>";	
			}
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

//Create MIGO
function fm_create_migo($header_txt,$sloc,$vendor,$rcpt,$itemtext,$qty,$no_po,$postdate)
{	
	$this->CI->session->unset_userdata('sap_migo_num');
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_GOODSMVT_CREATE");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
		//Input header item
		$header = array();
        $header["PSTNG_DATE"] =  $this->fm_sap_yyyymmdd($postdate);
		$header["DOC_DATE"] =   date('Ymd');
		$header["HEADER_TXT"] = $header_txt;
		$header["VER_GR_GI_SLIP"] = 'X';
		//$header["REF_DOC_NO"] = '0000200020';
		
		$fce->GOODSMVT_HEADER  = $header;
		
		
		//$fce->GOODSMVT_HEADER->Append($fce->GOODSMVT_HEADER->row); 
		//Goods movement code
		/*
		
		1. GM_Code 01: Goods receipt for purchase order
		2. GM_Code 02: Goods receipt for production order
		3. GM_Code 03: Goods issue
		4. GM_Code 04: Transfer posting
		5. GM_Code 05: Other goods receipt
		6. GM_Code 06: Reversal of goods movements
		7. GM_Code 07: Subsequent adjustment with regard to a subcontract order
		*/
		$code = array();
        $code["GM_CODE"] = '01';
		$fce->GOODSMVT_CODE  = $code;
		
	   /*Goods item*/
	   $fce->GOODSMVT_ITEM->row["MATERIAL"] = 'R101';
	   $fce->GOODSMVT_ITEM->row["PLANT"] =  "1000";
	   $fce->GOODSMVT_ITEM->row["MOVE_TYPE"] = '101';
	   //$fce->GOODSMVT_ITEM->row["SPEC_STOCK"] =  'B';
	   $fce->GOODSMVT_ITEM->row["STGE_LOC"] = $sloc;
	   $fce->GOODSMVT_ITEM->row["VENDOR"] =   $this->fm_convert_vendor($vendor);
	   $fce->GOODSMVT_ITEM->row["GR_RCPT"] =  $rcpt;
	   $fce->GOODSMVT_ITEM->row["ITEM_TEXT"] = $itemtext;
	   //$fce->GOODSMVT_ITEM->row["AMOUNT_LC"] = $netprice ;
	   $fce->GOODSMVT_ITEM->row["ENTRY_QNT"] = $qty;
	   $fce->GOODSMVT_ITEM->row["PO_PR_QNT"] = $qty;
	   $fce->GOODSMVT_ITEM->row["ENTRY_UOM"] = "L";
	   $fce->GOODSMVT_ITEM->row["ENTRY_UOM_ISO"] = "L";
	   $fce->GOODSMVT_ITEM->row[" NO_MORE_GR"] = 'X';
	   $fce->GOODSMVT_ITEM->row["PO_NUMBER"] = $no_po;
	   $fce->GOODSMVT_ITEM->row["PO_ITEM"] = '00001';
	   $fce->GOODSMVT_ITEM->row["MVT_IND"] =  'B';
	   
	   $fce->GOODSMVT_ITEM->Append($fce->GOODSMVT_ITEM->row); 
	   
	   $fce->Call();
	
	   
 		if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->MATERIALDOCUMENT != '')
		 	{
				$fce2->Call();
				$this->CI->session->set_userdata('sap_migo_num', $fce->MATERIALDOCUMENT);			
		 	}
			else
			{
				 $fce3->Call();	
			 	$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}		
}

//Create MIRO
function fm_create_miro($docdate, $pstgdate, $gross_amount, $po_num, $migo_num, $gross_amount2, $qty, $term, $ppn, $txt_info)
{	
	$this->CI->session->unset_userdata('sap_miro_num');
	//$post_date, $gross_amount, $po_num, $migo_num, $qty
	//BAPI_INCOMINGINVOICE_CREATE
	 $sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_INCOMINGINVOICE_CREATE");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	//Input header item
		$headerdata = array();
		$headerdata["INVOICE_IND"] = 'X';
		$headerdata["DOC_TYPE"] = 'RE';
		$headerdata["DOC_DATE"] = $this->fm_sap_yyyymmdd($docdate);
		$headerdata["PSTNG_DATE"] = $this->fm_sap_yyyymmdd($pstgdate);
		//$headerdata["BLINE_DATE"] = date('Ymd');
		$headerdata["BLINE_DATE"] = $this->fm_sap_yyyymmdd($pstgdate);
		$headerdata["COMP_CODE"] = 'WGI1';
		$headerdata["CURRENCY"] = 'IDR';
		$headerdata["CURRENCY_ISO"] = 'IDR';
		$headerdata["GROSS_AMOUNT"] = $gross_amount;
		$headerdata["PMNTTRMS"] = $term;
		//Test Pake Pajak
		//$headerdata["CALC_TAX_IND"] = 'X';
		
		$fce->HEADERDATA  = $headerdata;
		
		$fce->ITEMDATA->row["INVOICE_DOC_ITEM"] =  '000001';
		$fce->ITEMDATA->row["PO_ITEM"] =  '00001';
		$fce->ITEMDATA->row["PO_NUMBER"] =  $po_num;
		$fce->ITEMDATA->row["REF_DOC"] =  $migo_num;
		$fce->ITEMDATA->row["REF_DOC_YEAR"] =  date("Y", strtotime($pstgdate));
		$fce->ITEMDATA->row["REF_DOC_IT"] =  '0001';
		$fce->ITEMDATA->row["ITEM_AMOUNT"] =  $gross_amount2;
		$fce->ITEMDATA->row["QUANTITY"] =  $qty;
		$fce->ITEMDATA->row["PO_UNIT"] =  'L';
		$fce->ITEMDATA->row["PO_UNIT_ISO"] =  'L';
		
		 //Jika ada pajak
	   if($ppn > 0)
	   {
		   $fce->ITEMDATA->row["TAX_CODE"] =  'V2';
		   
	   }

	   $fce->ITEMDATA->Append($fce->ITEMDATA->row); 
	   
	  //Jika ada pajak
	   if($ppn > 0)
	   {
		    $fce->GLACCOUNTDATA->row["INVOICE_DOC_ITEM"] =  '000001';
		    $fce->GLACCOUNTDATA->row["GL_ACCOUNT"] =  '0001170001';
		    $fce->GLACCOUNTDATA->row["ITEM_AMOUNT"] =  $ppn;
			$fce->GLACCOUNTDATA->row["DB_CR_IND"] =  'S';
			$fce->GLACCOUNTDATA->row["COMP_CODE"] =  'WGI1';
			$fce->GLACCOUNTDATA->row["BUS_AREA"] =  '1000';
			$fce->GLACCOUNTDATA->row["ITEM_TEXT"] =  $txt_info;
			
			$fce->GLACCOUNTDATA->Append($fce->GLACCOUNTDATA->row); 
		   
		    $fce->TAXDATA->row["TAX_CODE"] =  'V2';
			$fce->TAXDATA->Append($fce->TAXDATA->row); 
	   }
	   
	   
	  
	   
	   
	   $fce->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->INVOICEDOCNUMBER != '')
		 	{
				$fce2->Call();
				//echo $fce->INVOICEDOCNUMBER;
				$this->CI->session->set_userdata('sap_miro_num', $fce->INVOICEDOCNUMBER);	
		 	}
			else
			{
				$fce3->Call();

				$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

//Untuk posting G/L Account
function fm_post_gl_acc($header_txt,  $post_date, $doc_date, $ref_doc_no, $accountgl, $curramount)
{	
	//Get G/L Balances
	//BAPI_GL_GETGLACCPERIODBALANCES
	//Currency type : 10 Company code currency
	
	//Buat function module untuk display list balance G/L table : 1111402
	
	$this->CI->session->unset_userdata('sap_obj_key');
	
	 $sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction("BAPI_ACC_GL_POSTING_POST");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	//Input header item
		$headerdata = array();
		$headerdata["USERNAME"] = 'IMC_DPERMANA';
		$headerdata["HEADER_TXT"] = $header_txt;
		$headerdata["COMP_CODE"] = 'WGI1';
		//$headerdata["FISC_YEAR"] = date('Y');
		$headerdata["FISC_YEAR"] = date("Y", strtotime($post_date));
		$headerdata["DOC_DATE"] = $this->fm_sap_yyyymmdd($doc_date);
		$headerdata["PSTNG_DATE"] = $this->fm_sap_yyyymmdd($post_date);
		$headerdata["FIS_PERIOD"] =   $this->fm_sap_month($post_date);
		$headerdata["DOC_TYPE"] =  'SA';
		$headerdata["REF_DOC_NO"] =  $ref_doc_no;

		$fce->DOCUMENTHEADER  = $headerdata;
	
	//Input G/L item
		//$accountgl = array();
		foreach ($accountgl as $row)
  		{	
			
			$fce->ACCOUNTGL->row["ITEMNO_ACC"] =  $row["ITEMNO_ACC"];
			$fce->ACCOUNTGL->row["GL_ACCOUNT"] =  $this->fm_convert_vendor($row["GL_ACCOUNT"]);
			$fce->ACCOUNTGL->row["COMP_CODE"] =  'WGI1';
			$fce->ACCOUNTGL->row["PSTNG_DATE"] =  $this->fm_sap_yyyymmdd($row["PSTNG_DATE"]);
			$fce->ACCOUNTGL->row["DOC_TYPE"] =  'SA';
			$fce->ACCOUNTGL->row["FIS_PERIOD"] =  $this->fm_sap_month($row["FIS_PERIOD"]);
			$fce->ACCOUNTGL->row["ALLOC_NMBR"] =  $row["ALLOC_NMBR"];
			$fce->ACCOUNTGL->row["ITEM_TEXT"] =   $row["ITEM_TEXT"];
			$fce->ACCOUNTGL->row["COSTCENTER"] =  $this->fm_convert_vendor($row["COSTCENTER"]);
			$fce->ACCOUNTGL->row["BUS_AREA"] =  '1000';
			
		   $fce->ACCOUNTGL->Append($fce->ACCOUNTGL->row); 
  		}
		
	   
	   
	   	//Currency amount
		//$accountgl = array();
		foreach ($curramount as $row)
  		{	
			$fce->CURRENCYAMOUNT->row["ITEMNO_ACC"] =  $row["ITEMNO_ACC"];
			$fce->CURRENCYAMOUNT->row["CURRENCY"] =  'IDR';
			$fce->CURRENCYAMOUNT->row["CURRENCY_ISO"] =  'IDR';
			$fce->CURRENCYAMOUNT->row["AMT_DOCCUR"] =  $row["AMT_DOCCUR"] ;
			
			$fce->CURRENCYAMOUNT->Append($fce->CURRENCYAMOUNT->row);  
		}
		
		 $fce->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->OBJ_KEY != '$')
		 	{	
				//Disable dulu utk testing
				$fce2->Call();
				$this->CI->session->set_userdata('sap_obj_key',$fce->OBJ_KEY);
				
		 	}
			else
			{
				$fce3->Call();

				$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
			
		} 
}

/*Post With Clearing*/
function fm_post_clr($bldat, $budat, $monat, $xblnr,$bktxt,$vendor,$total,$assg1,$sgtxt1,$newko2,$assg2,$sgtxt2,$newko3,$assg3,$sgtxt3,$newko4,$assg4,$sgtxt4)
{

$this->CI->session->unset_userdata('sap_clr_num');

 $sap = new SAPConnection();
    $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("YFM_F04_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	/*$fce->BLDAT_001  = $bldat;
	$fce->BLART_002 = 'KZ';
	$fce->BUKRS_003 = 'WGI1';
	$fce->BUDAT_004  = $budat;
	$fce->MONAT_005  = $monat;
	$fce->WAERS_006 = 'IDR';
	$fce->XBLNR_007 = $xblnr;
	$fce->BKTXT_008 = $bktxt;
	$fce->NEWBS_011 = '29';
	$fce->NEWKO_012 = $this->fm_convert_vendor($vendor);
	$fce->NEWUM_013 = 'D';
	$fce->WRBTR_014 = $total;
	$fce->GSBER_015 = '1000';
	$fce->ZFBDT_016 =  date('d.m.Y');
	$fce->ZUONR_017 = $assg1;
	$fce->SGTXT_018 = $sgtxt1;
	$fce->NEWBS_019 = '50';
	$fce->NEWKO_020 = $newko2;
	$fce->WRBTR_021 = $total;
	$fce->ZUONR_022 = $assg2;
	$fce->SGTXT_023 = $sgtxt2;
	$fce->NEWBS_024 = '40';
	$fce->NEWKO_025 = $newko3;
	$fce->GSBER_026 = '1000';
	$fce->WRBTR_027 = $total;
	$fce->ZUONR_028 = $assg3;
	$fce->SGTXT_029 = $sgtxt3;
	$fce->NEWBS_030 = '50';
	$fce->NEWKO_031 = $newko4;
	$fce->GSBER_032  = '1000';
	$fce->WRBTR_033  = $total;
	$fce->ZUONR_034  = $assg4;
	$fce->SGTXT_035  = $sgtxt4;
	$fce->GSBER_036 = '1000';*/
	
	$fce->BLDAT_001  = $bldat;
	$fce->BLART_002 = 'KZ';
	$fce->BUKRS_003 = 'WGI1';
	$fce->BUDAT_004  = $budat;
	$fce->MONAT_005  = $monat;
	$fce->WAERS_006 = 'IDR';
	$fce->XBLNR_007 = $xblnr;
	$fce->BKTXT_008 = $bktxt;
	$fce->NEWBS_010 = '29';
	$fce->NEWKO_011 = $this->fm_convert_vendor($vendor);
	$fce->NEWUM_012 = 'D';
	$fce->WRBTR_013 = $total;
	$fce->GSBER_014 = '1000';
	$fce->ZFBDT_015 =  date('d.m.Y');
	$fce->ZUONR_016 = $assg1;
	$fce->SGTXT_017 = $sgtxt1;
	$fce->NEWBS_018 = '50';
	$fce->NEWKO_019 = $newko2;
	$fce->WRBTR_020 = $total;
	$fce->ZUONR_021 = $assg2;
	$fce->SGTXT_022 = $sgtxt2;
	$fce->NEWBS_023 = '40';
	$fce->NEWKO_024 = $newko3;
	$fce->GSBER_025 = '1000';
	$fce->WRBTR_026 = $total;
	$fce->ZUONR_027 = $assg3;
	$fce->SGTXT_028 = $sgtxt3;
	$fce->NEWBS_029 = '50';
	$fce->NEWKO_030 = $newko4;
	$fce->GSBER_031  = '1000';
	$fce->WRBTR_032  = $total;
	$fce->ZUONR_034  = $assg4;
	$fce->SGTXT_035  = $sgtxt4;
	$fce->GSBER_036 = '1000';
	$fce->Call();
	
if ($fce->GetStatus() == SAPRFC_OK) 
{
	
		 if($fce->GV_NUM != '')
		 {
			
			$this->CI->session->set_userdata('sap_clr_num',$fce->GV_NUM);
		 }
		 else
		 {
		  $fce->GI_RETURN->Reset();
		echo "<table border=1 bordercolor='#000000' cellpadding='0' cellspacing='0' align='center'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
		 while ( $fce->GI_RETURN->Next() ){
			if($bg==0)
           	{
			   echo"<tr style=background-color:#eeeeee;>";
			   $bg++;
           	}
            else
			{
				echo"<tr style=background-color:#;>";
				$bg--;
			}
			echo "<td>".$fce->GI_RETURN->row["TYPE"]."</td><td>".$fce->GI_RETURN->row["ID"]."</td><td>".$fce->GI_RETURN->row["MESSAGE"]."</td></tr>";
		 }
		
}
	
		
 } 
 else
 {
	
	 $fce->PrintStatus(); 
	 
 }
}

//Reverse MIRO
function fm_reverse_miro($miro, $year, $reason, $postdate)
{	
	$this->CI->session->unset_userdata('sap_mirorev_num');
	
	 $sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_INCOMINGINVOICE_CANCEL");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	   $fce->INVOICEDOCNUMBER  = $miro;
	   $fce->FISCALYEAR = $year;
	   $fce->REASONREVERSAL = $reason;
	   $fce->POSTINGDATE = $this->fm_sap_yyyymmdd($postdate);
	   
	   $fce->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->INVOICEDOCNUMBER_REVERSAL != '')
		 	{
				$fce2->Call();
				//echo $fce->INVOICEDOCNUMBER;
				$this->CI->session->set_userdata('sap_mirorev_num', $fce->INVOICEDOCNUMBER_REVERSAL);	
		 	}
			else
			{
				$fce3->Call();

				$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

//Create Transfer Posting
function fm_create_tp($headertxt, $refdoc,$mvttyp,$storage,$moveslco,$grrcpt,$qty, $postdate)
{	
	$this->CI->session->unset_userdata('sap_tp_num');
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_GOODSMVT_CREATE");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
		//Input header item
		$header = array();
        $header["PSTNG_DATE"] = $this->fm_sap_yyyymmdd($postdate);
		$header["DOC_DATE"] =   date('Ymd');
		$header["HEADER_TXT"] = $headertxt;
		//$header["GR_GI_SLIP_NO"] = 'Testing';
		//$header["VER_GR_GI_SLIP"] = 'X';
		$header["REF_DOC_NO"] = $refdoc;
		
		$fce->GOODSMVT_HEADER  = $header;
		
		
		//$fce->GOODSMVT_HEADER->Append($fce->GOODSMVT_HEADER->row); 
		//Goods movement code
		/*
		
		1. GM_Code 01: Goods receipt for purchase order
		2. GM_Code 02: Goods receipt for production order
		3. GM_Code 03: Goods issue
		4. GM_Code 04: Transfer posting
		5. GM_Code 05: Other goods receipt
		6. GM_Code 06: Reversal of goods movements
		7. GM_Code 07: Subsequent adjustment with regard to a subcontract order
		*/
		$code = array();
        $code["GM_CODE"] = '04';
		$fce->GOODSMVT_CODE  = $code;
		
	   /*Goods item*/
	   $fce->GOODSMVT_ITEM->row["MATERIAL"] = 'R101';
	   $fce->GOODSMVT_ITEM->row["PLANT"] =  "1000";
	   
	   $fce->GOODSMVT_ITEM->row["MOVE_TYPE"] = $mvttyp;
	   $fce->GOODSMVT_ITEM->row["STGE_LOC"] = $storage;
	   $fce->GOODSMVT_ITEM->row["MOVE_STLOC"] = $moveslco;
	   
	  /* movement type 303 (remove stock)
	  $fce->GOODSMVT_ITEM->row["MOVE_TYPE"] = '303';
	   $fce->GOODSMVT_ITEM->row["STGE_LOC"] = 'COL1';
	   $fce->GOODSMVT_ITEM->row["MOVE_STLOC"] = '';
	 */
	 
	 /* movement type 311 (Transfer stock)
	  $fce->GOODSMVT_ITEM->row["MOVE_TYPE"] = '311';
	   $fce->GOODSMVT_ITEM->row["STGE_LOC"] = 'COL1';
	   $fce->GOODSMVT_ITEM->row["MOVE_STLOC"] = '501A';
	 */
	   $fce->GOODSMVT_ITEM->row["GR_RCPT"] =  $grrcpt;
	   $fce->GOODSMVT_ITEM->row["ENTRY_QNT"] = $qty;

	   $fce->GOODSMVT_ITEM->row["ENTRY_UOM"] = "L";
	   $fce->GOODSMVT_ITEM->row["ENTRY_UOM_ISO"] = "L";
	   
	   $fce->GOODSMVT_ITEM->Append($fce->GOODSMVT_ITEM->row); 
	   
	   $fce->Call();
	
	   
 		if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->MATERIALDOCUMENT != '')
		 	{
				$fce2->Call();
				$this->CI->session->set_userdata('sap_tp_num', $fce->MATERIALDOCUMENT);			
		 	}
			else
			{
				 $fce3->Call();	
			 	$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}		
}

/* Function for check pric proc PPN */
function fm_check_ppn($vendor)
{
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_CHKVENTAX_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	  $fce->GV_LIFNR =$this->fm_convert_vendor($vendor);
	  
	  $fce->Call();
	
	   
 		if ($fce->GetStatus() == SAPRFC_OK)
		{
			return $fce->GV_STATUS;
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
	
}

/* Function for check vendor G/L */
function fm_check_gl($vendor)
{
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_CHKVENGL_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	  $fce->GV_LIFNR =$this->fm_convert_vendor($vendor);
	  
	  $fce->Call();
	
	   
 		if ($fce->GetStatus() == SAPRFC_OK)
		{
			return $fce->GV_STATUS;
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
	
}

//Function for cancel MIGO
function fm_cancel_migo($matdoc, $matdocyear, $pstgdate, $pruname)
{
	
	$this->CI->session->unset_userdata('sap_migorev_num');
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
 
	$fce = &$sap->NewFunction ("BAPI_GOODSMVT_CANCEL");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->MATERIALDOCUMENT = $matdoc;
	$fce->MATDOCUMENTYEAR = $matdocyear;
	$fce->GOODSMVT_PSTNG_DATE = $this->fm_sap_yyyymmdd($pstgdate);
	$fce->GOODSMVT_PR_UNAME = $pruname;
	
	//$fce->GOODSMVT_MATDOCITEM->row["MATDOC_ITEM"] = "0001";
	//$fce->GOODSMVT_MATDOCITEM->Append($fce->GOODSMVT_MATDOCITEM->row); 
	
	$fce->call();
	
	if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->GOODSMVT_HEADRET["MAT_DOC"] != '' && $fce->GOODSMVT_HEADRET["DOC_YEAR"] != '')
		 	{
				$fce2->Call();
				$this->CI->session->set_userdata('sap_migorev_num', $fce->GOODSMVT_HEADRET["MAT_DOC"]);			
		 	}
			else
			{
				$fce3->Call();	
			 	$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}		
}

/* Function for check PO Condition */
function fm_check_po_cond($cond, $po)
{
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_CHKPOCOND_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	  $fce->GV_COND = $cond;
	  $fce->GV_PO = $po;
	  
	  $fce->Call();
	
	   
 		if ($fce->GetStatus() == SAPRFC_OK)
		{
			return $fce->GV_STATUS;
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
	
}
//Change PO
function fm_change_po($ebeln,$qty,$netprice, $disc)
{	

	$this->CI->session->unset_userdata('sap_po_num');
	
	 $sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_PO_CHANGE");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->PURCHASEORDER = $ebeln;
	
		//PO ITEM
	   $fce->POITEM->row["PO_ITEM"] = 00001;
	   //$fce->POITEM->row["DELETE_IND"] = 'X';
	
	  // $fce->POITEM->row["MATERIAL"] = 'R101';
	  // $fce->POITEM->row["PLANT"] = "1000";
	  // $fce->POITEM->row["STGE_LOC"] =  $sloc;
       $fce->POITEM->row["QUANTITY"] = $qty;
	  // $fce->POITEM->row["PO_UNIT"] = "L";
	  // $fce->POITEM->row["PO_UNIT_ISO"] = "L";
	  // $fce->POITEM->row["TAX_CODE"] = 'V1'; //V1 PPN 10%
	  // $fce->POITEM->row["GR_IND"] = 'X';
	  // $fce->POITEM->row["IR_IND"] = 'X';
	  // $fce->POITEM->row["GR_BASEDIV"] = 'X';
	   $fce->POITEM->row["NET_PRICE"] =  $netprice;
	 //  $fce->POITEM->row["PRICE_UNIT"] = 1;
	 //  $fce->POITEM->row["PREQ_NO"] =   $pr_num;
	 // $fce->POITEM->row["PREQ_ITEM"] = '00001';
	 // $fce->POITEM->row["PREQ_NAME"] = $preqname;
	  
	  $fce->POITEM->Append($fce->POITEM->row);


		//PO ITEMX
	   $fce->POITEMX->row["PO_ITEM"] = 00001;
	   $fce->POITEMX->row["PO_ITEMX"] = 'X';
	   //$fce->POITEMX->row["DELETE_IND"] = 'X';
	  // $fce->POITEMX->row["MATERIAL"] = 'X';
	  // $fce->POITEMX->row["PLANT"] = 'X';
	 //  $fce->POITEMX->row["STGE_LOC"] = 'X';
	   $fce->POITEMX->row["QUANTITY"] = 'X';
	 //  $fce->POITEMX->row["PO_UNIT"] = 'X';
	 //  $fce->POITEMX->row["PO_UNIT_ISO"] = 'X';
	  // $fce->POITEMX->row["TAX_CODE"] = 'X';
	 //  $fce->POITEMX->row["GR_IND"] = 'X';
	 //  $fce->POITEMX->row["IR_IND"] = 'X';
	//   $fce->POITEMX->row["GR_BASEDIV"] = 'X';
	 //  $fce->POITEMX->row["PREQ_NO"] = 'X';
	 //  $fce->POITEMX->row["PREQ_ITEM"] = 'X';
	//   $fce->POITEMX->row["PREQ_NAME"] = 'X';
	   $fce->POITEMX->row["NET_PRICE"] = 'X';
	  // $fce->POITEMX->row["PRICE_UNIT"] = 'X';
	   
	   $fce->POITEMX->Append($fce->POITEMX->row); 
	   
	   
	  		 //Change Net Price
	  		 $fce->POCOND->row["ITM_NUMBER"] = '00001';
			 $fce->POCOND->row["COND_ST_NO"] = '001';
			 $fce->POCOND->row["COND_TYPE"] = 'PBXX';
			 $fce->POCOND->row["COND_VALUE"] = $netprice;
			 $fce->POCOND->row["CURRENCY"] = 'IDR';
			 $fce->POCOND->row["CURRENCY_ISO"] = 'IDR';
			 $fce->POCOND->row["COND_UNIT"] = 'L';
			 $fce->POCOND->row["COND_P_UNT "] = 1;
			 $fce->POCOND->row["CHANGE_ID"] = 'U'; //U for change, //I Insert
			 
			 $fce->POCOND->Append($fce->POCOND->row); 
		 
		// if( $disc > 0 )
		 //{
			//PO CONDITIONS (DISCOUNT)
			 $fce->POCOND->row["ITM_NUMBER"] = '00001';
			 $fce->POCOND->row["COND_ST_NO"] = '010';
			 $fce->POCOND->row["COND_TYPE"] = 'RB00';
			 $fce->POCOND->row["COND_VALUE"] = $disc * -1;
			 $fce->POCOND->row["CURRENCY"] = 'IDR';
			 $fce->POCOND->row["CURRENCY_ISO"] = 'IDR';
			 $fce->POCOND->row["COND_UNIT"] = 'L';
			 $fce->POCOND->row["COND_P_UNT "] = 1;
			 
			 //Jika ada kondisi RB00 (Discount)
			 if($this->fm_check_po_cond('RB00', $ebeln) == 'X')
			 {
			 	$fce->POCOND->row["CHANGE_ID"] = 'U'; //U for change, //I Insert
			 }
			 else
			 {
				 $fce->POCOND->row["CHANGE_ID"] = 'I';
			 }
			 $fce->POCOND->Append($fce->POCOND->row); 
			 
			 $fce->POCONDX->row["ITM_NUMBER"] = 'X';
			 $fce->POCONDX->row["COND_ST_NO"] = '000';
			 $fce->POCONDX->row["COND_TYPE"] = 'X';
			 $fce->POCONDX->row["COND_VALUE"] = 'X';
			 $fce->POCONDX->row["CURRENCY"] = 'X';
			 $fce->POCONDX->row["CHANGE_ID"] = 'X';
		 
			$fce->POCONDX->Append($fce->POCONDX->row);
		// }
		 
		 
		$fce->Call();
		
		if ($fce->GetStatus() == SAPRFC_OK) 
 		{
		//Check error status
					$fce->RETURN->Reset();
					$error = 0;
					
					 while ( $fce->RETURN->Next() )
					{
						if($fce->RETURN->row["TYPE"]=='E')
						{ 
							echo $fce->RETURN->row["MESSAGE"];
							echo '<br>';
							$error=1; 
						}
					}
					if($error == 1)
					{
						//Rollback
						$fce3->call();
					}
					else
					{
						$this->CI->session->set_userdata('sap_po_num',$ebeln);
						//Commit
						$fce2->call();
					}
			}
			else
			{
				$fce->PrintStatus();
			 	$sap->Close();
			}
	//return $error;		
}

/* Function for get CPV number by Acc Doc No */
function fm_get_cpv_num($belnr, $gjahr, $opt)
{
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_GETCPV_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	  $fce->GV_BELNR = $belnr;
	  $fce->GV_GJAHR = $gjahr;
	  $fce->GV_OPT = $opt;
	  
	  $fce->Call();
	
	   
 		if ($fce->GetStatus() == SAPRFC_OK)
		{
			return $fce->GV_BKTXT;
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
	
}


/* Function for reverse G/L Account */
function fm_rev_glacc($accdocno, $postdate, $reason,  $per, $year )
{
	
	$this->CI->session->unset_userdata('sap_obj_key_rev');
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_FB08_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	/*$fce2 = &$sap->NewFunction("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }*/
	
	/*$fce3 = &$sap->NewFunction("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }*/
	
	
	$fce->BELNS_001 = $accdocno;
	$fce->BUDAT_005 = $postdate;
	$fce->STGRD_004 = $reason;
	$fce->BUKRS_002 = 'WGI1';
	$fce->MONAT_006 = $per;
	$fce->GJAHS_003 = $year;
   
	
	$fce->Call();
	
	 if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->GV_BELNR != '')
		 	{	
				//Disable dulu utk testing
				//$fce2->Call();
				$this->CI->session->set_userdata('sap_obj_key_rev',$fce->GV_BELNR);
				
		 	}
			else
			{
				//$fce3->Call();

				$fce->GI_RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->GI_RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->GI_RETURN->row["TYPE"]."</td><td>".$fce->GI_RETURN->row["ID"]."</td><td>".$fce->GI_RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		else
		{
			$fce->PrintStatus();
			$sap->Close();
			
		} 
	
}

/* Function for get acc gl no from miro */
function fm_accno_miro($awkey)
{
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_DISP_ACC_MIRO_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->GV_AWKEY = $awkey;
	$fce->Call();
	
	 if ($fce->GetStatus() == SAPRFC_OK)
		{
			
			return $fce->GV_BELNR;
		}
	else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

/* Function for get stock */
function fm_get_stock($lgort)
{
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_GET_STOCK_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->GV_LGORT = $lgort;
	$fce->Call();
	
	 if ($fce->GetStatus() == SAPRFC_OK)
		{
			
			return $this->fm_sap_format_number2($fce->GV_LABST);
		}
	else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

/* Function for get waste stock */
function fm_get_stock_waste($lgort)
{
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_GET_STOCK_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->GV_LGORT = $lgort;
	$fce->Call();
	
	 if ($fce->GetStatus() == SAPRFC_OK)
		{
			
			return $this->fm_sap_format_number2($fce->GV_INSME);
		}
	else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

/* Function for posting outgoing payment */
function fm_post_out_pay($bldat,$budat,$monat,$xblnr,$bktxt,$pcuoacc,$amount,$sgtxt,$zounr,$vendor,$miro,$sgtxt2)
{	
	$this->CI->session->unset_userdata('sap_post_pay_no');
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_F53_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->BLDAT_001  = $bldat;
	$fce->BLART_002  = 'KZ';
	$fce->BUKRS_003  = 'WGI1';
	$fce->BUDAT_004  = $budat;
	$fce->MONAT_005  = $monat;
	$fce->WAERS_006  = 'IDR';
	$fce->XBLNR_007  = $xblnr;
	$fce->BKTXT_008  = $bktxt;
	$fce->PARGB_009  = '1000';
	$fce->KONTO_011  = $pcuoacc;
	$fce->GSBER_012  = '1000';
	$fce->WRBTR_013  = $amount;
	$fce->SGTXT_014  = $sgtxt;
	$fce->ZUONR_015  = $zounr;
	$fce->AGKON_016  = $vendor;
	$fce->AGKOA_017  = 'K';
	$fce->XNOPS_018  = 'X';
	$fce->XPOS1_03_020  = 'X';
	$fce->SEL01_01_021  = $miro;
	$fce->ABPOS_022  = '1';
	$fce->XBLNR_023  = $xblnr;
	$fce->BKTXT_024 = $bktxt;
	$fce->PARGB_025 = '1000';
	$fce->ZUONR_026 = $zounr;
	$fce->SGTXT_027 = $sgtxt2;
	$fce->XBLNR_028 = $xblnr;
	$fce->BKTXT_029 = $bktxt;
	$fce->PARGB_030 = '1000';
	
	$fce->Call();
	
	if ($fce->GetStatus() == SAPRFC_OK) 
{
	
		 if($fce->GV_NUM != '')
		 {
			
			$this->CI->session->set_userdata('sap_post_pay_no',$fce->GV_NUM);
		 }
		 else
		 {
		  $fce->GI_RETURN->Reset();
		echo "<table border=1 bordercolor='#000000' cellpadding='0' cellspacing='0' align='center'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
		 while ( $fce->GI_RETURN->Next() ){
			if($bg==0)
           	{
			   echo"<tr style=background-color:#eeeeee;>";
			   $bg++;
           	}
            else
			{
				echo"<tr style=background-color:#;>";
				$bg--;
			}
			echo "<td>".$fce->GI_RETURN->row["TYPE"]."</td><td>".$fce->GI_RETURN->row["ID"]."</td><td>".$fce->GI_RETURN->row["MESSAGE"]."</td></tr>";
		 }
		
}
	
		
 } 
 else
 {
	
	 $fce->PrintStatus(); 
	 
 }
 
}

//Create MIRO
function fm_create_miro_oa($docdate, $pstgdate, $refdoc, $vendor, $glacc, $amount,$item_txt)
{	
	$this->CI->session->unset_userdata('sap_miro_oa_num');
	//$post_date, $gross_amount, $po_num, $migo_num, $qty
	//BAPI_INCOMINGINVOICE_CREATE
	 $sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_INCOMINGINVOICE_CREATE");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	//Input header item
		$headerdata = array();
		$headerdata["INVOICE_IND"] = '';
		$headerdata["DOC_TYPE"] = 'RE';
		$headerdata["DOC_DATE"] = $this->fm_sap_yyyymmdd($docdate);
		$headerdata["PSTNG_DATE"] = $this->fm_sap_yyyymmdd($pstgdate);
		$headerdata["BLINE_DATE"] = date('Ymd');
		$headerdata["COMP_CODE"] = 'WGI1';
		$headerdata["CURRENCY"] = 'IDR';
		$headerdata["CURRENCY_ISO"] = 'IDR';
		$headerdata["PMNTTRMS"] = 'Z01';
		$headerdata["REF_DOC_NO"] = $refdoc;
		
		$headerdata["DIFF_INV"] = $vendor;
		$headerdata["BUS_AREA"] = '1000';
	
	$fce->HEADERDATA  = $headerdata;
	   
	  //G/L Account
		    $fce->GLACCOUNTDATA->row["INVOICE_DOC_ITEM"] =  '000001';
		    $fce->GLACCOUNTDATA->row["GL_ACCOUNT"] =  $this->fm_convert_vendor($glacc);
		    $fce->GLACCOUNTDATA->row["ITEM_AMOUNT"] =  $amount;
			$fce->GLACCOUNTDATA->row["DB_CR_IND"] =  'H';
			$fce->GLACCOUNTDATA->row["COMP_CODE"] =  'WGI1';
			$fce->GLACCOUNTDATA->row["BUS_AREA"] =  '1000';
			$fce->GLACCOUNTDATA->row["ITEM_TEXT"] =  $item_txt;
			
			$fce->GLACCOUNTDATA->Append($fce->GLACCOUNTDATA->row); 
			
	 //Material Data
		    $fce->MATERIALDATA->row["INVOICE_DOC_ITEM"] =  '000001';
		    $fce->MATERIALDATA->row["MATERIAL"] =  'R101';
		    $fce->MATERIALDATA->row["ITEM_AMOUNT"] =  $amount;
			$fce->MATERIALDATA->row["DB_CR_IND"] =  'S';
			$fce->MATERIALDATA->row["QUANTITY"] =  1;
			$fce->MATERIALDATA->row["BASE_UOM"] =  'L';
			$fce->MATERIALDATA->row["BASE_UOM_ISO"] =  'L';
			$fce->MATERIALDATA->row["TAX_CODE"] =  'VN';
			$fce->MATERIALDATA->row["VAL_AREA"] =  '1000';
			
			$fce->MATERIALDATA->Append($fce->MATERIALDATA->row); 
		   
	   $fce->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->INVOICEDOCNUMBER != '')
		 	{
				$fce2->Call();
				//echo $fce->INVOICEDOCNUMBER;
				$this->CI->session->set_userdata('sap_miro_oa_num', $fce->INVOICEDOCNUMBER);	
		 	}
			else
			{
				$fce3->Call();

				$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

//Create MIRO Revisi 2
function fm_create_miro_oa2($docdate, $pstgdate, $blinedate, $refdoc, $header_txt, $vendor, $alloc, $amount,$item_txt)
{	
	$this->CI->session->unset_userdata('sap_miro_oa_num');
	//$post_date, $gross_amount, $po_num, $migo_num, $qty
	//BAPI_INCOMINGINVOICE_CREATE
	 $sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_INCOMINGINVOICE_CREATE");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	//Input header item
		$headerdata = array();
		$headerdata["INVOICE_IND"] = 'X';
		$headerdata["DOC_TYPE"] = 'RE';
		$headerdata["DOC_DATE"] = $this->fm_sap_yyyymmdd($docdate);
		$headerdata["PSTNG_DATE"] = $this->fm_sap_yyyymmdd($pstgdate);
		$headerdata["BLINE_DATE"] = $this->fm_sap_yyyymmdd($blinedate);
		$headerdata["COMP_CODE"] = 'WGI1';
		$headerdata["CURRENCY"] = 'IDR';
		$headerdata["CURRENCY_ISO"] = 'IDR';
		$headerdata["PMNTTRMS"] = 'Z01';
		$headerdata["REF_DOC_NO"] = $refdoc;
		$headerdata["HEADER_TXT"] = $header_txt;
		$headerdata["DIFF_INV"] = $vendor;
		$headerdata["GROSS_AMOUNT"] = $amount;
		$headerdata["ALLOC_NMBR"] = $alloc;
		$headerdata["ITEM_TEXT"] = $item_txt;
		$headerdata["BUS_AREA"] = '1000';
	
	$fce->HEADERDATA  = $headerdata;
	   
	 //Material Data
		    $fce->MATERIALDATA->row["INVOICE_DOC_ITEM"] =  '000001';
		    $fce->MATERIALDATA->row["MATERIAL"] =  'R101';
		    $fce->MATERIALDATA->row["ITEM_AMOUNT"] =  $amount;
			$fce->MATERIALDATA->row["DB_CR_IND"] =  'S';
			$fce->MATERIALDATA->row["QUANTITY"] =  1;
			$fce->MATERIALDATA->row["BASE_UOM"] =  'L';
			$fce->MATERIALDATA->row["BASE_UOM_ISO"] =  'L';
			$fce->MATERIALDATA->row["TAX_CODE"] =  'VN';
			$fce->MATERIALDATA->row["VAL_AREA"] =  '1000';
			
			$fce->MATERIALDATA->Append($fce->MATERIALDATA->row); 
		   
	   $fce->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK)
		{
			if($fce->INVOICEDOCNUMBER != '')
		 	{
				$fce2->Call();
				//echo $fce->INVOICEDOCNUMBER;
				$this->CI->session->set_userdata('sap_miro_oa_num', $fce->INVOICEDOCNUMBER);	
		 	}
			else
			{
				$fce3->Call();

				$fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
					
			 while ( $fce->RETURN->Next() )
			{
						if($bg==0)
					   {
					   echo"<tr style=background-color:#eeeeee;>";
					   $bg++;
					   }
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
						echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
			}
			            echo "</table>";
			}
		}
		
		else
		{
			$fce->PrintStatus();
			$sap->Close();
		}
}

//Post clearing oa
function fm_post_clear_oa($docdate, $pstgdate, $period, $ref, $header_txt, $pk, $newko,$wrbtr,$zounr1,$sgtxt1,$vendor,$glno,$zounr2,$sgtxt2)
{	

	$this->CI->session->unset_userdata('sap_clear_no_oa');

	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_F04_RLIS_1");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->BLDAT_001  = $docdate;
	$fce->BLART_002 = 'KZ';
	$fce->BUKRS_003 = 'WGI1';
	$fce->BUDAT_004 = $pstgdate;
	$fce->MONAT_005 =  $this->fm_sap_month($period);
	$fce->WAERS_006 = 'IDR';
	$fce->XBLNR_007 = $ref;
	$fce->BKTXT_008 = $header_txt;
	$fce->NEWBS_010 = $pk;
	$fce->NEWKO_011 = $newko;
	$fce->WRBTR_012 = $wrbtr;
	$fce->ZUONR_013 = $zounr1;
	$fce->SGTXT_014 = $sgtxt1;
	$fce->GSBER_015 = '1000';
	$fce->AGBUK_016 = 'WGI1';
	$fce->AGKON_017 = $vendor;
	$fce->DOCID_009 = '*';
	$fce->AGKOA_018 = 'k';
	$fce->XNOPS_019 = 'X';
	$fce->XPOS1_01_020 = '';
	$fce->XPOS1_03_021 = 'X';
	$fce->SEL01_01_022 = $glno;
	$fce->ABPOS_023 = '1';
	$fce->XBLNR_024 = $ref;
	$fce->BKTXT_025 = $header_txt;
	$fce->ZUONR_026 = $zounr2;
	$fce->SGTXT_027 = $sgtxt2;
	
	$fce->Call();
	
	if ($fce->GetStatus() == SAPRFC_OK) 
{
	
		 if($fce->GV_NUM != '')
		 {
			
			$this->CI->session->set_userdata('sap_clear_no_oa',$fce->GV_NUM);
		 }
		 else
		 {
		  $fce->GI_RETURN->Reset();
		echo "<table border=1 bordercolor='#000000' cellpadding='0' cellspacing='0' align='center'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
		 while ( $fce->GI_RETURN->Next() ){
			if($bg==0)
           	{
			   echo"<tr style=background-color:#eeeeee;>";
			   $bg++;
           	}
            else
			{
				echo"<tr style=background-color:#;>";
				$bg--;
			}
			echo "<td>".$fce->GI_RETURN->row["TYPE"]."</td><td>".$fce->GI_RETURN->row["ID"]."</td><td>".$fce->GI_RETURN->row["MESSAGE"]."</td></tr>";
		 }
		
}
	
		
 } 
 else
 {
	
	 $fce->PrintStatus(); 
	 
 }

}


//Check open period
function fm_check_open_period($period, $year)
{	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_CHK_PERIOD_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->GV_PERIOD  = sprintf('%03d',$period);
	$fce->GV_YEAR = $year;
	$fce->GV_ACCTYP = 'S';
	
	$fce->Call();
	
	if ($fce->GetStatus() == SAPRFC_OK) 
	{
	
		 if($fce->GV_NOT_OPEN == 'X')
		 {
			$error = 1;
			return $error;
		 }
		 else
		 {
			$error = 0;
		  	return $error;
		 }
		
	}
 else
 {
	 $fce->PrintStatus();  
 }

}


//Cancel transfer posting
function fm_cancel_tp($matdoc,$year,$postdate)
{
	$this->CI->session->unset_userdata('sap_cancel_tp_no');
	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("BAPI_GOODSMVT_CANCEL");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
		$fce->MATERIALDOCUMENT  = $matdoc;
		$fce->MATDOCUMENTYEAR  = $year;
		$fce->GOODSMVT_PSTNG_DATE = $this->fm_sap_yyyymmdd($postdate);
	   
	   $fce->Call();
	   $fce2->Call();
	   
	   if ($fce->GetStatus() == SAPRFC_OK) 
		{
			$this->CI->session->set_userdata('sap_cancel_tp_no',$fce->GOODSMVT_HEADRET["MAT_DOC"]);
		}
		 if($this->CI->session->userdata('sap_cancel_tp_no')=='')
		 {
			 $fce->RETURN->Reset();
			 echo "<table border=1 bordercolor='#000000' align=center cellpadding='0' cellspacing='0'><tr  bgcolor='#CCCCCC'><th>Type</th><th>ID</th><th>Message</th></tr>";
			 while ( $fce->RETURN->Next() )
				{
						if($bg==0)
						{
						echo"<tr style=background-color:#eeeeee;>";
						$bg++;
						}
						else
						{
						echo"<tr style=background-color:#;>";
						$bg--;
						}
					echo "<td>".$fce->RETURN->row["TYPE"]."</td><td>".$fce->RETURN->row["ID"]."</td><td>".$fce->RETURN->row["MESSAGE"]."</td></tr>";
				}
					echo "</table>";	
			 
			 $fce->PrintStatus();  
		 }
}

/*----------------------Ongkos Angkut----------------------------*/
function fm_add_oa($ebeln,$oa,$chid)
{	
	
	$sap = new SAPConnection();
	$sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
  
	$fce = &$sap->NewFunction ("BAPI_PO_CHANGE");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce2 = &$sap->NewFunction ("BAPI_TRANSACTION_COMMIT");
    if ($fce2 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce3 = &$sap->NewFunction ("BAPI_TRANSACTION_ROLLBACK");
    if ($fce3 == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->PURCHASEORDER = $ebeln;
	
		
/*---------------------------Ongkos Angkut------------------------*/		 
		 if($oa > 0)
		 {
			 $fce->POCONDHEADER->row["ITM_NUMBER"] = '00000';
			 $fce->POCONDHEADER->row["COND_ST_NO"] = '031';
			 $fce->POCONDHEADER->row["COND_TYPE"] = 'ZFFW';
			 $fce->POCONDHEADER->row["COND_VALUE"] = $oa;
			 $fce->POCONDHEADER->row["CURRENCY"] = 'IDR';
			 $fce->POCONDHEADER->row["CURRENCY_ISO"] = 'IDR';
			 $fce->POCONDHEADER->row["CALCTYPCON"] = 'B';
			 $fce->POCONDHEADER->row["COND_UNIT"] = 'L';
			 $fce->POCONDHEADER->row["COND_P_UNT "] = 1;
			 $fce->POCONDHEADER->row["CHANGE_ID"] = $chid; //I = Insert U = Update
			 
			 $fce->POCONDHEADER->Append($fce->POCONDHEADER->row); 
			
			 $fce->POCONDHEADERX->row["ITM_NUMBER"] = '00000';
			 $fce->POCONDHEADERX->row["COND_ST_NO"] = '031';
			 $fce->POCONDHEADERX->row["COND_TYPE"] = 'X';
			 $fce->POCONDHEADERX->row["COND_VALUE"] = 'X';
			 $fce->POCONDHEADERX->row["CURRENCY"] = 'X';
			 $fce->POCONDHEADERX->row["CALCTYPCON"] = 'X';
			 $fce->POCONDHEADERX->row["COND_UNIT"] = 'X';
			 $fce->POCONDHEADERX->row["COND_P_UNT "] = 'X';
			 $fce->POCONDHEADERX->row["CHANGE_ID"] = 'X';
			 
			$fce->POCONDHEADERX->Append($fce->POCONDHEADERX->row);
			 
		 }
	/*---------------------------Ongkos Angkut------------------------*/		 
		$fce->Call();
		
		if ($fce->GetStatus() == SAPRFC_OK) 
 		{
		//Check error status
					$fce->RETURN->Reset();
					$error = 0;
					
					 while ( $fce->RETURN->Next() )
					{
						if($fce->RETURN->row["TYPE"]=='E')
						{ 
							/*echo $fce->RETURN->row["MESSAGE"];
							echo '<br>';*/
							$error=1; 
						}
					}
					if($error == 1)
					{
						//Rollback
						$fce3->call();
					}
					else
					{
						//$_SESSION['sap_po_num'] = $ebeln;
						
						//Commit
						$fce2->call();
					}
			}
			else
			{
				$fce->PrintStatus();
			 	$sap->Close();
			}
	//return $error;		
}
/*----------------------Ongkos Angkut----------------------------*/

//Checking PO already MIRO or not
function fm_check_po_miro($ebeln)
{	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_CHECKMIRO_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->GV_EBELN  = $ebeln;
	
	$fce->Call();
	
	if ($fce->GetStatus() == SAPRFC_OK) 
	{
	
		return $fce->GV_STATUS;
		
	}
 else
 {
	 $fce->PrintStatus();  
 }

}

//Checking CPV already post g/l or not
function fm_check_gl_post($hkont, $cpdu)
{	
	$sap = new SAPConnection();
  	 $sap->Connect($this->sap_connection_string());
    if ($sap->GetStatus() == SAPRFC_OK ) $sap->Open ();
    if ($sap->GetStatus() != SAPRFC_OK ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce = &$sap->NewFunction ("YFM_CHECKGLPOST_RLIS");
    if ($fce == false ) {
       $sap->PrintStatus();
       exit;
    }
	
	$fce->GV_HKONT  = $this->fm_convert_vendor($hkont);
	$fce->GV_CPDU  = $cpdu;
	
	$fce->Call();
	
	if ($fce->GetStatus() == SAPRFC_OK) 
	{
	
		return $fce->GV_STATUS;
		
	}
 else
 {
	 $fce->PrintStatus();  
 }

}
 /*-----------------------------------SAP Function-------------------------------*/	
 
}