<?php
/*
Fungsi : Model untuk modul Cabang report
*/
class Branch_report_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Branch_model()
	{
		parent::__construct();
	}
	
/* Insialiasi nama table */

	var $table_m_op			= 'm_op';
	var $table_po			= 't_po';
	var $table_hmirocan     = 'h_miro_cancel';
	var $table_h_pcop_trf 	= 'h_pcop_trf';
	var $table_hglcancel 	= 'h_gl_cancel';
	var $table_tstb     	= 't_stb';
	var $table_m_cab		= 'm_cab';
	var $table_pc_cab		= 't_pc_cab';
	var $table_bank_bal		= 't_bankbal';
	var $table_pcuo_bal		= 't_pcbal';
	var $table_pcop_bal		= 't_pcbal_op';
	var $table_stock_bal    = 't_stockbal';

/*-----------------------PO MODEL---------------------------*/
function get_po_byidcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(t_po.postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."' and t_po.mblnr <> 0";
			$this->db->select('*');
			$this->db->from('t_po');
			$this->db->join('m_top', 'm_top.idtop = t_po.idtop');
			$this->db->where($where);
			$this->db->where('t_po.idcab',$idcab);
			$this->db->order_by('t_po.adddate', 'ASC'); 
  			return $this->db->get();
		}
/*-----------------------PO MODEL---------------------------*/

/*-----------------------MIRO HISTORY MODEL---------------------------*/

function get_list_miro($date1, $date2)
		{
			$where = "t_po.mblnr <> 0 and t_po.miro <> '' and DATE_FORMAT(t_po.miradddate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->select('m_cab.cabname,
							  t_po.ebeln,
							  t_po.miro,
							  t_po.miraddby,
							  t_po.miradddate,
							  t_po.net_price,
							  t_po.disc,
							  t_po.tax,
							  t_po.vendor,
							  t_po.quantity,
							  t_po.year,
							  t_po.addby,
							  t_po.postdate,
							  t_po.adddate'
							  
							 );
			$this->db->from('t_po');
			$this->db->join('m_cab', 'm_cab.idcab = t_po.idcab');
			$this->db->where($where); 
			$this->db->order_by('t_po.ebeln', 'DESC'); 
			$this->db->order_by('t_po.year', 'DESC'); 
			$query = $this->db->get();
			return $query;
		}
/*-----------------------MIRO HISTORY MODEL---------------------------*/
	
/*-----------------------STOCK HISTORY MODEL---------------------------*/	

function get_stock_hist_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(adddate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('adddate', 'ASC'); 
  			return $this->db->get($this->table_stock_bal);
		}

/*-----------------------STOCK HISTORY MODEL---------------------------*/	
	
/*-----------------------PC OP BALANCE MODEL---------------------------*/	

function get_pcop_bal_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(adddate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('adddate', 'ASC'); 
  			return $this->db->get($this->table_pcop_bal);
		}

/*-----------------------PC OP BALANCE MODEL---------------------------*/

/*-----------------------PC UO BALANCE MODEL---------------------------*/	

function get_pcuo_bal_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(adddate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('adddate', 'ASC'); 
  			return $this->db->get($this->table_pcuo_bal);
		}

/*-----------------------PC UO BALANCE MODEL---------------------------*/
	
/*-----------------------BANK BALANCE MODEL---------------------------*/	

function get_bank_bal_bydate_idcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(adddate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->where($where);
			$this->db->where('idcab',$idcab);
			$this->db->order_by('adddate', 'ASC'); 
  			return $this->db->get($this->table_bank_bal);
		}

/*-----------------------BANK BALANCE MODEL---------------------------*/		
	
/*-----------------------CABANG MODEL---------------------------*/	
	function get_cabang()
	{
		$where = "idcab <> '1'";
		$this->db->where($where);
  		return $this->db->get($this->table_m_cab);
	}	
	
	function get_cabang_byidcab($idcab)
	{
		$this->db->where('idcab',$idcab);
  		return $this->db->get($this->table_m_cab);
	}	
/*-----------------------CABANG MODEL END---------------------------*/	


/*-----------------------STB REPORT MODEL---------------------------*/	
function get_stb_pusat_bydate($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(t_stb.posting, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->select('m_cab.cabname,
							   m_cab.idcab,
							  t_stb.idstb,
							  t_stb.vol,
							  t_stb.qctbk,
							  t_stb.qcair,
							  t_stb.qcresidu,
							  t_stb.donumb,
							  t_stb.inf,
							  t_stb.mnfst,
							  t_stb.suppname,
							  t_stb.qct,
							  t_stb.type,
							  t_stb.adddate,
							  t_stb.posting,
							  t_stb.transname,
							  t_stb.vnumb,
							  t_stb.qcbakar,
							  t_stb.addby');
			$this->db->from('t_stb');
			$this->db->join('m_cab', 'm_cab.idcab = t_stb.idcab');
			$this->db->where($where);
			$this->db->where('t_stb.closed', 1);
			$this->db->where('t_stb.idcab',$idcab);
			$this->db->order_by('t_stb.posting', 'ASC'); 
			$query = $this->db->get();
			return $query;
		}
/*-----------------------STB REPORT MODEL END---------------------------*/	

/*-----------------------OP REPORT MODEL---------------------------*/	
function get_op_byidcab($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(m_op.postdate, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->select *
			$this->db->from('m_op');
			$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
			$this->db->join('t_po', 't_po.preq_no = m_op.prnumb');
			$this->db->join('t_stb', 't_stb.idstb = m_op.idstb');
			$this->db->where($where);
			//$this->db->where('m_op.fee' > 0);
			$this->db->where('m_op.idcab',$idcab);		
			$this->db->order_by('m_op.adddate', 'ASC'); 
			$query = $this->db->get();
			return $query;
		}
/*-----------------------OP REPORT MODEL END---------------------------*/	


/*-----------------------DELIVERY NOTE REPORT MODEL---------------------------*/	
function get_dn_pusat_bydate($date1, $date2, $idcab)
		{
			$where = "DATE_FORMAT(t_dn.posting, '%Y-%m-%d') between '".$date1."' and '".$date2."'";
			$this->db->select('m_cab.cabname,
							   m_cab.idcab,
							  t_dn.dnnumb,
							  t_dn.iddn,
							  t_dn.year,
							  t_dn.vol,
							  t_dn.mnfst,
							  t_dn.vnumb,
							  t_dn.noiso,
							  t_dn.quantity,
							  t_dn.namatrans,
							  t_dn.seal1,
							  t_dn.seal2,
							  t_dn.seal3,
							  t_dn.seal4,
							  t_dn.posting,
							  t_dn.driver,
							  t_dn.type,
							  t_dn.matdoc,
							  t_dn.inf,
							  t_dn.adddate,
							  t_dn.status,
							  t_dn.addby');
			$this->db->from('t_dn');
			$this->db->join('m_cab', 'm_cab.idcab = t_dn.idcab');
			$this->db->where($where);
			//$this->db->where('t_stb.closed', 1);
			$this->db->where('t_dn.idcab',$idcab);
			$this->db->order_by('t_dn.posting', 'ASC'); 
			$query = $this->db->get();
			return $query;
		}
/*-----------------------DELIVERY NOTE REPORT MODEL END---------------------------*/	


}