<?php
/*
Fungsi : Model untuk modul cabang
*/
class Cabang_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Cabang_model()
	{
		parent::__construct();
	}
	
/* Insialiasi nama table */

	var $table_supp	    	= 'm_supp';
	var $table_trans    	= 'm_transport';
	var $table_op			= 'm_op';
	var $table_opd			= 'm_op_detail';
	var $table_mnfst		= 'm_manifest';
	var $table_type	  		= 'm_supptype';
	var $table_pr	  		= 't_pr';
	var $table_pcbal	  	= 't_pcbal';
	var $table_saldo		= 't_stockbal';
	var $table_qa	    	= 't_qa';
	var $table_stb	    	= 't_stb';
	var $table_dn	    	= 't_dn';
	var $table_ow	        = 't_limbah';
	var $table_limbah		= 'm_limbah';
	var $table_foto			= 'm_foto';
	var $table_sj 			= 'cis.sj';
	
/*-----------------------CIS MODEL---------------------------*/
	function insert_sj_cis($cis)
	{
		$dbs =  $this->config->item('DB_CIS');
  		$dbs->insert($this->table_sj, $cis);
		
	}
	
	function update_sj_cis($no_sj,$cis)
	{
		$dbs =  $this->config->item('DB_CIS');
		$dbs->where('no_sj',$no_sj);
  		$dbs->update($this->table_sj, $cis);
	}
/*-----------------------CIS MODEL---------------------------*/

/*-----------------------SUPPLIER GROUP MODEL---------------------------*/	
	
	/* Insert supplier group */
   function add_suppgrp($suppgrp)
		{
			$this->db->insert($this->table_suppgrp, $suppgrp);
		}
		
/* List supplier group paging */
	function get_suppgrp_paging($limit, $offset)
	{
  		$this->db->get($this->table_suppgrp);
		$this->db->order_by('idgroup','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_suppgrp);
	}
	
	/* Total supplier group */
	function count_all_suppgrp()
	{
		$this->db->get($this->table_suppgrp);
		return $this->db->count_all_results($this->table_suppgrp);
	}
	
	/* Delete supplier group */
	function del_suppgrp($idgroup)
	{
		$this->db->where('idgroup', $idgroup);
		$this->db->delete($this->table_suppgrp);
		
	}
	
	/* Get data supplier group detail*/
	function get_suppgrp_detail($idgroup)
	{
		$this->db->where('idgroup', $idgroup);
		return $this->db->get($this->table_suppgrp);
	}
	
	/* Update data supplier group */
	function update_suppgrp($idgroup, $desc)
	{
		$this->db->where('idgroup',$idgroup);
		$this->db->update($this->table_suppgrp, $desc);
	}
/*-----------------------SUPPLIER GROUP MODEL---------------------------*/	

/*-----------------------SUPPLIER MODEL---------------------------*/	
	
	/* Insert supplier */
   function add_supp($supp)
		{
			$this->db->insert($this->table_supp, $supp);
		}
		
/* List supplier paging */
	function get_supp_paging($limit, $offset, $search)
	{	
		if(!empty($search)) {
  		$this->db->like('suppname',$search);
		$this->db->or_like('pic',$search);
		}
		$this->db->order_by('idsupp','ASC');
		$this->db->where('idcab', $this->session->userdata('idcab'));
		//$this->db->join('m_cab', 'm_cab.idcab = m_supp.idcab');
		//$this->db->where('m_supp.idcab', $idcab);
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_supp);
	}
	
	
	/* Total supplier */
	function count_all_supp($search)
	
	{	
		if(!empty($search)) {
  		$this->db->like('suppname',$search);
		$this->db->or_like('pic',$search);
		}
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_supp);
	}
	
	/* Delete supplier */
	function del_supp($idsupp)
	{
		$this->db->where('idsupp', $idsupp);
		$this->db->delete($this->table_supp);
		
	}
	
	/* Insert picture */
   function add_picture($foto)
		{
			$this->db->insert($this->table_foto, $foto);
		}
	
	/* Get data supplier detail*/
	function get_supp_detail($idsupp)
	{
	$this->db->where('idsupp', $idsupp);
		return $this->db->get($this->table_supp);
	}
	
	
	/* Update data supplier */
	function update_supp($idsupp, $desc)
	{
		$this->db->where('idsupp',$idsupp);
		$this->db->update($this->table_supp, $desc);
		
	}
	
	/*Cari Data Supplier*/
	function search($limit, $offset, $opt, $cari)
	{
  	
		$this->db->select('idsupp, suppname, pic, addr');
		$this->db->like($opt,$cari); 
		$this->db->order_by('idsupp','ASC');
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_supp);
	}
	/*Hitung Hasil Cari*/
	function count_all_num_rows_search($opt,$cari)
	{
		$this->db->select('idsupp, suppname, pic, addr');
		//$this->db->join('supplier_master', 'pembelian_header.id_supp = supplier_master.id_supp');
		$this->db->like($opt,$cari); 
		//$this->db->where('pembelian_header.status', 0);
		$this->db->order_by('idsupp','ASC');
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_supp);
	}
/*-----------------------SUPPLIER MODEL---------------------------*/

/*-----------------------TRANSPORTER MODEL---------------------------*/	
	
	/* Insert transporter */
   function add_trans($trans)
		{
			$this->db->insert($this->table_trans, $trans);
		}
		
/* List transporter paging */
	function get_trans_paging($limit, $offset, $search)
	{
  		if(!empty($search)) {
  		$this->db->like('name',$search);
		$this->db->or_like('pic',$search);
		}
		$this->db->order_by('idtrans','ASC');
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_trans);
	}

	/* Total transporter */
	function count_all_trans($search)
	{	
		if(!empty($search)) 
		{
  		$this->db->like('name',$search);
		$this->db->or_like('pic',$search);
		}
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_trans);
	}	
	
	
	/* Delete transporter */
	function del_trans($idtrans)
	{
		$this->db->where('idtrans', $idtrans);
		$this->db->delete($this->table_trans);
		
	}
	
	/* Get data transporter detail*/
	function get_trans_detail($idtrans)
	{
		$this->db->where('idtrans', $idtrans);
		return $this->db->get($this->table_trans);
	}
	
	/* Update data transporter */
	function update_trans($idtrans, $desc)
	{
		$this->db->where('idtrans',$idtrans);
		$this->db->update($this->table_trans, $desc);
	}
	/*Cari Data Transporter*/
	function search_trans($limit, $offset, $txt_opt_trans, $txt_cari_trans)
	{
  	
		$this->db->select('idtrans, name, pic, addr, vnumb');
		$this->db->like($txt_opt_trans,$txt_cari_trans); 
		$this->db->order_by('idtrans','ASC');
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_trans);
	}
	
	
	/*Hitung Hasil Cari*/
	function count_all_num_rows_search_trans($txt_opt_trans,$txt_cari_trans)
	{
		$this->db->select('*');
		//$this->db->join('supplier_master', 'pembelian_header.id_supp = supplier_master.id_supp');
		$this->db->like($txt_opt_trans,$txt_cari_trans); 
		//$this->db->where('pembelian_header.status', 0);
		$this->db->order_by('idtrans','ASC');
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_trans);
	}
	
/*-----------------------TRANSPORTER MODEL---------------------------*/

/*----------------------- OIL PURCHASE MODEL---------------------------*/	
	
	/* Insert op */
   function add_op($op)
		{
			$this->db->insert($this->table_op, $op);
		}
		
		
		/* Insert op detail */
   function add_opd($opd)
		{
			$this->db->insert($this->table_opd, $opd);
		}
		
		
	
		/* insert stok dan saldo*/
		function add_saldo_branch($salbal)
	{
  		$this->db->insert($this->table_saldo,$salbal);
	}
		
		/* Insert op fee */
   function add_op_fee($op_fee)
		{
			$this->db->insert($this->table_op, $op_fee);
		}
		
	/* Insert op to t_pcbal */
   function add_op_pcbal($op_pcbal)
		{
			$this->db->insert($this->table_pcbal, $op_pcbal);
		}
	
	
	/*Get list op fee*/
	function get_list_op_fee($idop)
		{
		   $this->db->select('m_cab.cabname,
		   					  m_op.suppname,
							  m_op.idcab,
							  m_op.pur,
							  m_op.fee,
							  m_op.vol,
							  m_op.inf,
							  m_op.opnumb,
							  m_op.prnumb,
							  m_op.type,
							  m_op.invoice,
							  m_op.year,
							  m_op.addby,
							  m_op.chby,
							  m_op.chdate,
							  m_op.adddate');
			$this->db->from('m_op');
			$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
			$this->db->where('m_op.idop', $idop);
			//$this->db->where('m_op.year', $year);
			$query = $this->db->get();
			return $query;
		}
		
		/* Get List Type */
function get_list_type()
	{
		return $this->db->get($this->table_opd);
	}
	
function get_list_typebyno($id)
	{
		$this->db->where('id', $id);
		return $this->db->get($this->table_opd);
	}
		
	/*Get list op Print paging*/
	function get_list_op_print_paging($idop)
		{
		   $this->db->select('m_cab.cabname,
		   					  t_po.ebeln,
							  t_po.preq_no,
		   					  m_op.suppnametax,
							  m_op.suppname,
							  m_op.transname,
							  m_op.idcab,
							  m_op.idsupp,
							  m_op.pur,
							  m_op.fee,
							  m_op.vol,
							  m_op.inf,
							  m_op.idtrans,
							  m_op.idstb,
							  m_op.opnumb,
							  m_op.prnumb,
							  m_op.type,
							  m_op.invoice,
							  m_op.year,
							  m_op.addby,
							  m_op.chby,
							  m_op.chdate,
							  m_op.adddate');
			$this->db->from('m_op');
			$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
			$this->db->join('t_po', 't_po.preq_no = m_op.prnumb');
			//$this->db->join('m_supp', 'm_supp.idsupp = m_op.idsupp');
			//$this->db->join('m_transport', 'm_transport.idtrans = m_op.idtrans');
			$this->db->where('m_op.idop', $idop);
			//$this->db->where('m_op.year', $year);
			$query = $this->db->get();
			return $query;
		}
		
		/*Get list op Print paging*/
	function get_list_op_print_paging_tax($idop)
		{
		   $this->db->select('m_cab.cabname,
		                      t_po.ebeln,
							  t_po.preq_no,
							  m_op.suppnametax,
							  m_op.suppname,
							  m_op.transname,
							  m_op.idcab,
							  m_op.idsupp,
							  m_op.pur,
							  m_op.fee,
							  m_op.vol,
							  m_op.inf,
							  m_op.idtrans,
							  m_op.idstb,
							  m_op.opnumb,
							  m_op.prnumb,
							  m_op.type,
							  m_op.invoice,
							  m_op.year,
							  m_op.addby,
							  m_op.chby,
							  m_op.chdate,
							  m_op.adddate');
			$this->db->from('m_op');
			$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
			$this->db->join('t_po', 't_po.preq_no = m_op.prnumb');
			//$this->db->join('m_transport', 'm_transport.idtrans = m_op.idtrans');
			$this->db->where('m_op.idop', $idop);
			//$this->db->where('m_op.year', $year);
			$query = $this->db->get();
			return $query;
		}
		
		/*Get list op Print paging*/
	function get_list_stb_print_paging($idstb)
		{
		   $this->db->select('m_cab.cabname,
							  t_stb.idstb,
							  t_stb.idcab,
							  t_stb.mnfst,
							  t_stb.donumb,
							  t_stb.vol,
							  t_stb.transname,
							  t_stb.suppname,
							  t_stb.inf,
							  t_stb.type,
							  t_stb.year,
							  t_stb.addby,
							  t_stb.chby,
							  t_stb.chdate,
							  t_stb.adddate,
							  t_stb.qctbk,
							  t_stb.qcair,
							  t_stb.qcbakar,
							  t_stb.qcresidu,
							  t_stb.qct');
			$this->db->from('t_stb');
			$this->db->join('m_cab', 'm_cab.idcab = t_stb.idcab');
			$this->db->where('t_stb.idstb', $idstb);
			//$this->db->where('m_op.year', $year);
			$query = $this->db->get();
			return $query;
		}

		
/* List op paging */

	function get_op_paging($limit, $offset)
	{
  		$this->db->get($this->table_op);
		$this->db->where('m_op.cancel',0);
		$this->db->where('m_op.idcab',$this->session->userdata('idcab'));
		$this->db->order_by('idop','DESC');
		$this->db->join('t_pr', 't_pr.preq_no = m_op.prnumb');
		$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
		//$this->db->join('t_po', 't_po.preq_no = m_op.prnumb');
		//$this->db->where('t_pr.preq_no', 0);
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_op);
	}
	
	//function get_op_paging_cancel($limit, $offset)
//	{
//  		$this->db->get($this->table_pr);
//		$this->db->where('closed',0);
//		$this->db->where('m_op.idcab',$this->session->userdata('idcab'));
//		$this->db->order_by('idop','DESC');
//		$this->db->join('t_pr', 't_pr.preq_no = m_op.prnumb');
//		$this->db->join('t_pr', 't_pr.preq_no = m_op.prnumb');
//		$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
//		//$this->db->where('t_pr.preq_no', 0);
//		$this->db->limit($limit, $offset);
//  		return $this->db->get($this->table_op);
//	}
	
	function get_all_op($prnumb=null,$year=null)
	{
		$this->db->get($this->table_op);
		if($prnumb!=null)
			$this->db->where('prnumb',$prnumb);
		if($year!=null)
		$this->db->where('year',$year);
		$this->db->where('cancel',0);
		$this->db->order_by('idop','DESC');
		return $this->db->get($this->table_op);
	}
	
	/* Total op */
	function count_all_op()
	{
		$this->db->get($this->table_op);
		$this->db->where('cancel', 0);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_op);
	}
	
	///* Total op cancel PR open */
//	function count_all_op_cancel()
//	{
//		$this->db->get($this->table_op);
//		$this->db->join('m_op', 'm_op.prnumb = t_pr.preq_no');
//		$this->db->where('closed', 0);
//		return $this->db->count_all_results($this->table_op);
//	}
	
	
	/* Get data op detail*/
	function get_op_detail($idop)
	{
		$this->db->where('idop', $idop);
		return $this->db->get($this->table_op);
	}
	
	/* Update data op */
	function update_op($idop, $desc)
	{
		$this->db->where('idop',$idop);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->update($this->table_op, $desc);
	}
	
	/* Get data type supplier */	
	function get_type($type)
{
		$this->db->where('idtype',$idtype);
		$this->db->update($this->table_type, $type);

	if (!empty($data_type)){
	$data_type = '<p><select name=\'type\' >';
	foreach($data_type as $data){
		$data_type .= '<option value=\''.$data.'\'>'.ucfirst(strtolower($data)).'</option>';
	}
	$data_type .= '</select></p>';
	}else{
		$data_type = '<input type="text" name="type" value='.$data.' id="type" size="60"  />';
	}
	echo $data_type;

}

/*-----------------------OIL PURCHASE MODEL---------------------------*/

/*----------------------- OTHER WASTE MODEL---------------------------*/	
	
	/* Insert Transaksi Limbah Lain */
   function add_ow($ow)
		{
			$this->db->insert($this->table_limbah, $ow);
		}
		
	
			
		/*Get list ow Print paging*/
	function get_list_ow_print_paging($idop)
		{
		   $this->db->select('m_cab.cabname,
							  m_supp.suppname,
							  m_transport.name,
							  m_op.idcab,
							  m_op.idsupp,
							  m_op.pur,
							  m_op.vol,
							  m_op.inf,
							  m_op.idtrans,
							  m_op.opnumb,
							  m_op.prnumb,
							  m_op.type,
							  m_op.invoice,
							  m_op.year,
							  m_op.addby,
							  m_op.chby,
							  m_op.chdate,
							  m_op.adddate');
			$this->db->from('m_op');
			$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
			$this->db->join('m_supp', 'm_supp.idsupp = m_op.idsupp');
			$this->db->join('m_transport', 'm_transport.idtrans = m_op.idtrans');
			$this->db->where('m_op.idop', $idop);
			//$this->db->where('m_op.year', $year);
			$query = $this->db->get();
			return $query;
		}
		

		
/* List ow paging */
	function get_ow_paging($limit, $offset)
	{
  		$this->db->get($this->table_ow);
		$this->db->order_by('ownumb','ASC');
		$this->db->join('m_cab', 'm_cab.idcab = m_op.idcab');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_op);
	}
	
	function get_all_ow($prnumb=null,$year=null){
		$this->db->get($this->table_ow);
		if($prnumb!=null)
			$this->db->where('prnumb',$prnumb);
		if($year!=null)
		$this->db->where('year',$year);
		$this->db->order_by('ownumb','ASC');
		return $this->db->get($this->table_op);
	}
	
	/* Total ow */
	function count_all_ow()
	{
		$this->db->get($this->table_ow);
		return $this->db->count_all_results($this->table_ow);
	}
	
	
	
	/* Get data ow detail*/
	function get_ow_detail($ownumb)
	{
		$this->db->where('ownumb', $ownumb);
		return $this->db->get($this->table_op);
	}
	
	/* Update data ow */
	function update_ow($ownumb, $desc)
	{
		$this->db->where('ownumb',$ownumb);
		$this->db->update($this->table_ow, $desc);
	}
	
	/*Cari Data Limbah*/
	function search_waste($limit, $offset, $txt_opt_waste, $txt_cari_waste)
	{
  	
		$this->db->select('idlimbah, namelimb, qty');
		$this->db->like($txt_opt_waste,$txt_cari_waste); 
		$this->db->order_by('idlimbah','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_limbah);
	}
	/*Hitung Hasil Cari*/
	function count_all_num_rows_search_waste($txt_opt_waste,$txt_cari_waste)
	{
		$this->db->select('idlimbah, namelimb, qty');
		//$this->db->join('supplier_master', 'pembelian_header.id_supp = supplier_master.id_supp');
		$this->db->like($txt_opt_waste,$txt_cari_waste); 
		//$this->db->where('pembelian_header.status', 0);
		$this->db->order_by('idlimbah','ASC');
		return $this->db->count_all_results($this->table_limbah);
	} 
/*-----------------------OTHER WASTE MODEL---------------------------*/


/*----------------------- QUALITY CONTROL MODEL---------------------------*/	
	
	/* Insert qa */
   function add_qa($qa)
		{
			$this->db->insert($this->table_qa, $qa);
			
			//$this->dbstats->insert('berita_acara', $qa);
		}
		
		
		/*Get list qa Print paging*/
	function get_list_qa_print_paging($limit, $offset)
		{
		   $this->db->select('m_cab.cabname,
		   					  t_qa.idba,
		   					  t_qa.idcab,
							  t_qa.qcair,
							  t_qa.qcresidu,
							  t_qa.qct,
							  t_qa.qctbk,
							  t_qa.qcbakar,
							  t_qa.inf,
							  t_qa.vol,
							  t_qa.adj,
							  t_qa.scrap,
							  t_qa.addby,
							  t_qa.adddate');
			$this->db->from('t_qa');
			$this->db->join('m_cab', 'm_cab.idcab = t_qa.idcab');
			$query = $this->db->get();
			return $query;
		}
		
///*Get list stb Print paging*/
//	function get_list_stb_print_paging($limit, $offset)
//		{
//		   $this->db->select('m_cab.cabname,
//		   					  t_stb.idstb,
//		   					  t_stb.idcab,
//							  t_stb.qcair,
//							  t_stb.qcresidu,
//							  t_stb.qct,
//							  t_stb.qctbk,
//							  t_stb.qcbakar,
//							  t_stb.inf,
//							  t_stb.vol,
//							  t_stb.addby,
//							  t_stb.adddate');
//			$this->db->from('t_stb');
//			$this->db->join('m_cab', 'm_cab.idcab = t_stb.idcab');
//			$query = $this->db->get();
//			return $query;
//		}
		
/* List qa paging */
	function get_qa_paging($limit, $offset)
	{
  		$this->db->get($this->table_qa);
		$this->db->order_by('idba','ASC');
		$this->db->where('t_qa.appmngr1', 1);
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_qa);
	}
	
	function get_all_qa($idba=null,$year=null){
		$this->db->get($this->table_qa);
		if($idba!=null)
		$this->db->where('idba',$idba);
		if($year!=null)
		$this->db->where('year',$year);
		$this->db->order_by('idba','ASC');
		return $this->db->get($this->table_qa);
	}
	
	/* Delete qa */
	function del_qa($idba)
	{
		$this->db->where('idba', $idba);
		$this->db->delete($this->table_qa);
	}
	/* Delete qa */
	function del_stb($idstb)
	{
		$this->db->where('idstb', $idstb);
		$this->db->delete($this->table_stb);
	}
	/* Total qa */
	function count_all_qa()
	{
		$this->db->get($this->table_qa);
		return $this->db->count_all_results($this->table_qa);
	}
	
	/* Get data qa detail*/
	function get_qa_detail($idba)
	{
		$this->db->where('idba', $idba);
		return $this->db->get($this->table_qa);
	}
/*======================================= Quality Model==============================================*/	


	
/*======================================= STB Model==============================================*/	
	/* Insert qa stb Penerimaan*/
   function add_stb($stb)
		{
			$this->db->insert($this->table_stb, $stb);
			
			//$this->dbstats->insert('berita_acara', $qa);
		}
	/* update STB */
   function update_stb($idstb, $desc)
		{
			$this->db->where('idstb',$idstb);
			$this->db->where('idcab', $this->session->userdata('idcab'));
			//$this->db->where('idcab', 3);
		    $this->db->update($this->table_stb, $desc);
		}		
		
	/* List stb paging */
	function get_stb_paging($limit, $offset)
	{
  		$this->db->get($this->table_stb);
		$this->db->where('idcab',$this->session->userdata('idcab'));
		$this->db->order_by('adddate','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_stb);
	}
	
	function get_all_stb($idstb=null,$year=null){
		$this->db->get($this->table_stb);
		if($idba!=null)
		$this->db->where('idstb',$idstb);
		if($year!=null) 
		$this->db->where('year',$year);
		$this->db->order_by('idstb','asc');
		return $this->db->get($this->table_stb);
	}
	
	/* Total stb */
	function count_all_stb()
	{
		$this->db->get($this->table_stb);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_stb);
	}
	
	/* Get data stb detail*/
	function get_stb_detail($idstb)
	{
		$this->db->where('idstb', $idstb);
		return $this->db->get($this->table_stb);
	}
	
	
	
	/*======================================= STB Model==============================================*/		
	
	
	
/*-----------------------QUALITY CONTROL MODEL---------------------------*/
	
/*-----------------------MANIFEST MODEL---------------------------*/	
	
	/* Insert Manifest */
   function add_mnfst($mnfst)
		{
			$this->db->insert($this->table_mnfst, $mnfst);
		}
		
/* List Manifest paging */
	function get_mnfst_paging($limit, $offset)
	{
  		$this->db->get($this->table_mnfst);
		$this->db->order_by('idmnfst','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_mnfst);
	}
	
	/* Total Manifest */
	function count_all_mnfst()
	{
		$this->db->get($this->table_mnfst);
		return $this->db->count_all_results($this->table_mnfst);
	}
	
	/* Delete Manifest */
	function del_mnfst($idmnfst)
	{
		$this->db->where('idmnfst', $idmnfst);
		$this->db->delete($this->table_mnfst);
		
	}
	
	/* Get data Manifest detail*/
	function get_mnfst_detail($idmnfst)
	{
		$this->db->where('idmnfst', $idmnfst);
		return $this->db->get($this->table_mnfst);
	}
	
	/* Update data Manifest */
	function update_mnfst($idmnfst, $desc)
	{
		$this->db->where('idmnfst',$idmnfst);
		$this->db->update($this->table_mnfst, $desc);
	}
	
	
/*-----------------------MANIFEST MODEL---------------------------*/


/*----------------------- DELIVERY NOTE MODEL---------------------------*/	
	
	/* Insert dn */
   function add_dn($dn)
		{
			$this->db->insert($this->table_dn, $dn);
		}
		
		
		/*Get list dn Print paging*/
	function get_list_dn_print_paging($iddn, $idcab, $year)
		{
  		$this->db->where('iddn', $iddn);
		$this->db->where('idcab', $idcab);
		$this->db->where('year', $year);
		return $this->db->get($this->table_dn);
	}
	
/*===============================================================================================================================		
/* List dn paging */
	function get_dn_paging($idcab,$limit, $offset)

	{
			$this->db->select('m_transport.name,
		   					  m_cab.cabname,
							  t_dn.iddn,
		   					  t_dn.dnnumb,
							  t_dn.vnumb,
							  t_dn.type,
							  t_dn.noiso,
		   					  t_dn.idcab,
							  t_dn.vol,
							  t_dn.mnfst,
							  t_dn.quantity,
							  t_dn.driver,
							  t_dn.eta,
							  t_dn.year,
							  t_dn.inf,
							  t_dn.seal1,
							  t_dn.seal2,
							  t_dn.seal3,
							  t_dn.seal4,
							  t_dn.seal5,
							  t_dn.seal6,
							  t_dn.addby,
							  t_dn.adddate'
							 );
			$this->db->from('t_dn');
			$this->db->join('m_cab', 'm_cab.idcab = t_dn.idcab');
			$this->db->join('m_transport', 'm_transport.idtrans = t_dn.idtrans');
			//$this->db->where('idcab', $this->session->userdata('idcab'));
			$this->db->where('t_dn.idcab', $idcab);
			$this->db->where('t_dn.matdoc_cancel', '');  
			$this->db->order_by('t_dn.iddn','DESC');
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}

	function get_all_dn($dnnumb=null,$year=null){
		$this->db->get($this->table_dn);
		if($dnnumb!=null)
			$this->db->where('dnnumb',$dnnumb);
		if($year!=null)
		$this->db->where('year',$year);
		$this->db->where('matdoc_cancel', ''); 
		$this->db->order_by('dnnumb','ASC');
		return $this->db->get($this->table_dn);
	}
	
	/* Total dn */
	function count_all_dn($idcab)
		{
			$this->db->select('m_transport.name,
		   					  m_cab.cabname,
		   					  t_dn.dnnumb,
							  t_dn.vnumb,
							  t_dn.type,
							  t_dn.noiso,
		   					  t_dn.idcab,
							  t_dn.vol,
							  t_dn.mnfst,
							  t_dn.quantity,
							  t_dn.driver,
							  t_dn.eta,
							  t_dn.year,
							  t_dn.inf,
							  t_dn.seal1,
							  t_dn.seal2,
							  t_dn.seal3,
							  t_dn.seal4,
							  t_dn.seal5,
							  t_dn.seal6,
							  t_dn.addby,
							  t_dn.adddate'
							 
							 );
			$this->db->from('t_dn');
			$this->db->join('m_cab', 'm_cab.idcab = t_dn.idcab');
			$this->db->join('m_transport', 'm_transport.idtrans = t_dn.idtrans');
			//$this->db->where('idcab', $this->session->userdata('idcab'));
			$this->db->where('t_dn.idcab', $idcab); 
			$this->db->order_by('t_dn.iddn','ASC');
			$query = $this->db->get();
			return $query->num_rows;
		}
	
	
	/* Delete dn */
	function del_dn($dnnumb)
	{
		$this->db->where('dnnumb', $dnnumb);
		$this->db->delete($this->table_dn);
		
	}
	
	/* Get data dn detail*/
	function get_dn_detail($dnnumb)
	{
		$this->db->where('dnnumb', $dnnumb);
		$this->db->where('table_dn.idcab',$this->session->userdata('idcab'));
		return $this->db->get($this->table_dn);
	}
	
	function get_sealnumb()
   {
        $result = array();
        $SQL="SELECT * FROM group_unit_kerja";
        $array_keys_values =  $this->db->query($SQL);
        foreach ($array_keys_values->result() as $row)
        {
            $result[0] = 'Pilih Kategori Unit Kerja';
            $result[base_url().'admin/detilUnitKerja/'.$row->id_group]= $row->nama_group;
        }
        return $result;
        $this->db->free_result();
   }
	
/*-----------------------DELIVERY NOTE MODEL---------------------------*/


/*-----------------------PR MODEL---------------------------*/
/*Get list PR count available*/
function get_list_pr_av($idcab,$open)
		{
			$this->db->select('m_cab.cabname,
							  t_pr.preq_no,
							  t_pr.c_amt_bapi,
							  t_pr.quantity,
							  t_pr.year,
							  t_pr.closed,
							  t_pr.addby,
							  t_pr.adddate'
							 );
			$this->db->from('t_pr');
			$this->db->join('m_cab', 'm_cab.idcab = t_pr.idcab');
			$this->db->where('t_pr.idcab', $idcab); 
			$this->db->where('t_pr.open', $open);
			//$this->db->where('t_pr.idtop', 1); 
			//$this->db->where('t_pr.closed', 0);
			$query = $this->db->get();
			return $query->num_rows;
		}
		
		
/*-----------------------PR MODEL---------------------------*/



/*-----------------------STB MODEL---------------------------*/
/*Get list stb count available*/
function get_list_stb_av($idcab,$open)
		{
			$this->db->select('m_cab.cabname,
							  t_stb.preq_no,
							  t_stb.c_amt_bapi,
							  t_stb.quantity,
							  t_stb.year,
							  t_stb.closed,
							  t_stb.addby,
							  t_stb.adddate'
							 );
			$this->db->from('t_stb');
			$this->db->join('m_cab', 'm_cab.idcab = t_stb.idcab');
			$this->db->where('t_stb.idcab', $idcab); 
			$this->db->where('t_stb.open', $open); 
			//$this->db->where('t_pr.closed', 0);
			$query = $this->db->get();
			return $query->num_rows;
		}
/*-----------------------STB MODEL---------------------------*/


/*----------------------- BRANCH MANAGER MODEL---------------------------*/	
	
	/* Insert qa */
   function manager_add_qa($ba)
		{
			$this->db->insert($this->table_qa, $qa);
			
			//$this->dbstats->insert('berita_acara', $qa);
		}
		
		
		/*Get list qa Print paging*/
	function get_list_manager_qa_print_paging($limit, $offset)
		{
		   $this->db->select('t_qa.idba,
		   					  t_qa.idcab,
							  t_qa.qcair,
							  t_qa.qcresidu,
							  t_qa.qct,
							  t_qa.qctbk,
							  t_qa.qcbakar,
							  t_qa.inf,
							  t_qa.vol,
							  t_qa.adj,
							  t_qa.scrap,
							  t_qa.addby,
							  t_qa.adddate');
			$this->db->from('t_qa');
			
			$this->db->join('m_cab', 'm_cab.idcab = t_qa.idcab');
			$query = $this->db->get();
			return $query;
		}
		

		
/* List qa paging */
	function get_manager_qa_paging($limit, $offset)
	{
  		$this->db->get($this->table_qa);
		$this->db->where('appmngr1',0);
		$this->db->order_by('idba','ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_qa);
	}
	
	function get_all_manager_qa($idba=null,$year=null){
		$this->db->get($this->table_qa);
		if($idba!=null)
			$this->db->where('idba',$idba);
		if($year!=null)
		$this->db->where('year',$year);
		$this->db->order_by('idba','ASC');
		return $this->db->get($this->table_qa);
	}
	
	/* Total qa */
	function count_all_manager_qa()
	{
		$this->db->get($this->table_qa);
		return $this->db->count_all_results($this->table_qa);
	}
	
	/* Delete qa */
	function del_manager_qa($idba)
	{
		$this->db->where('idba', $idba);
		$this->db->delete($this->table_qa);
		
	}
	
	/* Get data qa detail*/
	function get_manager_qa_detail($idba)
	{
		$this->db->where('idba', $idba);
		return $this->db->get($this->table_qa);
	}
	//update qa
function update_qa($idqa, $year, $ba)
	{
		$this->db->where('idqa', $idqa);
		$this->db->where('year', $year);
		$this->db->update($this->table_qa, $ba);
	}
	
	
/*-----------------------BRANCH MANAGER MODEL---------------------------*/

}