<?php
/*
Fungsi : Model Perijinan
Create By : Rony
Date : 11-03-2014

Last Change By :
Last Date Change :
*/
class Perijinan_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Perijinan_model()
	{
		parent::__construct();
	} 
	
	/* Insialiasi nama table */
	var $table_group			= 'group';
	var $table_grouping			= 'm_cab';
	var $table_reminder			= 'reminder_events';
	
	
	/* =========== Model Master Data Perijinan ==========*/
	
	/* Insert data perijinan */
   		function add_perijinan($perijinan)
		{
			$this->db->insert($this->table_group, $perijinan);
		}
		
	/* Get Data Group */
	function get_group()
	{
		$this->db->select('*');
		$query = $this->db->get($this->table_group);
  		return $query;
	}
	
	/* Get Data Master Group */
	function get_groupmaster($id)
	{
		$this->db->select('*');
		$this->db->where('id',$id);
		$query = $this->db->get($this->table_group);
  		return $query;
	}
	
	/* Get Data Group */
	function get_grouping()
	{
		$this->db->select('*');
		$query = $this->db->get($this->table_grouping);
  		return $query;
	}
	
	/* Get Data Group By User */
	function get_groupby_user()
	{
		$this->db->select('*');
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$query = $this->db->get($this->table_grouping);
  		return $query;
	}
	
	/* List perijinan paging */
	function get_paging_masterperijinan($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('id',$search);
		$this->db->or_like('ket_group',$search);
		}
		$this->db->order_by('id', 'ASC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_group);
		
	}
	
	/* Total data perijinan */
	function count_rows_masterperijinan()
	{
		if(!empty($search)) {
  		$this->db->like('id',$search);
		$this->db->or_like('ket_group',$search);
		}
		$this->db->order_by('id','ASC');
		return $this->db->count_all_results($this->table_group);
	}
	
	
	/* Update Master Data Perijinan */
	function update_masterperijinan($id, $group)
	{
		$this->db->where('id', $id);
		$this->db->update($this->table_group, $group);
	}
	
	/* ================================================= */
	
	
	/* =========== Model Data Perijinan Reminder ==========*/
	
	/* Insert data perijinan */
   		function add_reminder($perijinan)
		{
			$this->db->insert($this->table_reminder, $perijinan);
		}
	
	/* List perijinan paging Admin */
	function get_paging_perijinan_admin($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Super Admin*/
	function count_rows_perijinan_admin()
	{
		if(!empty($search)){
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Super User */
	function get_paging_perijinan_user($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan User */
	function count_rows_perijinan_user()
	{
		if(!empty($search)){
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Yang Akan Datang oleh Admin */
	function get_paging_next_perijinan_admin($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Yang Akan Datang oleh Admin */
	function count_rows_next_perijinan_admin()
	{
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Yang Akan Datang oleh User */
	function get_paging_next_perijinan_user($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Yang Akan Datang Oleh User */
	function count_rows_next_perijinan_user()
	{
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Expired Admin */
	function get_paging_last_perijinan_admin($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Expired */
	function count_rows_last_perijinan_admin()
	{
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Expired User */
	function get_paging_last_perijinan_user($limit, $offset)
	{		
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Expired User */
	function count_rows_last_perijinan_user()
	{
		if(!empty($search)) {
  		$this->db->like('reminder_events.nama',$search);
		}
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* Get Data Perijinan */
	function get_data($id)
	{
		$this->db->select('*');
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('reminder_id', $id);
		return $this->db->get($this->table_reminder);
	}
	
	/* Update Master Data Perijinan */
	function update_perijinan($id, $data)
	{
		$this->db->where('reminder_id', $id);
		$this->db->update($this->table_reminder, $data);
	}
	
	// =================================== Group By ==========================================
	
	/* List perijinan paging Group By Admin */
	function get_list_paging_perijinan_groupby_admin($limit, $offset, $group, $jenis)
	{		
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Group By Admin */
	function count_rows_list_perijinan_groupby_admin($group, $jenis)
	{
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Group By User */
	function get_list_paging_perijinan_groupby_user($limit, $offset, $group, $jenis)
	{		
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Group By User */
	function count_rows_list_perijinan_groupby_user($group, $jenis)
	{
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	
	/* List perijinan paging Akan Datang Group By Admin */
	function get_next_paging_perijinan_groupby_admin($limit, $offset, $group, $jenis)
	{		
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Akan Datang Group By Admin */
	function count_rows_next_perijinan_groupby_admin($group, $jenis)
	{
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Akan Datang Group By User */
	function get_next_paging_perijinan_groupby_user($limit, $offset, $group, $jenis)
	{		
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Akan Datang Group By User */
	function count_rows_next_perijinan_groupby_user($group, $jenis)
	{
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date >', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	
	/* List perijinan paging Expired Group By Admin */
	function get_last_paging_perijinan_groupby_admin($limit, $offset, $group, $jenis)
	{		
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Expired Group By Admin */
	function count_rows_last_perijinan_groupby_admin($group, $jenis)
	{
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* List perijinan paging Expired Group By User */
	function get_last_paging_perijinan_groupby_user($limit, $offset, $group, $jenis)
	{		
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id', 'DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_reminder);
		
	}
	
	/* Total data perijinan Expired Group By User */
	function count_rows_last_perijinan_groupby_user($group, $jenis)
	{
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('exp_date <', date('Y-m-d'));
		$this->db->where('reminder_events.idcab', $group);
		$this->db->where('reminder_events.id', $jenis);
		$this->db->where('reminder_events.idcab', $this->session->userdata('idcab'));
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->order_by('reminder_events.reminder_id','DESC');
		return $this->db->count_all_results($this->table_reminder);
	}
	
	/* ==================================================== */

	
	/* ============= Model Data Notifikasi =============*/

	/* Total Data Reminder*/
	function count_reminder()
	{	
		$this->db->select('*');
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('reminder_date', date('Y-m-d'));
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->or_where('reminder_date2', date('Y-m-d'));
		$this->db->or_where('reminder_date3', date('Y-m-d'));
		return $this->db->count_all_results($this->table_reminder);
	}
	
	function count_expired()
	{	
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->where('reminder_events.stat_delete', 0);
		$this->db->where('exp_date', date('Y-m-d'));
		return $this->db->count_all_results($this->table_reminder);
	}

	/* ================================================= */
	
	/* ==================== Report Model ================== */
	
	/* get_report_perijinan */
	function get_report_perijinan($dept)
	{
		$this->db->select('*');
		$this->db->join('group', 'reminder_events.id = group.id');
		$this->db->join('m_cab', 'reminder_events.idcab = m_cab.idcab');
		$this->db->where('reminder_events.idcab',$dept);
		$query = $this->db->get($this->table_reminder);
  		return $query;
	}
	
}