<?php
/*
Fungsi : Model untuk modul branch
*/
class Reflog_model extends CI_Model {
	/**
	 * Constructor
	 */
	function Reflog_model()
	{
		parent::__construct();
		$this->default2 = $this->load->database('default2', TRUE);
	}
	
/* Insialiasi nama table */

	var $table_ba				= 'berita_acara';
	


/*-------------BERITA ACARA MODEL---------------------*/		
/*Get list BA count*/
	function viewSTBA($limit, $offset, $search)
	{
		if(!empty($search))
		{
			if($search == '99')
			{
				$this->db->order_by('idstba','DESC');
				$this->db->limit($limit, $offset);
		  		return $this->db->get('t_stba');
			} else
			{
				$this->db->like('idcab',$search);
				$this->db->order_by('idstba','DESC');
				$this->db->limit($limit, $offset);
		  		return $this->db->get('t_stba');
			}
		} else
		{
			$this->db->order_by('idstba','DESC');
			$this->db->limit($limit, $offset);
	  		return $this->db->get('t_stba');
		}
	}

	function countSTBA($search)
	{	
		if(!empty($search))
		{
			if($search == '99')
			{
				return $this->db->count_all_results('t_stba');		
			} else
			{
				$this->db->like('idcab',$search);
				return $this->db->count_all_results('t_stba');
			}
		} else
		{
			return $this->db->count_all_results('t_stba');
		}
	}

	function viewBeritaAcaraBaru($limit, $offset, $search)
	{
		$this->db->where('status_geocoll', '0');
		if(!empty($search))
		{
			$this->db->like('id_ba',$search);
		}
		$this->db->order_by('id','DESC');
		$this->db->limit($limit, $offset);
  		return $this->db->get('berita_acara');
	}

	function countBeritaAcaraBaru($search)
	{	
		$this->db->where('status_geocoll', '0');
		if(!empty($search))
		{
			$this->db->like('id_ba',$search);
		}
		return $this->db->count_all_results('berita_acara');
	}

	function viewBeritaAcara($limit, $offset, $search)
	{
		//$this->default2->where('status_approval', '1');
		//$this->default2->where('status_approval_qc', '1');
		$this->default2->where('status_approval_ppic', '1');
		if(!empty($search))
		{
			$this->default2->like('id_ba',$search);
		}
		$this->default2->order_by('id','DESC');
		$this->default2->limit($limit, $offset);
  		return $this->default2->get('berita_acara');
	}

	function countBeritaAcara($search)
	{	
		//$this->default2->where('status_approval', '1');
		//$this->default2->where('status_approval_qc', '1');
		$this->default2->where('status_approval_ppic', '1');
		if(!empty($search))
		{
			$this->default2->like('id_ba',$search);
		}
		return $this->default2->count_all_results('berita_acara');
	}

	function getNamaCabangFromSJ($no_sj)
	{
		$this->default2->where('no_sj', $no_sj);
		$id_cab = $this->default2->get('sj')->row('id_cab');
		$this->default2->where('id_cab', $id_cab);
		return $this->default2->get('kntr_cab')->row('nama_cab');
	}

	function getNamaSupplier($id_supp)
	{
		$this->default2->where('id_sup', $id_supp);
		return $this->default2->get('supp')->row('nama_supp');
	}

	function getBeritaAcaraByIDBA($id_ba)
	{
		$this->default2->where('id_ba', $id_ba);
		return $this->default2->get('berita_acara');
	}

function get_list_stb_count($idcab,$closed)
		{
			$this->db->select('m_cab.cabname,
							  t_stb.idstb,
							  t_stb.type,
							  t_stb.vol,
							  t_stb.year,
							  t_stb.closed,
							  t_stb.addby,
							  t_stb.adddate'
							 );
			$this->db->from('t_stb');
			$this->db->join('m_cab', 'm_cab.idcab = t_stb.idcab');
			$this->db->where('t_stb.idcab', $idcab); 
			$this->db->where('t_stb.closed', $closed); 
			$query = $this->db->get();
			return $query->num_rows;
		}
/*Cari Data*/
	function search_stb($limit, $offset, $cari)
	{  	
		$this->db->select('idstb, type, donumb, mnfst, vol, idsupp, suppname, idtrans, transname, vnumb, year');
		
		$this->db->order_by('idstb','ASC');
		$this->db->where('closed', 0);
		$this->db->where('idtop', 0);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_stb);
	}
	
	/*Cari Data*/
	function search_stb_op($limit, $offset, $cari)
	{  	
		$this->db->select('idstb, type, donumb, mnfst, vol, idsupp, suppname, idtrans, transname, vnumb, year');
		
		$this->db->order_by('idstb','ASC');
		$this->db->where('closed', 0);
		$this->db->where('idtop', 0);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_stb);
	}
	
	function search_stb_credit($limit, $offset, $cari)
	{  	
		$this->db->select('t_stb.idstb, t_stb.type, t_stb.donumb, t_stb.mnfst, t_stb.vol, t_stb.idsupp, t_stb.suppname, t_stb.idtrans, t_stb.transname, t_stb.vnumb, t_stb.year, m_supp.codevendor');
		$this->db->from('t_stb');
		$this->db->join('m_supp', 'm_supp.idsupp = t_stb.idsupp');
		$this->db->order_by('t_stb.idstb','ASC');
		$this->db->where('t_stb.closed', 0);
		$this->db->where('t_stb.idtop', 1);
		$this->db->where('t_stb.idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		$query = $this->db->get();
	    return $query;
	}
	
/*Get list stb count*/
function get_list_stb_credit_count()
		{
			$this->db->select('t_stb.idstb, t_stb.type, t_stb.donumb, t_stb.mnfst, t_stb.vol, t_stb.idsupp, t_stb.suppname, t_stb.idtrans, t_stb.transname, t_stb.vnumb, t_stb.year, m_supp.codevendor');
		$this->db->from('t_stb');
		$this->db->join('m_supp', 'm_supp.idsupp = t_stb.idsupp');
		$this->db->order_by('t_stb.idstb','ASC');
		$this->db->where('t_stb.closed', 0);
		$this->db->where('t_stb.idtop', 1);
		$this->db->where('t_stb.idcab', $this->session->userdata('idcab'));
			$query = $this->db->get();
			return $query->num_rows;
		}
			
//STB CREDIT PUSAT	
	function search_stb_credit_pusat($limit, $offset, $cari)
	{  	
		$this->db->select('idstb, type, donumb, mnfst, vol, idsupp, suppname, idtrans, transname, vnumb, year');
		
		$this->db->order_by('idstb','ASC');
		$this->db->where('closed', 0);
		$this->db->where('idtop', 2);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		$this->db->limit($limit, $offset);
  		return $this->db->get($this->table_stb);
	}
	
/*Hitung Hasil Cari*/
	function count_all_ba($cari)
	{
		$this->db->select('idstb, vol, closed, year');
		
		$this->db->order_by('idstb','ASC');
		$this->db->where('closed', 0);
		$this->db->where('idcab', $this->session->userdata('idcab'));
		return $this->db->count_all_results($this->table_stb);
	}		
/*-------------STB MODEL---------------------*/	
	
/*-------------PETTY CASH / CPV MODEL---------------------*/	

/*Get PC by No. PR & Year*/
 function get_pc_bynoyear($nopc, $year, $idcab)
	{
  		$this->db->where('nopc', $nopc);
		$this->db->where('year', $year);
		$this->db->where('idcab', $idcab);
		return $this->db->get($this->table_pc_cab);
	}	
	
	/*Add CPV*/
  function add_cpv($cpv)
	{
  		$this->db->insert($this->table_pc_cab,$cpv);
	}
	
	/*Add branch petty cash*/
  function add_pc_branch($pcbal)
	{
  		$this->db->insert($this->table_pcbal,$pcbal);
	}

/*Add branch petty cash operasional*/
  function add_pcopr_branch($pcbalop)
	{
  		$this->db->insert($this->table_pcbal_op,$pcbalop);
	}

/*Get list CPV*/
	function get_list_cpv($idcab,$limit, $offset)
		{
			$this->db->select('m_cab.cabname,
							  t_pc_cab.nopc,
							  m_pc_typ.desc as pcdesc,
							  t_pc_cab.nopcform,
							  t_pc_cab.amount,
							  t_pc_cab.desc,
							  t_pc_cab.year,
							  t_pc_cab.addby,
							  t_pc_cab.adddate,
							  t_pc_cab.idcab,'
							 );
			$this->db->from('t_pc_cab');
			$this->db->join('m_cab', 'm_cab.idcab = t_pc_cab.idcab');
			$this->db->join('m_pc_typ', 'm_pc_typ.idpctyp = t_pc_cab.pctyp');
			$this->db->where('t_pc_cab.idcab', $idcab); 
			$this->db->order_by('t_pc_cab.nopc', 'ASC'); 
			$this->db->order_by('t_pc_cab.year', 'ASC'); 
			$this->db->limit($limit, $offset);
			$query = $this->db->get();
			return $query;
		}
/*Get list CPV count*/
function get_list_cpv_count($idcab)
		{
			$this->db->select('m_cab.cabname,
							  t_pc_cab.nopc,
							  t_pc_cab.nopcform,
							  t_pc_cab.amount,
							  t_pc_cab.desc,
							  t_pc_cab.year,
							  t_pc_cab.addby,
							  t_pc_cab.adddate'
							 );
			$this->db->from('t_pc_cab');
			$this->db->join('m_cab', 'm_cab.idcab = t_pc_cab.idcab');
			$this->db->join('m_pc_typ', 'm_pc_typ.idpctyp = t_pc_cab.pctyp');
			$this->db->where('t_pc_cab.idcab', $idcab); 
			$this->db->order_by('t_pc_cab.nopc', 'ASC'); 
			$this->db->order_by('t_pc_cab.year', 'ASC'); 
			$query = $this->db->get();
			return $query->num_rows;
		}
/*-------------PETTY CASH / CPV MODEL---------------------*/

}