﻿//  This file is part of the jQuery formatCurrency Plugin.
//
//    The jQuery formatCurrency Plugin is free software: you can redistribute it
//    and/or modify it under the terms of the GNU General Public License as published 
//    by the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.

//    The jQuery formatCurrency Plugin is distributed in the hope that it will
//    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
//    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License along with 
//    the jQuery formatCurrency Plugin.  If not, see <http://www.gnu.org/licenses/>.

(function($) {

	$.formatCurrency.regions['af-ZA'] = {
		symbol: 'R',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['am-ET'] = {
		symbol: 'ETB',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-AE'] = {
		symbol: 'د.إ.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-BH'] = {
		symbol: 'د.ب.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-DZ'] = {
		symbol: 'د.ج.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-EG'] = {
		symbol: 'ج.م.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-IQ'] = {
		symbol: 'د.ع.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-JO'] = {
		symbol: 'د.ا.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-KW'] = {
		symbol: 'د.ك.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-LB'] = {
		symbol: 'ل.ل.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-LY'] = {
		symbol: 'د.ل.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-MA'] = {
		symbol: 'د.م.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-OM'] = {
		symbol: 'ر.ع.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-QA'] = {
		symbol: 'ر.ق.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-SA'] = {
		symbol: 'ر.س.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-SY'] = {
		symbol: 'ل.س.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-TN'] = {
		symbol: 'د.ت.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ar-YE'] = {
		symbol: 'ر.ي.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['arn-CL'] = {
		symbol: '$',
		positiveFormat: '%s %n',
		negativeFormat: '-%s %n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['as-IN'] = {
		symbol: 'ট',
		positiveFormat: '%n%s',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['az-Cyrl-AZ'] = {
		symbol: 'ман.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['az-Latn-AZ'] = {
		symbol: 'man.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['ba-RU'] = {
		symbol: 'һ.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['be-BY'] = {
		symbol: 'р.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['bg-BG'] = {
		symbol: 'лв',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['bn-BD'] = {
		symbol: '৳',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['bn-IN'] = {
		symbol: 'টা',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['bo-CN'] = {
		symbol: '¥',
		positiveFormat: '%s%n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['br-FR'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['bs-Cyrl-BA'] = {
		symbol: 'КМ',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['bs-Latn-BA'] = {
		symbol: 'KM',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['ca-ES'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['co-FR'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['cs-CZ'] = {
		symbol: 'Kč',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['cy-GB'] = {
		symbol: '£',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['da-DK'] = {
		symbol: 'kr',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['de-AT'] = {
		symbol: '€',
		positiveFormat: '%s %n',
		negativeFormat: '-%s %n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['de-CH'] = {
		symbol: 'SFr.',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: '\'',
		groupDigits: true
	};

	$.formatCurrency.regions['de-DE'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['de-LI'] = {
		symbol: 'CHF',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: '\'',
		groupDigits: true
	};

	$.formatCurrency.regions['de-LU'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['de'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['dsb-DE'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['dv-MV'] = {
		symbol: 'ރ.',
		positiveFormat: '%n %s',
		negativeFormat: '%n %s-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['el-GR'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['en-029'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-AU'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-BZ'] = {
		symbol: 'BZ$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-CA'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-GB'] = {
		symbol: '£',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-IE'] = {
		symbol: '€',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-IN'] = {
		symbol: 'Rs.',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-JM'] = {
		symbol: 'J$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-MY'] = {
		symbol: 'RM',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-NZ'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-PH'] = {
		symbol: 'Php',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-SG'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-TT'] = {
		symbol: 'TT$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-US'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-ZA'] = {
		symbol: 'R',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['en-ZW'] = {
		symbol: 'Z$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-AR'] = {
		symbol: '$',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-BO'] = {
		symbol: '$b',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-CL'] = {
		symbol: '$',
		positiveFormat: '%s %n',
		negativeFormat: '-%s %n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-CO'] = {
		symbol: '$',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-CR'] = {
		symbol: '₡',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-DO'] = {
		symbol: 'RD$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-EC'] = {
		symbol: '$',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-ES'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-GT'] = {
		symbol: 'Q',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-HN'] = {
		symbol: 'L.',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-MX'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-NI'] = {
		symbol: 'C$',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-PA'] = {
		symbol: 'B/.',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-PE'] = {
		symbol: 'S/.',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-PR'] = {
		symbol: '$',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-PY'] = {
		symbol: 'Gs',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-SV'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-US'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['es-UY'] = {
		symbol: '$U',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es-VE'] = {
		symbol: 'Bs',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['es'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['et-EE'] = {
		symbol: 'kr',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: '.',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['eu-ES'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['fa-IR'] = {
		symbol: 'ريال',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '/',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['fi-FI'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['fil-PH'] = {
		symbol: 'PhP',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['fo-FO'] = {
		symbol: 'kr',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['fr-BE'] = {
		symbol: '€',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['fr-CA'] = {
		symbol: '$',
		positiveFormat: '%n %s',
		negativeFormat: '(%n %s)',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['fr-CH'] = {
		symbol: 'SFr.',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: '\'',
		groupDigits: true
	};

	$.formatCurrency.regions['fr-FR'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['fr-LU'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['fr-MC'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['fr'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['fy-NL'] = {
		symbol: '€',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['ga-IE'] = {
		symbol: '€',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['gl-ES'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['gsw-FR'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['gu-IN'] = {
		symbol: 'રૂ',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ha-Latn-NG'] = {
		symbol: 'N',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['he-IL'] = {
		symbol: '₪',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['hi-IN'] = {
		symbol: 'रु',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['hr-BA'] = {
		symbol: 'KM',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['hr-HR'] = {
		symbol: 'kn',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['hsb-DE'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['hu-HU'] = {
		symbol: 'Ft',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['hy-AM'] = {
		symbol: 'դր.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['id-ID'] = {
	/*	symbol: 'Rp',*/
		symbol: '',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['ig-NG'] = {
		symbol: 'N',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ii-CN'] = {
		symbol: '¥',
		positiveFormat: '%s%n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['is-IS'] = {
		symbol: 'kr.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['it-CH'] = {
		symbol: 'SFr.',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: '\'',
		groupDigits: true
	};

	$.formatCurrency.regions['it-IT'] = {
		symbol: '€',
		positiveFormat: '%s %n',
		negativeFormat: '-%s %n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['it'] = {
		symbol: '€',
		positiveFormat: '%s %n',
		negativeFormat: '-%s %n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['iu-Cans-CA'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['iu-Latn-CA'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ja-JP'] = {
		symbol: '¥',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ja'] = {
		symbol: '¥',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ka-GE'] = {
		symbol: 'Lari',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['kk-KZ'] = {
		symbol: 'Т',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '-',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['kl-GL'] = {
		symbol: 'kr.',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['km-KH'] = {
		symbol: '៛',
		positiveFormat: '%n%s',
		negativeFormat: '-%n%s',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['kn-IN'] = {
		symbol: 'ರೂ',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ko-KR'] = {
		symbol: '₩',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['kok-IN'] = {
		symbol: 'रु',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ky-KG'] = {
		symbol: 'сом',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: '-',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['lb-LU'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['lo-LA'] = {
		symbol: '₭',
		positiveFormat: '%n%s',
		negativeFormat: '(%n%s)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['lt-LT'] = {
		symbol: 'Lt',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['lv-LV'] = {
		symbol: 'Ls',
		positiveFormat: '%s %n',
		negativeFormat: '-%s %n',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['mi-NZ'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['mk-MK'] = {
		symbol: 'ден.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['ml-IN'] = {
		symbol: 'ക',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['mn-MN'] = {
		symbol: '₮',
		positiveFormat: '%n%s',
		negativeFormat: '-%n%s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['mn-Mong-CN'] = {
		symbol: '¥',
		positiveFormat: '%s%n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['moh-CA'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['mr-IN'] = {
		symbol: 'रु',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ms-BN'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['ms-MY'] = {
		symbol: 'R',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['mt-MT'] = {
		symbol: 'Lm',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['nb-NO'] = {
		symbol: 'kr',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['ne-NP'] = {
		symbol: 'रु',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['nl-BE'] = {
		symbol: '€',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['nl-NL'] = {
		symbol: '€',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['nn-NO'] = {
		symbol: 'kr',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['nso-ZA'] = {
		symbol: 'R',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['oc-FR'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['or-IN'] = {
		symbol: 'ଟ',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['pa-IN'] = {
		symbol: 'ਰੁ',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['pl-PL'] = {
		symbol: 'zł',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['prs-AF'] = {
		symbol: '؋',
		positiveFormat: '%s%n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ps-AF'] = {
		symbol: '؋',
		positiveFormat: '%s%n',
		negativeFormat: '%s%n-',
		decimalSymbol: '٫',
		digitGroupSymbol: '٬',
		groupDigits: true
	};

	$.formatCurrency.regions['pt-BR'] = {
		symbol: 'R$',
		positiveFormat: '%s %n',
		negativeFormat: '-%s %n',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['pt-PT'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['qut-GT'] = {
		symbol: 'Q',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['quz-BO'] = {
		symbol: '$b',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['quz-EC'] = {
		symbol: '$',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['quz-PE'] = {
		symbol: 'S/.',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['rm-CH'] = {
		symbol: 'fr.',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: '\'',
		groupDigits: true
	};

	$.formatCurrency.regions['ro-RO'] = {
		symbol: 'lei',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['ru-RU'] = {
		symbol: 'р.',
		positiveFormat: '%n%s',
		negativeFormat: '-%n%s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['rw-RW'] = {
		symbol: 'RWF',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['sa-IN'] = {
		symbol: 'रु',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['sah-RU'] = {
		symbol: 'с.',
		positiveFormat: '%n%s',
		negativeFormat: '-%n%s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['se-FI'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['se-NO'] = {
		symbol: 'kr',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['se-SE'] = {
		symbol: 'kr',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['si-LK'] = {
		symbol: 'රු.',
		positiveFormat: '%s %n',
		negativeFormat: '(%s %n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['sk-SK'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['sl-SI'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['sma-NO'] = {
		symbol: 'kr',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['sma-SE'] = {
		symbol: 'kr',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['smj-NO'] = {
		symbol: 'kr',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['smj-SE'] = {
		symbol: 'kr',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['smn-FI'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['sms-FI'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['sq-AL'] = {
		symbol: 'Lek',
		positiveFormat: '%n%s',
		negativeFormat: '-%n%s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['sr-Cyrl-BA'] = {
		symbol: 'КМ',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['sr-Cyrl-CS'] = {
		symbol: 'Дин.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['sr-Latn-BA'] = {
		symbol: 'KM',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['sr-Latn-CS'] = {
		symbol: 'Din.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['sv-FI'] = {
		symbol: '€',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['sv-SE'] = {
		symbol: 'kr',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['sw-KE'] = {
		symbol: 'S',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['syr-SY'] = {
		symbol: 'ل.س.‏',
		positiveFormat: '%s %n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ta-IN'] = {
		symbol: 'ரூ',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['te-IN'] = {
		symbol: 'రూ',
		positiveFormat: '%s %n',
		negativeFormat: '%s -%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['tg-Cyrl-TJ'] = {
		symbol: 'т.р.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ';',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['th-TH'] = {
		symbol: '฿',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['tk-TM'] = {
		symbol: 'm.',
		positiveFormat: '%n%s',
		negativeFormat: '-%n%s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['tn-ZA'] = {
		symbol: 'R',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['tr-TR'] = {
		symbol: 'TL',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['tt-RU'] = {
		symbol: 'р.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['tzm-Latn-DZ'] = {
		symbol: 'DZD',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['ug-CN'] = {
		symbol: '¥',
		positiveFormat: '%s%n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['uk-UA'] = {
		symbol: 'грн.',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['ur-PK'] = {
		symbol: 'Rs',
		positiveFormat: '%s%n',
		negativeFormat: '%s%n-',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['uz-Cyrl-UZ'] = {
		symbol: 'сўм',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['uz-Latn-UZ'] = {
		symbol: 'su\'m',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['vi-VN'] = {
		symbol: '₫',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: '.',
		groupDigits: true
	};

	$.formatCurrency.regions['wo-SN'] = {
		symbol: 'XOF',
		positiveFormat: '%n %s',
		negativeFormat: '-%n %s',
		decimalSymbol: ',',
		digitGroupSymbol: ' ',
		groupDigits: true
	};

	$.formatCurrency.regions['xh-ZA'] = {
		symbol: 'R',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['yo-NG'] = {
		symbol: 'N',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['zh-CN'] = {
		symbol: '￥',
		positiveFormat: '%s%n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['zh-HK'] = {
		symbol: 'HK$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['zh-MO'] = {
		symbol: 'MOP',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['zh-SG'] = {
		symbol: '$',
		positiveFormat: '%s%n',
		negativeFormat: '(%s%n)',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['zh-TW'] = {
		symbol: 'NT$',
		positiveFormat: '%s%n',
		negativeFormat: '-%s%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['zh'] = {
		symbol: '¥',
		positiveFormat: '%s%n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

	$.formatCurrency.regions['zu-ZA'] = {
		symbol: 'R',
		positiveFormat: '%s %n',
		negativeFormat: '%s-%n',
		decimalSymbol: '.',
		digitGroupSymbol: ',',
		groupDigits: true
	};

})(jQuery);
